/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.vwobstub;

import java.util.List;
import org.appdapter.core.log.BasicDebugger;
import org.appdapter.core.name.Ident;
import org.cogchar.api.skeleton.config.BoneProjectionRange;
import org.cogchar.bind.mio.robot.model.ModelJoint;
import org.cogchar.bind.mio.robot.model.ModelRobot;
import org.cogchar.render.model.bony.FigureState;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.friendularity.vwobstub.ModelToFigureStateMappingFuncs;

public class VWorldRoboPump
extends BasicDebugger {
    Ident myPumpID;
    ModelRobot myModelRobot;
    HumanoidFigure myHumaFig;

    public VWorldRoboPump(Ident pumpID, ModelRobot mr, HumanoidFigure hf) {
        this.myPumpID = pumpID;
        this.myModelRobot = mr;
        this.myHumaFig = hf;
    }

    public boolean completeSetup() {
        this.setupFigureState();
        this.registerMoveListener();
        return true;
    }

    protected void registerMoveListener() {
        PumpML ourPump = new PumpML();
        this.myModelRobot.registerMoveListener((ModelRobot.MoveListener)ourPump);
    }

    protected void setupFigureState() {
        FigureState fs = this.buildFigureState(this.myModelRobot);
        this.getLogger().info("FigureState={}", (Object)fs);
        if (this.myHumaFig != null) {
            this.myHumaFig.setFigureState(fs);
        } else {
            this.getLogger().warn("figState aborting due to missing HumanoidFigure, for pumpID={}", (Object)this.myPumpID);
        }
    }

    private FigureState buildFigureState(ModelRobot br) {
        FigureState fs = new FigureState();
        List allJoints = br.getJointList();
        for (ModelJoint mJoint : allJoints) {
            for (BoneProjectionRange bpr : mJoint.getBoneRotationRanges()) {
                String boneName = bpr.getBoneName();
                fs.obtainBoneState(boneName);
            }
        }
        return fs;
    }

    class PumpML
    implements ModelRobot.MoveListener {
        PumpML() {
        }

        public void notifyBonyRobotMoved(ModelRobot br) {
            if (br != null & VWorldRoboPump.this.myHumaFig != null) {
                ModelToFigureStateMappingFuncs.propagateState(br, VWorldRoboPump.this.myHumaFig);
            }
        }
    }
}

