/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.security.MessageDigest;
import java.security.SecureRandom;
import net.liftweb.util.Helpers$;
import net.liftweb.util.SecurityHelpers;
import org.apache.commons.codec.binary.Base64;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public abstract class SecurityHelpers$class {
    private static Object withRandom(SecurityHelpers $this, Function1 f) {
        SecureRandom secureRandom = $this.net$liftweb$util$SecurityHelpers$$_random();
        synchronized (secureRandom) {
            Object object = f.apply((Object)$this.net$liftweb$util$SecurityHelpers$$_random());
            return object;
        }
    }

    public static long randomLong(SecurityHelpers $this, long mod) {
        return BoxesRunTime.unboxToLong((Object)SecurityHelpers$class.withRandom($this, (Function1)new Serializable($this, mod){
            public static final long serialVersionUID = 0L;
            private final long mod$1;

            public final long apply(SecureRandom random) {
                return package$.MODULE$.abs(random.nextLong()) % this.mod$1;
            }
            {
                this.mod$1 = mod$1;
            }
        }));
    }

    public static int randomInt(SecurityHelpers $this, int mod) {
        return BoxesRunTime.unboxToInt((Object)SecurityHelpers$class.withRandom($this, (Function1)new Serializable($this, mod){
            public static final long serialVersionUID = 0L;
            private final int mod$2;

            public final int apply(SecureRandom random) {
                return package$.MODULE$.abs(random.nextInt()) % this.mod$2;
            }
            {
                this.mod$2 = mod$2;
            }
        }));
    }

    public static boolean shouldShow(SecurityHelpers $this, double percent2) {
        return BoxesRunTime.unboxToBoolean((Object)SecurityHelpers$class.withRandom($this, (Function1)new Serializable($this, percent2){
            public static final long serialVersionUID = 0L;
            private final double percent$1;

            public final boolean apply(SecureRandom x$1) {
                return x$1.nextDouble() <= this.percent$1;
            }
            {
                this.percent$1 = percent$1;
            }
        }));
    }

    private static final byte[] cleanArray(SecurityHelpers $this, byte[] in2) {
        return (byte[])Predef$.MODULE$.byteArrayOps(in2).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(byte a2) {
                return a2 >= 32 && a2 <= 127;
            }
        });
    }

    public static String base64Encode(SecurityHelpers $this, byte[] in2) {
        return new String(SecurityHelpers$class.cleanArray($this, new Base64().encode(in2)));
    }

    public static String base64EncodeURLSafe(SecurityHelpers $this, byte[] in2) {
        return new String(Base64.encodeBase64URLSafe((byte[])in2));
    }

    public static byte[] base64Decode(SecurityHelpers $this, String in2) {
        return new Base64().decode(in2.getBytes("UTF-8"));
    }

    public static byte[] md5(SecurityHelpers $this, byte[] in2) {
        return MessageDigest.getInstance("MD5").digest(in2);
    }

    public static String md5(SecurityHelpers $this, String in2) {
        return $this.base64Encode($this.md5(in2.getBytes("UTF-8")));
    }

    public static byte[] hash(SecurityHelpers $this, byte[] in2) {
        return MessageDigest.getInstance("SHA").digest(in2);
    }

    public static String hash(SecurityHelpers $this, String in2) {
        return $this.base64Encode(MessageDigest.getInstance("SHA").digest(in2.getBytes("UTF-8")));
    }

    public static String hashHex(SecurityHelpers $this, String in2) {
        return Helpers$.MODULE$.hexEncode(MessageDigest.getInstance("SHA").digest(in2.getBytes("UTF-8")));
    }

    public static boolean secureEquals(SecurityHelpers $this, String s1, String s2) {
        Tuple2 tuple2;
        block6: {
            boolean bl;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            tuple2 = new Tuple2((Object)s1, (Object)s2);
                            if (tuple2 == null) break block2;
                            String p2 = (String)tuple2._1();
                            String p3 = (String)tuple2._2();
                            if (p2 != null) break block2;
                            String x8 = p2;
                            if (p3 != null) break block2;
                            String x9 = p3;
                            bl = true;
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        String p4 = (String)tuple2._1();
                        String p5 = (String)tuple2._2();
                        if (p4 != null) break block4;
                        String x10 = p4;
                        bl = false;
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    String p6 = (String)tuple2._1();
                    String p7 = (String)tuple2._2();
                    if (p7 != null) break block5;
                    String x11 = p7;
                    bl = false;
                    break block3;
                }
                if (tuple2 == null) break block6;
                String a2 = (String)tuple2._1();
                String b = (String)tuple2._2();
                bl = $this.secureEquals(a2.getBytes("UTF-8"), b.getBytes("UTF-8"));
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public static boolean secureEquals(SecurityHelpers $this, byte[] s1, byte[] s2) {
        Tuple2 tuple2;
        block7: {
            boolean bl;
            block4: {
                block6: {
                    block5: {
                        block3: {
                            tuple2 = new Tuple2((Object)s1, (Object)s2);
                            if (tuple2 == null) break block3;
                            byte[] p2 = (byte[])tuple2._1();
                            byte[] p3 = (byte[])tuple2._2();
                            if (p2 != null) break block3;
                            byte[] x8 = p2;
                            if (p3 != null) break block3;
                            byte[] x9 = p3;
                            bl = true;
                            break block4;
                        }
                        if (tuple2 == null) break block5;
                        byte[] p4 = (byte[])tuple2._1();
                        byte[] p5 = (byte[])tuple2._2();
                        if (p4 != null) break block5;
                        byte[] x10 = p4;
                        bl = false;
                        break block4;
                    }
                    if (tuple2 == null) break block6;
                    byte[] p6 = (byte[])tuple2._1();
                    byte[] p7 = (byte[])tuple2._2();
                    if (p7 != null) break block6;
                    byte[] x11 = p7;
                    bl = false;
                    break block4;
                }
                if (tuple2 == null) break block7;
                byte[] a2 = (byte[])tuple2._1();
                byte[] b = (byte[])tuple2._2();
                int la = a2.length;
                int lb = b.length;
                boolean ret = true;
                for (int pos = 0; pos < la && pos < lb; ++pos) {
                    ret &= a2[pos] == b[pos];
                }
                bl = ret && la == lb;
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public static byte[] hash256(SecurityHelpers $this, byte[] in2) {
        return MessageDigest.getInstance("SHA-256").digest(in2);
    }

    public static String hash256(SecurityHelpers $this, String in2) {
        return $this.base64Encode(MessageDigest.getInstance("SHA-256").digest(in2.getBytes("UTF-8")));
    }

    public static String hexDigest(SecurityHelpers $this, byte[] in2) {
        byte[] binHash = MessageDigest.getInstance("SHA").digest(in2);
        return $this.hexEncode(binHash);
    }

    public static String hexDigest256(SecurityHelpers $this, byte[] in2) {
        byte[] binHash = MessageDigest.getInstance("SHA-256").digest(in2);
        return $this.hexEncode(binHash);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] hexDecode(SecurityHelpers $this, String str) {
        void var3_3;
        int max2 = str.length() / 2;
        byte[] ret = new byte[max2];
        for (int pos = 0; pos < max2; ++pos) {
            int two = pos * 2;
            char ch = str.charAt(two);
            char cl = str.charAt(two + 1);
            ret[pos] = (byte)(SecurityHelpers$class.byteOf$1($this, ch) * 16 + SecurityHelpers$class.byteOf$1($this, cl));
        }
        return var3_3;
    }

    public static String hexEncode(SecurityHelpers $this, byte[] in2) {
        StringBuilder sb = new StringBuilder();
        int len = in2.length;
        SecurityHelpers$class.addDigit$1($this, in2, 0, len, sb);
        return sb.toString();
    }

    private static final int byteOf$1(SecurityHelpers $this, char in2) {
        int n;
        char c = in2;
        switch (c) {
            default: {
                n = 0;
                break;
            }
            case 'F': 
            case 'f': {
                n = 15;
                break;
            }
            case 'E': 
            case 'e': {
                n = 14;
                break;
            }
            case 'D': 
            case 'd': {
                n = 13;
                break;
            }
            case 'C': 
            case 'c': {
                n = 12;
                break;
            }
            case 'B': 
            case 'b': {
                n = 11;
                break;
            }
            case 'A': 
            case 'a': {
                n = 10;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '0': {
                n = 0;
            }
        }
        return n;
    }

    private static final void addDigit$1(SecurityHelpers $this, byte[] in2, int pos, int len, StringBuilder sb) {
        while (pos < len) {
            byte b = in2[pos];
            int msb = (b & 0xF0) >> 4;
            int lsb = b & 0xF;
            sb.append(msb < 10 ? (char)(48 + msb) : (char)(97 + (msb - 10)));
            sb.append(lsb < 10 ? (char)(48 + lsb) : (char)(97 + (lsb - 10)));
            ++pos;
        }
    }

    public static void $init$(SecurityHelpers $this) {
        $this.net$liftweb$util$SecurityHelpers$_setter_$net$liftweb$util$SecurityHelpers$$_random_$eq(new SecureRandom());
    }
}

