/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.StringReader;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser;
import net.liftweb.json.JsonParser$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class JsonParser$ {
    public static final JsonParser$ MODULE$;
    private final BigDecimal BrokenDouble;
    private final Function1<JsonParser.Parser, JsonAST.JValue> astParser;
    private final char net$liftweb$json$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(String s) {
        return this.parse(new JsonParser.Buffer(new StringReader(s), false));
    }

    public JsonAST.JValue parse(Reader s, boolean closeAutomatically) {
        return this.parse(new JsonParser.Buffer(s, closeAutomatically));
    }

    public Option<JsonAST.JValue> parseOpt(String s) {
        Option<JsonAST.JValue> option;
        try {
            option = this.parse(s).toOpt();
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JsonAST.JValue> parseOpt(Reader s, boolean closeAutomatically) {
        Option<JsonAST.JValue> option;
        try {
            option = this.parse(s, closeAutomatically).toOpt();
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        return option;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p2) {
        return this.parse((Reader)new StringReader(s), p2);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p2) {
        return (A)p2.apply((Object)new JsonParser.Parser(new JsonParser.Buffer(s, false)));
    }

    private JsonAST.JValue parse(JsonParser.Buffer buf) {
        try {
            return (JsonAST.JValue)this.astParser().apply((Object)new JsonParser.Parser(buf));
        }
        catch (Exception exception) {
            throw new JsonParser.ParseException("parsing failed", exception);
        }
        catch (JsonParser.ParseException parseException) {
            throw parseException;
        }
        finally {
            buf.release();
        }
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public String unquote(String string2) {
        return this.unquote(new JsonParser.Buffer(new StringReader(string2), false));
    }

    public String unquote(JsonParser.Buffer buf) {
        buf.eofIsFailure_$eq(true);
        buf.mark();
        char c = buf.next();
        while (c != '\"') {
            if (c == '\\') {
                String s = this.unquote0$1(buf, buf.substring());
                buf.eofIsFailure_$eq(false);
                return s;
            }
            c = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return buf.substring();
    }

    private BigDecimal BrokenDouble() {
        return this.BrokenDouble;
    }

    public double parseDouble(String s) {
        BigDecimal d = scala.package$.MODULE$.BigDecimal().apply(s);
        if (BoxesRunTime.equalsNumNum((Number)d, (Number)this.BrokenDouble())) {
            throw package$.MODULE$.error("Error parsing 2.2250738585072012e-308");
        }
        return d.doubleValue();
    }

    private Function1<JsonParser.Parser, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    public char net$liftweb$json$JsonParser$$EOF() {
        return this.net$liftweb$json$JsonParser$$EOF;
    }

    private final String unquote0$1(JsonParser.Buffer buf, String base) {
        StringBuilder s = new StringBuilder(base);
        char c = '\\';
        while (c != '\"') {
            StringBuilder stringBuilder;
            if (c == '\\') {
                char c2 = buf.next();
                switch (c2) {
                    default: {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case 'u': {
                        char[] chars = new char[]{buf.next(), buf.next(), buf.next(), buf.next()};
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s.appendCodePoint(codePoint);
                        break;
                    }
                    case 't': {
                        stringBuilder = s.append('\t');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s.append('\r');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s.append('\n');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s.append('\b');
                        break;
                    }
                    case '/': {
                        stringBuilder = s.append('/');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuilder = s.append('\"');
                        break;
                    }
                }
            } else {
                stringBuilder = s.append(c);
            }
            c = buf.next();
        }
        return s.toString();
    }

    private JsonParser$() {
        MODULE$ = this;
        this.BrokenDouble = scala.package$.MODULE$.BigDecimal().apply("2.2250738585072012e-308");
        this.astParser = new anonfun.2();
        this.net$liftweb$json$JsonParser$$EOF = (char)-1;
    }
}

