/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.demo.lifecycles;

import java.util.Collections;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.friendularity.demo.lifecycles.RemoteSpeechServiceLifecycle;
import org.friendularity.demo.lifecycles.VisemeBindingManagerLifecycle;
import org.friendularity.demo.lifecycles.VisemeEventNotifierLifecycle;
import org.jflux.api.registry.Descriptor;
import org.jflux.api.registry.Registry;
import org.jflux.api.registry.basic.BasicDescriptor;
import org.jflux.api.service.ServiceLifecycle;
import org.jflux.api.service.ServiceManager;
import org.jflux.api.service.binding.ServiceBinding;
import org.jflux.impl.registry.OSGiRegistry;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponentFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.motion.Robot;
import org.robokind.api.speech.SpeechConfig;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.speech.RemoteSpeechUtils;
import org.robokind.integration.motion_speech.VisemeMotionUtils;
import org.rwshop.swing.common.lifecycle.ServicesFrame;

public class Activator
implements BundleActivator {
    public static final String SPEECH_DEFAULT_PREFIX = "speech";

    public void start(BundleContext context) throws Exception {
        OSGiComponentFactory factory = new OSGiComponentFactory(context);
        String speechConnectionConfigId = "speechServiceConnectionConfig";
        String speechServiceId = "speechService_01";
        String robotId = "myRobot01";
        String ipAddress = "127.0.0.1";
        String visemeConfigPath = "VisemeConf.json";
        Activator.startServiceFrame(context);
        Activator.startSpeech((ManagedServiceFactory)factory, speechConnectionConfigId, ipAddress, speechServiceId);
        Activator.startVisemes((ManagedServiceFactory)factory, robotId, speechServiceId, visemeConfigPath);
        RemoteSpeechServiceLifecycle l = new RemoteSpeechServiceLifecycle();
        HashMap<String, ServiceBinding> bindings = new HashMap<String, ServiceBinding>();
        int i = 0;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("messageSenderId", "speechService_01/RKSpeechGroup/speechCommand/RKMessagingGroup/remoteNotifier");
        props.put("messageType", ServiceCommand.class.getName());
        BasicDescriptor d = new BasicDescriptor(l.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ++i;
        props = new HashMap();
        props.put("messageSenderId", "speechService_01/RKSpeechGroup/speechConfig/RKMessagingGroup/remoteNotifier");
        props.put("messageType", SpeechConfig.class.getName());
        d = new BasicDescriptor(l.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ++i;
        props = new HashMap();
        props.put("messageReceiverId", "speechService_01/RKSpeechGroup/speechError/RKMessagingGroup/remoteListener");
        props.put("messageType", ServiceError.class.getName());
        d = new BasicDescriptor(l.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ++i;
        ++i;
        props = new HashMap();
        props.put("messageSenderId", "speechService_01/RKSpeechGroup/speechRequest/RKMessagingGroup/remoteNotifier");
        props.put("messageType", SpeechRequest.class.getName());
        d = new BasicDescriptor(l.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ++i;
        props = new HashMap();
        props.put("messageReceiverId", "speechService_01/RKSpeechGroup/speechEvent/RKMessagingGroup/remoteListener");
        props.put("messageType", SpeechEventList.class.getName());
        d = new BasicDescriptor(l.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ServiceManager m = new ServiceManager((ServiceLifecycle)l, bindings, Collections.EMPTY_MAP, null);
        VisemeEventNotifierLifecycle l2 = new VisemeEventNotifierLifecycle();
        bindings = new HashMap();
        i = 0;
        props = new HashMap();
        props.put("speechServiceId", "speechService_01");
        d = new BasicDescriptor(l2.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l2.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l2.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ServiceManager m2 = new ServiceManager((ServiceLifecycle)l2, bindings, Collections.EMPTY_MAP, null);
        VisemeBindingManagerLifecycle l3 = new VisemeBindingManagerLifecycle();
        bindings = new HashMap();
        i = 0;
        props = new HashMap();
        d = new BasicDescriptor(l3.getServiceDependencys().get(i).getDependencyClassName(), props);
        bindings.put(l3.getServiceDependencys().get(i).getDependencyName(), new ServiceBinding(l3.getServiceDependencys().get(i), (Descriptor)d, ServiceBinding.BindingStrategy.LAZY));
        ServiceManager m3 = new ServiceManager((ServiceLifecycle)l3, bindings, Collections.EMPTY_MAP, null);
        m.start((Registry)new OSGiRegistry(context));
        m2.start((Registry)new OSGiRegistry(context));
        m3.start((Registry)new OSGiRegistry(context));
    }

    static void startServiceFrame(final BundleContext context) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServicesFrame frame = new ServicesFrame();
                frame.setBundleContext(context);
                frame.setVisible(true);
            }
        });
    }

    public static void startSpeech(ManagedServiceFactory fact, String speechConnectConfigId, String ipAddress, String speechServiceId) {
        RKMessagingConfigUtils.registerConnectionConfig((String)speechConnectConfigId, (String)ipAddress, null, (ManagedServiceFactory)fact);
        RemoteSpeechUtils.connect((ManagedServiceFactory)fact, (String)speechServiceId, (String)SPEECH_DEFAULT_PREFIX, (String)speechConnectConfigId);
    }

    public static void startVisemes(ManagedServiceFactory fact, String robotId, String speechServiceId, String visemeConfigPath) {
        VisemeMotionUtils.startVisemeFrameSourceGroup((ManagedServiceFactory)fact, (Robot.Id)new Robot.Id(robotId), (String)speechServiceId, (String)visemeConfigPath);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

