/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.api.west;

import java.util.HashSet;
import java.util.Set;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.friendularity.api.west.PersonEstimate;
import org.friendularity.api.west.StuffEstimate;
import org.friendularity.api.west.WorldEstimate;

public class EstimateLib {
    public static Set<PersonEstimate> makeFunPersonEstims() {
        HashSet<PersonEstimate> sampleSet = new HashSet<PersonEstimate>();
        for (int i = 0; i < 10; ++i) {
            FreeIdent personID = new FreeIdent(WorldEstimate.ESTIM_NS + "person_estim_0" + i);
            PersonEstimate pest = new PersonEstimate((Ident)personID, i);
            double px = -10.0 - (double)i * 2.0;
            double py = 10.0 + (double)i * 2.0;
            double pz = 4.0;
            String baseVecExpr = "{" + px + ", " + py + ", " + pz + "}";
            sampleSet.add(pest);
        }
        return sampleSet;
    }

    public static Set<StuffEstimate> makeFunStuffEstims(int jMax, int kMax) {
        HashSet<StuffEstimate> sampleSet = new HashSet<StuffEstimate>();
        for (int j = 1; j <= jMax; ++j) {
            FreeIdent stuffID = new FreeIdent(WorldEstimate.ESTIM_NS + "stuff_estim_0" + j);
            StuffEstimate sest = new StuffEstimate((Ident)stuffID, j);
            double px = 15.0 + (double)j * 3.0;
            double py = 10.0 + (double)j * 3.0;
            double pz = -12.0;
            String baseVecExpr = "{" + px + ", " + py + ", " + pz + "}";
            sampleSet.add(sest);
        }
        for (int k = 1; k <= kMax; ++k) {
            int stuffIdx = k + jMax;
            FreeIdent stuffID = new FreeIdent(WorldEstimate.ESTIM_NS + "stuff_estim_0" + stuffIdx);
            StuffEstimate sest = new StuffEstimate((Ident)stuffID, stuffIdx);
            double px = 15.0 + (double)k * 3.0;
            double py = 10.0 + (double)k * 3.0;
            double pz = -25.0;
            double kFrac = (double)k / (double)kMax;
            double red = 0.4;
            double green = 0.2;
            double blue = 0.8;
            double alpha = kFrac;
            sampleSet.add(sest);
        }
        return sampleSet;
    }
}

