/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.ignore.shrill;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.appdapter.core.item.Item;
import org.appdapter.core.matdat.OnlineSheetRepoSpec;
import org.appdapter.core.name.Ident;
import org.appdapter.core.store.ModelClient;
import org.appdapter.core.store.Repo;
import org.appdapter.help.repo.RepoClient;
import org.appdapter.help.repo.RepoClientImpl;
import org.appdapter.impl.store.FancyRepo;
import org.appdapter.impl.store.ModelClientImpl;
import org.cogchar.api.space.TextVal;
import org.cogchar.bind.symja.MathGate;
import org.friendularity.ignore.shrill.DubArrTextVal;
import org.friendularity.ignore.shrill.MathGraphBinding;
import org.friendularity.ignore.shrill.MathTextSource;
import org.friendularity.respire.RespirationTest$;
import org.friendularity.respire.VarargsLogging;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Set;

public final class EqnExtractors$
extends VarargsLogging {
    public static final EqnExtractors$ MODULE$;
    private final String NOT_FOUND_EXPR;

    static {
        new EqnExtractors$();
    }

    public String NOT_FOUND_EXPR() {
        return this.NOT_FOUND_EXPR;
    }

    public void main(String[] args) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ALL);
        OnlineSheetRepoSpec rspec = RespirationTest$.MODULE$.makeDfltOSRS();
        this.getLogger().info("Let's load some equations from different properties in our source models at: {}", new Object[]{rspec});
        FancyRepo dfltTestRepo = rspec.makeRepo();
        RepoClientImpl dfltTestRC = rspec.makeRepoClient((Repo.WithDirectory)dfltTestRepo);
        String mathSrcGraphQN = "ccrti:math_sheet_60";
        this.testMathGraphLoadEval((Repo)dfltTestRepo, (RepoClient)dfltTestRC, mathSrcGraphQN);
        this.getLogger().info("Finito!");
    }

    public void testMathGraphLoadEval(Repo dfltTestRepo, RepoClient dfltTestRC, String mathSrcGraphQN) {
        String mathSheetQN = mathSrcGraphQN;
        Ident mathGraphID = dfltTestRC.makeIdentForQName(mathSheetQN);
        Model mathGraph = dfltTestRepo.getNamedModel(mathGraphID);
        this.ensurePrefixesAligned(mathGraph);
        ModelClientImpl mathMCI = new ModelClientImpl(mathGraph);
        MathGraphBinding mgb = new MathGraphBinding((ModelClient)mathMCI);
        this.testMathWithKnownItems(mgb.myGate(), mgb.myMathTxtSrc());
        this.findMathItemsByType(mgb.myMathTxtSrc());
    }

    public void findMathItemsByType(MathTextSource mathTxtSrc) {
        Set<Item> allFuncDefs = mathTxtSrc.getIndivsMatchingTypeSel(mathTxtSrc.myFuncDefIndivSel());
        Set<Item> allFullExprs = mathTxtSrc.getIndivsMatchingTypeSel(mathTxtSrc.myFullExprIndivSel());
        this.info1("All funcDefs size: {}", Predef$.MODULE$.int2Integer(allFuncDefs.size()));
        allFuncDefs.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Item check$ifrefutable$1) {
                Item item = check$ifrefutable$1;
                boolean bl = item != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(mathTxtSrc){
            public static final long serialVersionUID = 0L;
            private final MathTextSource mathTxtSrc$1;

            public final void apply(Item fdi) {
                String funcDefText = this.mathTxtSrc$1.funcDefText(fdi);
                EqnExtractors$.MODULE$.info2("Found funcDef at {} with Text: {}", fdi, funcDefText);
            }
            {
                this.mathTxtSrc$1 = mathTxtSrc$1;
            }
        });
        this.info1("All fullExprs size: {}", Predef$.MODULE$.int2Integer(allFullExprs.size()));
        allFullExprs.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Item check$ifrefutable$2) {
                Item item = check$ifrefutable$2;
                boolean bl = item != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(mathTxtSrc){
            public static final long serialVersionUID = 0L;
            private final MathTextSource mathTxtSrc$1;

            public final void apply(Item xi) {
                String posExprText = this.mathTxtSrc$1.positionExprText(xi);
                EqnExtractors$.MODULE$.info2("At {}, found posExpr-text: {}", xi, posExprText);
                String orientExprText = this.mathTxtSrc$1.orientExprText(xi);
                EqnExtractors$.MODULE$.info2("At {}, found orientExpr-text: {}", xi, orientExprText);
                String colorExprText = this.mathTxtSrc$1.colorExprText(xi);
                EqnExtractors$.MODULE$.info2("At {}, found colorExpr-text: {}", xi, colorExprText);
            }
            {
                this.mathTxtSrc$1 = mathTxtSrc$1;
            }
        });
    }

    public void ensurePrefixesAligned(Model mathGraph) {
        Map mathModelPrefixMap = mathGraph.getNsPrefixMap();
        this.debug0("\n\n*************************************************************");
        this.debug1("Fetched math prefix-map - if this is empty, then all the QName-resolves below will fail: {} ", mathModelPrefixMap);
        this.debug0("*************************************************************\n\n");
        if (mathModelPrefixMap.size() == 0) {
            mathGraph.setNsPrefix("hev", "urn:ftd:headyspace.org:2013:estimviz_type#");
            mathGraph.setNsPrefix("hevi", "urn:ftd:headyspace.org:2013:estimviz_inst#");
        }
    }

    public void testMathWithKnownItems(MathGate mg, MathTextSource mathTxtSrc) {
        Tuple2 tuple2 = new Tuple2((Object)"hevi:test_01", (Object)"hevi:test_02");
        if (tuple2 != null) {
            Tuple2 tuple22;
            String eq1_QN = (String)tuple2._1();
            String eq2_QN = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)eq1_QN, (Object)eq2_QN);
            String eq1_QN2 = (String)tuple23._1();
            String eq2_QN2 = (String)tuple23._2();
            this.findEvalAndPrintPosExpr(eq1_QN2, mg, mathTxtSrc);
            this.findEvalAndPrintPosExpr(eq2_QN2, mg, mathTxtSrc);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public double[] findEvalAndPrintPosExpr(String exprIndivQN, MathGate mg, MathTextSource mTxtSrc) {
        Item indivItem = mTxtSrc.findParentItem(exprIndivQN);
        this.debug2("At indiv-QN {} found expr-Item: {}", exprIndivQN, indivItem);
        return this.evalAndPrintPos(indivItem, mg, mTxtSrc);
    }

    public double[] evalAndPrintPos(Item indivItem, MathGate mg, MathTextSource mTxtSrc) {
        String localDebugName = indivItem.getIdent().getLocalName();
        String posExprText = mTxtSrc.positionExprText(indivItem);
        double[] posOutDubVec = mg.parseAndEvalExprToDoubleVec(posExprText, null);
        this.info3("At local {}, .pos-expr {} evals to double-vec {}", localDebugName, posExprText, Predef$.MODULE$.doubleArrayOps(posOutDubVec).deep());
        return posOutDubVec;
    }

    /*
     * WARNING - void declaration
     */
    public TextVal makeEqnTextVal() {
        void var1_1;
        TextVal tvCand = new TextVal("some eqn text");
        return var1_1;
    }

    public void updateResultTextVal(DubArrTextVal toUpdate, double[] resDubArr) {
    }

    private EqnExtractors$() {
        MODULE$ = this;
        this.NOT_FOUND_EXPR = "None";
    }
}

