/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.impl.visual;

import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.HashMap;
import java.util.Map;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.cogchar.api.cinema.CameraConfig;
import org.cogchar.name.thing.ThingCN;
import org.cogchar.render.app.entity.CameraBinding;
import org.cogchar.render.goody.dynamic.VizShapeSiblingGroup;
import org.cogchar.render.model.humanoid.HumanoidFigureManager;
import org.cogchar.render.opengl.optic.CameraMgr;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.cogchar.render.trial.TrialContent;
import org.friendularity.api.west.SelfEstimate;
import org.friendularity.impl.visual.BaseVisualizer;

public class DeicticVisualizer
extends BaseVisualizer<SelfEstimate> {
    private TrialContent myTrialContent;
    private boolean myFlag_NeutralizationComplete = false;
    private CameraNode mySinbadEyeCamNode;
    private Map<String, Node> myAttachNodesByName = new HashMap<String, Node>();
    String[] interestingBoneNames = new String[]{"Eye.R", "Head", "Root"};

    public DeicticVisualizer(BaseVisualizer<?> otherViz) {
        super(otherViz);
    }

    public void connectToTrialContent(TrialContent tc) {
        this.myTrialContent = tc;
    }

    private void ensureSetup() {
        if (this.myTrialContent == null) {
            this.myTrialContent = new TrialContent();
        }
    }

    public void forceHeadCameraOntoSinbad() {
        CameraNode sinbadEyeCamNode;
        this.ensureSetup();
        FreeIdent camID = new FreeIdent("uri:cameraConfig#sinbadHeadCam");
        float[] camPos = new float[]{0.0f, 0.0f, 1.0f};
        float[] camPointDir = new float[]{1.0f, 1.0f, 1.0f};
        float[] displayRect = new float[]{0.0f, 0.3f, 0.7f, 1.0f};
        CameraConfig hardHeadCC = new CameraConfig((Ident)camID, camPos, camPointDir, displayRect);
        FreeIdent sinbadRobotID = new FreeIdent(ThingCN.CCRT_NS + "char_sinbad_88");
        String leftEyeBoneName = "Eye.L";
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        hardHeadCC.setAttachmentNodeParams((Ident)sinbadRobotID, leftEyeBoneName);
        CameraMgr camMgr = rrc.getOpticCameraFacade(null);
        camMgr.applyCameraConfig(hardHeadCC, rrc);
        CameraBinding sinbadEyeCamBind = camMgr.getCameraBinding((Ident)camID);
        this.mySinbadEyeCamNode = sinbadEyeCamNode = sinbadEyeCamBind.getCameraNode();
        Node sinbadVizPyrNode = this.myTrialContent.makePointerCone(rrc, "sinbadEyeCam");
        sinbadEyeCamNode.attachChild((Spatial)sinbadVizPyrNode);
    }

    public void neutralizeEyeCamRotation(CameraNode eyeCamNode) {
        Quaternion eyeCamWorldRot = eyeCamNode.getWorldRotation();
        this.getLogger().info("EyeCam world rotation: {}", (Object)eyeCamWorldRot);
        Quaternion fixupRot = eyeCamWorldRot.inverse();
        eyeCamNode.setLocalRotation(fixupRot);
        this.myFlag_NeutralizationComplete = true;
    }

    public void putVizPyramidOnDefaultCam() {
        this.ensureSetup();
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        this.putVizPyramidOnDefaultCam(rrc);
    }

    public void putVizPyramidOnDefaultCam(RenderRegistryClient rrc) {
        CameraMgr camMgr = rrc.getOpticCameraFacade(null);
        AssetManager assetMgr = rrc.getJme3AssetManager(null);
        CameraBinding defFlyByCamBind = camMgr.getDefaultCameraBinding();
        Node dfbVizPyrNode = this.myTrialContent.makePointerCone(rrc, "defFlyBy");
        Node rootDeepNode = rrc.getJme3RootDeepNode(null);
        defFlyByCamBind.attachSceneNodeToCamera(dfbVizPyrNode, rootDeepNode);
    }

    private void registerBoneNodesOfInterest() {
        HumanoidFigureManager hfm = this.getHumanoidFigureManager();
        FreeIdent sinbadRobotID = new FreeIdent(ThingCN.CCRT_NS + "char_sinbad_88");
        for (String boneName : this.interestingBoneNames) {
            Node attachNode = hfm.findHumanoidBoneAttachNode((Ident)sinbadRobotID, boneName);
            this.myAttachNodesByName.put(boneName, attachNode);
        }
    }

    private void putDeicticPointingRayOnBone(String boneName) {
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        Node boneAttachNode = this.myAttachNodesByName.get(boneName);
        AssetManager assetMgr = rrc.getJme3AssetManager(null);
        Node pointNode = this.myTrialContent.makePointerCone(rrc, "viz_" + boneName);
        boneAttachNode.attachChild((Spatial)pointNode);
    }

    public void setupNiftyPointingRays() {
        this.ensureSetup();
        this.registerBoneNodesOfInterest();
        for (String boneName : this.interestingBoneNames) {
            this.putDeicticPointingRayOnBone(boneName);
        }
    }

    public void doUpdate(RenderRegistryClient rrc, float tpf) {
        if (!this.myFlag_NeutralizationComplete && this.mySinbadEyeCamNode != null) {
            this.neutralizeEyeCamRotation(this.mySinbadEyeCamNode);
        }
    }

    @Override
    public VizShapeSiblingGroup getShapeGroup() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void ensureDisplayed_onRendThrd(SelfEstimate te, float timePerFrame) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDisplay_onRendThrd(SelfEstimate te, float timePerFrame) {
        this.doUpdate(null, timePerFrame);
    }
}

