/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.impl.visual;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import org.appdapter.core.name.Ident;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.goody.dynamic.VizShape;
import org.cogchar.render.goody.dynamic.VizShapeSiblingGroup;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.friendularity.api.west.ThingEstimate;
import org.friendularity.impl.visual.BaseVisualizer;

public class SingleShapeVisualizer<TE extends ThingEstimate>
extends BaseVisualizer<TE> {
    public VizShape myCachedVizObject;
    private VizShapeSiblingGroup myShapeGroup;
    private Ident myOwnedShapeGroupID;

    public SingleShapeVisualizer(HumanoidRenderContext hrc, Ident ownedShapeGroupID) {
        super(hrc);
        this.myOwnedShapeGroupID = ownedShapeGroupID;
    }

    public SingleShapeVisualizer(HumanoidRenderContext hrc, VizShapeSiblingGroup existingGroup) {
        super(hrc);
        this.myShapeGroup = existingGroup;
    }

    public SingleShapeVisualizer(BaseVisualizer<?> otherViz, VizShapeSiblingGroup existingGroup) {
        super(otherViz);
        this.myShapeGroup = existingGroup;
    }

    @Override
    public VizShapeSiblingGroup getShapeGroup() {
        return this.myShapeGroup;
    }

    @Override
    public void ensureDisplayed_onRendThrd(TE te, float timePerFrame) {
        if (this.myShapeGroup == null) {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            this.myShapeGroup = new VizShapeSiblingGroup(this.myOwnedShapeGroupID);
            this.myShapeGroup.setupMaterials(rrc);
            this.myShapeGroup.enable_onRendThrd(rrc);
        }
        if (this.myCachedVizObject == null) {
            this.attachSimpleVizObj_onRendThrd(te);
        }
    }

    @Override
    public void updateDisplay_onRendThrd(TE te, float timePerFrame) {
    }

    protected void attachSimpleVizObj_onRendThrd(TE te) {
        this.getLogger().info("Attaching simple viz-object for {}" + te);
        float initRadius = 5.0f;
        ColorRGBA initColor = ColorRGBA.Red;
        Vector3f basePos = new Vector3f(35.0f, 35.0f, -5.0f);
        this.myCachedVizObject = new VizShape(((ThingEstimate)((Object)te)).getIdent(), basePos, initRadius, initColor);
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        VizShapeSiblingGroup vsg = this.getShapeGroup();
        vsg.configureMemberGeom_onRendThrd(rrc, this.myCachedVizObject);
    }
}

