/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.visual.shallow;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import org.friendularity.api.struct.MathExprNode;

public class VisualMathExprLib {

    public static class QuaternionExprNode
    extends MathExprNode<Quaternion> {
        public QuaternionExprNode(String mExpr, Quaternion initQuatObj) {
            super(mExpr, 4, initQuatObj);
        }

        public QuaternionExprNode(String mExpr) {
            this(mExpr, new Quaternion());
        }
    }

    public static class Vec3fExprNode
    extends MathExprNode<Vector3f> {
        public Vec3fExprNode(String mExpr, Vector3f initVectObj) {
            super(mExpr, 3, initVectObj);
        }

        public Vec3fExprNode(String mExpr) {
            this(mExpr, new Vector3f());
        }

        @Override
        protected void writeAnyNumericFromAnyDoublesBuf(Vector3f outVec3f, double[] buffer) {
            outVec3f.set((float)buffer[0], (float)buffer[1], (float)buffer[2]);
        }

        public Vector3f getVector3f() {
            return (Vector3f)this.getOutputObject();
        }
    }

    public static class ColorExprNode
    extends MathExprNode<ColorRGBA> {
        public ColorExprNode(String mExpr, ColorRGBA initColorObj) {
            super(mExpr, 4, initColorObj);
        }

        public ColorExprNode(String mExpr) {
            this(mExpr, new ColorRGBA());
        }

        @Override
        protected void writeAnyNumericFromAnyDoublesBuf(ColorRGBA outColor, double[] buffer) {
            outColor.set((float)buffer[0], (float)buffer[1], (float)buffer[2], (float)buffer[3]);
        }

        public ColorRGBA getColor() {
            return (ColorRGBA)this.getOutputObject();
        }
    }
}

