/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.system.AppSettings;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsDialog
extends JFrame {
    private static final Logger logger = Logger.getLogger(SettingsDialog.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int NO_SELECTION = 0;
    public static final int APPROVE_SELECTION = 1;
    public static final int CANCEL_SELECTION = 2;
    ResourceBundle resourceBundle = ResourceBundle.getBundle("com.jme3.app/SettingsDialog");
    private final AppSettings source;
    private URL imageFile = null;
    private DisplayMode[] modes = null;
    private static final DisplayMode[] windowDefaults = new DisplayMode[]{new DisplayMode(1024, 768, 24, 60), new DisplayMode(1280, 720, 24, 60), new DisplayMode(1280, 1024, 24, 60)};
    private DisplayMode[] windowModes = null;
    private JCheckBox vsyncBox = null;
    private JCheckBox fullscreenBox = null;
    private JComboBox displayResCombo = null;
    private JComboBox colorDepthCombo = null;
    private JComboBox displayFreqCombo = null;
    private JComboBox antialiasCombo = null;
    private JLabel icon = null;
    private int selection = 0;
    private SelectionListener selectionListener = null;
    private int minWidth = 0;
    private int minHeight = 0;

    public SettingsDialog(AppSettings source, String imageFile, boolean loadSettings) {
        this(source, SettingsDialog.getURL(imageFile), loadSettings);
    }

    public SettingsDialog(AppSettings source, URL imageFile, boolean loadSettings) {
        int mergedIndex;
        if (source == null) {
            throw new NullPointerException("Settings source cannot be null");
        }
        this.source = source;
        this.imageFile = imageFile;
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        AppSettings registrySettings = new AppSettings(true);
        String appTitle = source.getTitle() != null ? source.getTitle() : registrySettings.getTitle();
        this.minWidth = source.getMinWidth();
        this.minHeight = source.getMinHeight();
        try {
            registrySettings.load(appTitle);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, "Failed to load settings", ex);
        }
        if (loadSettings) {
            source.copyFrom(registrySettings);
        } else if (!registrySettings.isEmpty()) {
            source.mergeFrom(registrySettings);
        }
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.modes = device.getDisplayModes();
        Arrays.sort(this.modes, new DisplayModeSorter());
        DisplayMode[] merged = new DisplayMode[this.modes.length + windowDefaults.length];
        int wdIndex = 0;
        int dmIndex = 0;
        for (mergedIndex = 0; mergedIndex < merged.length && (wdIndex < windowDefaults.length || dmIndex < this.modes.length); ++mergedIndex) {
            if (dmIndex >= this.modes.length) {
                merged[mergedIndex] = windowDefaults[wdIndex++];
                continue;
            }
            if (wdIndex >= windowDefaults.length) {
                merged[mergedIndex] = this.modes[dmIndex++];
                continue;
            }
            if (this.modes[dmIndex].getWidth() < windowDefaults[wdIndex].getWidth()) {
                merged[mergedIndex] = this.modes[dmIndex++];
                continue;
            }
            if (this.modes[dmIndex].getWidth() == windowDefaults[wdIndex].getWidth()) {
                if (this.modes[dmIndex].getHeight() < windowDefaults[wdIndex].getHeight()) {
                    merged[mergedIndex] = this.modes[dmIndex++];
                    continue;
                }
                if (this.modes[dmIndex].getHeight() == windowDefaults[wdIndex].getHeight()) {
                    merged[mergedIndex] = this.modes[dmIndex++];
                    ++wdIndex;
                    continue;
                }
                merged[mergedIndex] = windowDefaults[wdIndex++];
                continue;
            }
            merged[mergedIndex] = windowDefaults[wdIndex++];
        }
        this.windowModes = merged.length == mergedIndex ? merged : Arrays.copyOfRange(merged, 0, mergedIndex);
        this.createUI();
    }

    public void setSelectionListener(SelectionListener sl) {
        this.selectionListener = sl;
    }

    public int getUserSelection() {
        return this.selection;
    }

    private void setUserSelection(int selection) {
        this.selection = selection;
        this.selectionListener.onSelection(selection);
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public void setImage(String image) {
        try {
            URL file = new URL("file:" + image);
            this.setImage(file);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Couldn\u2019t read from file '" + image + "'", e);
        }
    }

    public void setImage(URL image) {
        this.icon.setIcon(new ImageIcon(image));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void showDialog() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.toFront();
    }

    private void createUI() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SettingsDialog.this.setUserSelection(2);
                SettingsDialog.this.dispose();
            }
        });
        if (this.source.getIcons() != null) {
            this.safeSetIconImages(Arrays.asList((BufferedImage[])this.source.getIcons()));
        }
        this.setTitle(MessageFormat.format(this.resourceBundle.getString("frame.title"), this.source.getTitle()));
        JButton ok = new JButton(this.resourceBundle.getString("button.ok"));
        JButton cancel = new JButton(this.resourceBundle.getString("button.cancel"));
        this.icon = new JLabel(this.imageFile != null ? new ImageIcon(this.imageFile) : null);
        KeyAdapter aListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (SettingsDialog.this.verifyAndSaveCurrentSelection()) {
                        SettingsDialog.this.setUserSelection(1);
                        SettingsDialog.this.dispose();
                    }
                } else if (e.getKeyCode() == 27) {
                    SettingsDialog.this.setUserSelection(2);
                    SettingsDialog.this.dispose();
                }
            }
        };
        this.displayResCombo = this.setUpResolutionChooser();
        this.displayResCombo.addKeyListener(aListener);
        this.colorDepthCombo = new JComboBox();
        this.colorDepthCombo.addKeyListener(aListener);
        this.displayFreqCombo = new JComboBox();
        this.displayFreqCombo.addKeyListener(aListener);
        this.antialiasCombo = new JComboBox();
        this.antialiasCombo.addKeyListener(aListener);
        this.fullscreenBox = new JCheckBox(this.resourceBundle.getString("checkbox.fullscreen"));
        this.fullscreenBox.setSelected(this.source.isFullscreen());
        this.fullscreenBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.updateResolutionChoices();
            }
        });
        this.vsyncBox = new JCheckBox(this.resourceBundle.getString("checkbox.vsync"));
        this.vsyncBox.setSelected(this.source.isVSync());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.anchor = 13;
        mainPanel.add((Component)this.fullscreenBox, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 16, 0, 4);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        mainPanel.add((Component)this.vsyncBox, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.weightx = 0.5;
        mainPanel.add((Component)new JLabel(this.resourceBundle.getString("label.resolutions")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        mainPanel.add((Component)this.displayResCombo, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 16, 4, 4);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 13;
        mainPanel.add((Component)new JLabel(this.resourceBundle.getString("label.colordepth")), gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 17;
        mainPanel.add((Component)this.colorDepthCombo, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 13;
        mainPanel.add((Component)new JLabel(this.resourceBundle.getString("label.refresh")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        mainPanel.add((Component)this.displayFreqCombo, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 16, 4, 4);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 13;
        mainPanel.add((Component)new JLabel(this.resourceBundle.getString("label.antialias")), gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 17;
        mainPanel.add((Component)this.antialiasCombo, gbc);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SettingsDialog.this.verifyAndSaveCurrentSelection()) {
                    SettingsDialog.this.setUserSelection(1);
                    SettingsDialog.this.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setUserSelection(2);
                SettingsDialog.this.dispose();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 13;
        mainPanel.add((Component)ok, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 16, 4, 4);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        mainPanel.add((Component)cancel, gbc);
        if (this.icon != null) {
            gbc = new GridBagConstraints();
            gbc.gridwidth = 4;
            mainPanel.add((Component)this.icon, gbc);
        }
        this.getContentPane().add(mainPanel);
        this.pack();
        mainPanel.getRootPane().setDefaultButton(ok);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SettingsDialog.this.updateResolutionChoices();
                if (SettingsDialog.this.source.getWidth() != 0 && SettingsDialog.this.source.getHeight() != 0) {
                    SettingsDialog.this.displayResCombo.setSelectedItem(SettingsDialog.this.source.getWidth() + " x " + SettingsDialog.this.source.getHeight());
                } else {
                    SettingsDialog.this.displayResCombo.setSelectedIndex(SettingsDialog.this.displayResCombo.getItemCount() - 1);
                }
                SettingsDialog.this.updateAntialiasChoices();
                SettingsDialog.this.colorDepthCombo.setSelectedItem(SettingsDialog.this.source.getBitsPerPixel() + " bpp");
            }
        });
    }

    private void safeSetIconImages(List<? extends Image> icons) {
        try {
            Window owner = this.getOwner();
            if (owner != null) {
                Method setIconImages = owner.getClass().getMethod("setIconImages", List.class);
                setIconImages.invoke((Object)owner, icons);
                return;
            }
            Method setIconImages = this.getClass().getMethod("setIconImages", List.class);
            setIconImages.invoke((Object)this, icons);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error setting icon images", e);
        }
    }

    private boolean verifyAndSaveCurrentSelection() {
        String display = (String)this.displayResCombo.getSelectedItem();
        boolean fullscreen = this.fullscreenBox.isSelected();
        boolean vsync = this.vsyncBox.isSelected();
        int width = Integer.parseInt(display.substring(0, display.indexOf(" x ")));
        display = display.substring(display.indexOf(" x ") + 3);
        int height = Integer.parseInt(display);
        String depthString = (String)this.colorDepthCombo.getSelectedItem();
        int depth = -1;
        depth = depthString.equals("???") ? 0 : Integer.parseInt(depthString.substring(0, depthString.indexOf(32)));
        String freqString = (String)this.displayFreqCombo.getSelectedItem();
        int freq = -1;
        if (fullscreen) {
            freq = freqString.equals("???") ? 0 : Integer.parseInt(freqString.substring(0, freqString.indexOf(32)));
        }
        String aaString = (String)this.antialiasCombo.getSelectedItem();
        int multisample = -1;
        multisample = aaString.equals(this.resourceBundle.getString("antialias.disabled")) ? 0 : Integer.parseInt(aaString.substring(0, aaString.indexOf(120)));
        boolean valid = false;
        if (!fullscreen) {
            valid = true;
        } else {
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            valid = device.isFullScreenSupported();
        }
        if (valid) {
            this.source.setWidth(width);
            this.source.setHeight(height);
            this.source.setBitsPerPixel(depth);
            this.source.setFrequency(freq);
            this.source.setFullscreen(fullscreen);
            this.source.setVSync(vsync);
            this.source.setSamples(multisample);
            String appTitle = this.source.getTitle();
            try {
                this.source.save(appTitle);
            }
            catch (BackingStoreException ex) {
                logger.log(Level.WARNING, "Failed to save setting changes", ex);
            }
        } else {
            SettingsDialog.showError(this, this.resourceBundle.getString("error.unsupportedmode"));
        }
        return valid;
    }

    private JComboBox setUpResolutionChooser() {
        JComboBox resolutionBox = new JComboBox();
        resolutionBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.updateDisplayChoices();
            }
        });
        return resolutionBox;
    }

    private void updateDisplayChoices() {
        String displayFreq;
        if (!this.fullscreenBox.isSelected()) {
            return;
        }
        String resolution = (String)this.displayResCombo.getSelectedItem();
        String colorDepth = (String)this.colorDepthCombo.getSelectedItem();
        if (colorDepth == null) {
            colorDepth = this.source.getBitsPerPixel() + " bpp";
        }
        if ((displayFreq = (String)this.displayFreqCombo.getSelectedItem()) == null) {
            displayFreq = this.source.getFrequency() + " Hz";
        }
        String[] depths = SettingsDialog.getDepths(resolution, this.modes);
        this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(depths));
        this.colorDepthCombo.setSelectedItem(colorDepth);
        String[] freqs = SettingsDialog.getFrequencies(resolution, this.modes);
        this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(freqs));
        this.displayFreqCombo.setSelectedItem(displayFreq);
    }

    private void updateResolutionChoices() {
        if (!this.fullscreenBox.isSelected()) {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(this.getWindowedResolutions(this.windowModes)));
            if (this.displayResCombo.getItemCount() > 0) {
                this.displayResCombo.setSelectedIndex(this.displayResCombo.getItemCount() - 1);
            }
            this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"24 bpp", "16 bpp"}));
            this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.resourceBundle.getString("refresh.na")}));
            this.displayFreqCombo.setEnabled(false);
        } else {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(this.getResolutions(this.modes, Integer.MAX_VALUE, Integer.MAX_VALUE)));
            if (this.displayResCombo.getItemCount() > 0) {
                this.displayResCombo.setSelectedIndex(this.displayResCombo.getItemCount() - 1);
            }
            this.displayFreqCombo.setEnabled(true);
            this.updateDisplayChoices();
        }
    }

    private void updateAntialiasChoices() {
        String[] choices = new String[]{this.resourceBundle.getString("antialias.disabled"), "2x", "4x", "6x", "8x", "16x"};
        this.antialiasCombo.setModel(new DefaultComboBoxModel<String>(choices));
        this.antialiasCombo.setSelectedItem(choices[Math.min(this.source.getSamples() / 2, 5)]);
    }

    private static URL getURL(String file) {
        URL url = null;
        try {
            url = new URL("file:" + file);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Invalid file name '" + file + "'", e);
        }
        return url;
    }

    private static void showError(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error", 0);
    }

    private String[] getResolutions(DisplayMode[] modes, int heightLimit, int widthLimit) {
        Insets insets = this.getInsets();
        heightLimit -= insets.top + insets.bottom;
        widthLimit -= insets.left + insets.right;
        ArrayList<String> resolutions = new ArrayList<String>(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            String res;
            int height = modes[i].getHeight();
            int width = modes[i].getWidth();
            if (width < this.minWidth || height < this.minHeight) continue;
            if (height >= heightLimit) {
                height = heightLimit;
            }
            if (width >= widthLimit) {
                width = widthLimit;
            }
            if (resolutions.contains(res = width + " x " + height)) continue;
            resolutions.add(res);
        }
        String[] res = new String[resolutions.size()];
        resolutions.toArray(res);
        return res;
    }

    private String[] getWindowedResolutions(DisplayMode[] modes) {
        int maxHeight = 0;
        int maxWidth = 0;
        for (int i = 0; i < modes.length; ++i) {
            if (maxHeight < modes[i].getHeight()) {
                maxHeight = modes[i].getHeight();
            }
            if (maxWidth >= modes[i].getWidth()) continue;
            maxWidth = modes[i].getWidth();
        }
        return this.getResolutions(modes, maxHeight, maxWidth);
    }

    private static String[] getDepths(String resolution, DisplayMode[] modes) {
        ArrayList<String> depths = new ArrayList<String>(4);
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getBitDepth() < 16 && modes[i].getBitDepth() > 0) continue;
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            String depth = modes[i].getBitDepth() + " bpp";
            if (!res.equals(resolution) || depths.contains(depth)) continue;
            depths.add(depth);
        }
        if (depths.size() == 1 && depths.contains("-1 bpp")) {
            depths.clear();
            depths.add("24 bpp");
        }
        String[] res = new String[depths.size()];
        depths.toArray(res);
        return res;
    }

    private static String[] getFrequencies(String resolution, DisplayMode[] modes) {
        ArrayList<String> freqs = new ArrayList<String>(4);
        for (int i = 0; i < modes.length; ++i) {
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            String freq = modes[i].getRefreshRate() == 0 ? "???" : modes[i].getRefreshRate() + " Hz";
            if (!res.equals(resolution) || freqs.contains(freq)) continue;
            freqs.add(freq);
        }
        String[] res = new String[freqs.size()];
        freqs.toArray(res);
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplayModeSorter
    implements Comparator<DisplayMode> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayMode a, DisplayMode b) {
            if (a.getWidth() != b.getWidth()) {
                return a.getWidth() > b.getWidth() ? 1 : -1;
            }
            if (a.getHeight() != b.getHeight()) {
                return a.getHeight() > b.getHeight() ? 1 : -1;
            }
            if (a.getBitDepth() != b.getBitDepth()) {
                return a.getBitDepth() > b.getBitDepth() ? 1 : -1;
            }
            if (a.getRefreshRate() != b.getRefreshRate()) {
                return a.getRefreshRate() > b.getRefreshRate() ? 1 : -1;
            }
            return 0;
        }
    }

    public static interface SelectionListener {
        public void onSelection(int var1);
    }
}

