/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.WeakRefCloneAssetCache;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureProcessor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureKey
extends AssetKey<Texture> {
    private boolean generateMips;
    private boolean flipY;
    private boolean asCube;
    private boolean asTexture3D;
    private int anisotropy;
    private Texture.Type textureTypeHint = Texture.Type.TwoDimensional;

    public TextureKey(String name, boolean flipY) {
        super(name);
        this.flipY = flipY;
    }

    public TextureKey(String name) {
        super(name);
        this.flipY = true;
    }

    public TextureKey() {
    }

    @Override
    public String toString() {
        return this.name + (this.flipY ? " (Flipped)" : "") + (this.asCube ? " (Cube)" : "") + (this.generateMips ? " (Mipmapped)" : "");
    }

    @Override
    public Class<? extends AssetCache> getCacheType() {
        return WeakRefCloneAssetCache.class;
    }

    @Override
    public Class<? extends AssetProcessor> getProcessorType() {
        return TextureProcessor.class;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public int getAnisotropy() {
        return this.anisotropy;
    }

    public void setAnisotropy(int anisotropy) {
        this.anisotropy = anisotropy;
    }

    public boolean isAsCube() {
        return this.asCube;
    }

    public void setAsCube(boolean asCube) {
        this.asCube = asCube;
    }

    public boolean isGenerateMips() {
        return this.generateMips;
    }

    public void setGenerateMips(boolean generateMips) {
        this.generateMips = generateMips;
    }

    public boolean isAsTexture3D() {
        return this.asTexture3D;
    }

    public void setAsTexture3D(boolean asTexture3D) {
        this.asTexture3D = asTexture3D;
    }

    public Texture.Type getTextureTypeHint() {
        return this.textureTypeHint;
    }

    public void setTextureTypeHint(Texture.Type textureTypeHint) {
        this.textureTypeHint = textureTypeHint;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextureKey other = (TextureKey)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.generateMips != other.generateMips) {
            return false;
        }
        if (this.flipY != other.flipY) {
            return false;
        }
        if (this.asCube != other.asCube) {
            return false;
        }
        if (this.asTexture3D != other.asTexture3D) {
            return false;
        }
        if (this.anisotropy != other.anisotropy) {
            return false;
        }
        return this.textureTypeHint == other.textureTypeHint;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + super.hashCode();
        hash = 17 * hash + (this.generateMips ? 1 : 0);
        hash = 17 * hash + (this.flipY ? 1 : 0);
        hash = 17 * hash + (this.asCube ? 1 : 0);
        hash = 17 * hash + (this.asTexture3D ? 1 : 0);
        hash = 17 * hash + this.anisotropy;
        hash = 17 * hash + (this.textureTypeHint != null ? this.textureTypeHint.hashCode() : 0);
        return hash;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.flipY, "flip_y", false);
        oc.write(this.generateMips, "generate_mips", false);
        oc.write(this.asCube, "as_cubemap", false);
        oc.write(this.anisotropy, "anisotropy", 0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.flipY = ic.readBoolean("flip_y", false);
        this.generateMips = ic.readBoolean("generate_mips", false);
        this.asCube = ic.readBoolean("as_cubemap", false);
        this.anisotropy = ic.readInt("anisotropy", 0);
    }
}

