/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.bulletphysics.dynamics.constraintsolver.Point2PointConstraint;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class Point2PointJoint
extends PhysicsJoint {
    public Point2PointJoint() {
    }

    public Point2PointJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.createJoint();
    }

    public void setDamping(float value) {
        ((Point2PointConstraint)this.constraint).setting.damping = value;
    }

    public void setImpulseClamp(float value) {
        ((Point2PointConstraint)this.constraint).setting.impulseClamp = value;
    }

    public void setTau(float value) {
        ((Point2PointConstraint)this.constraint).setting.tau = value;
    }

    public float getDamping() {
        return ((Point2PointConstraint)this.constraint).setting.damping;
    }

    public float getImpulseClamp() {
        return ((Point2PointConstraint)this.constraint).setting.impulseClamp;
    }

    public float getTau() {
        return ((Point2PointConstraint)this.constraint).setting.tau;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule cap = ex.getCapsule(this);
        cap.write(this.getDamping(), "damping", 1.0f);
        cap.write(this.getTau(), "tau", 0.3f);
        cap.write(this.getImpulseClamp(), "impulseClamp", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        this.createJoint();
        InputCapsule cap = im.getCapsule(this);
        this.setDamping(cap.readFloat("damping", 1.0f));
        this.setDamping(cap.readFloat("tau", 0.3f));
        this.setDamping(cap.readFloat("impulseClamp", 0.0f));
    }

    protected void createJoint() {
        this.constraint = new Point2PointConstraint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), Converter.convert(this.pivotA), Converter.convert(this.pivotB));
    }
}

