/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.bulletphysics.dynamics.constraintsolver.Generic6DofConstraint;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.LinkedList;

public class SixDofJoint
extends PhysicsJoint {
    private boolean useLinearReferenceFrameA = true;
    private LinkedList<RotationalLimitMotor> rotationalMotors = new LinkedList();
    private TranslationalLimitMotor translationalMotor;
    private Vector3f angularUpperLimit = new Vector3f(Vector3f.POSITIVE_INFINITY);
    private Vector3f angularLowerLimit = new Vector3f(Vector3f.NEGATIVE_INFINITY);
    private Vector3f linearUpperLimit = new Vector3f(Vector3f.POSITIVE_INFINITY);
    private Vector3f linearLowerLimit = new Vector3f(Vector3f.NEGATIVE_INFINITY);

    public SixDofJoint() {
    }

    public SixDofJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Matrix3f rotA, Matrix3f rotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        Transform transA = new Transform(Converter.convert(rotA));
        Converter.convert(pivotA, transA.origin);
        Converter.convert(rotA, transA.basis);
        Transform transB = new Transform(Converter.convert(rotB));
        Converter.convert(pivotB, transB.origin);
        Converter.convert(rotB, transB.basis);
        this.constraint = new Generic6DofConstraint(nodeA.getObjectId(), nodeB.getObjectId(), transA, transB, useLinearReferenceFrameA);
        this.gatherMotors();
    }

    public SixDofJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        Transform transA = new Transform(Converter.convert(new Matrix3f()));
        Converter.convert(pivotA, transA.origin);
        Transform transB = new Transform(Converter.convert(new Matrix3f()));
        Converter.convert(pivotB, transB.origin);
        this.constraint = new Generic6DofConstraint(nodeA.getObjectId(), nodeB.getObjectId(), transA, transB, useLinearReferenceFrameA);
        this.gatherMotors();
    }

    private void gatherMotors() {
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rmot = new RotationalLimitMotor(((Generic6DofConstraint)this.constraint).getRotationalLimitMotor(i));
            this.rotationalMotors.add(rmot);
        }
        this.translationalMotor = new TranslationalLimitMotor(((Generic6DofConstraint)this.constraint).getTranslationalLimitMotor());
    }

    public TranslationalLimitMotor getTranslationalLimitMotor() {
        return this.translationalMotor;
    }

    public RotationalLimitMotor getRotationalLimitMotor(int index) {
        return this.rotationalMotors.get(index);
    }

    public void setLinearUpperLimit(Vector3f vector) {
        this.linearUpperLimit.set(vector);
        ((Generic6DofConstraint)this.constraint).setLinearUpperLimit(Converter.convert(vector));
    }

    public void setLinearLowerLimit(Vector3f vector) {
        this.linearLowerLimit.set(vector);
        ((Generic6DofConstraint)this.constraint).setLinearLowerLimit(Converter.convert(vector));
    }

    public void setAngularUpperLimit(Vector3f vector) {
        this.angularUpperLimit.set(vector);
        ((Generic6DofConstraint)this.constraint).setAngularUpperLimit(Converter.convert(vector));
    }

    public void setAngularLowerLimit(Vector3f vector) {
        this.angularLowerLimit.set(vector);
        ((Generic6DofConstraint)this.constraint).setAngularLowerLimit(Converter.convert(vector));
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule(this);
        Transform transA = new Transform(Converter.convert(new Matrix3f()));
        Converter.convert(this.pivotA, transA.origin);
        Transform transB = new Transform(Converter.convert(new Matrix3f()));
        Converter.convert(this.pivotB, transB.origin);
        this.constraint = new Generic6DofConstraint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), transA, transB, this.useLinearReferenceFrameA);
        this.gatherMotors();
        this.setAngularUpperLimit((Vector3f)capsule.readSavable("angularUpperLimit", new Vector3f(Vector3f.POSITIVE_INFINITY)));
        this.setAngularLowerLimit((Vector3f)capsule.readSavable("angularLowerLimit", new Vector3f(Vector3f.NEGATIVE_INFINITY)));
        this.setLinearUpperLimit((Vector3f)capsule.readSavable("linearUpperLimit", new Vector3f(Vector3f.POSITIVE_INFINITY)));
        this.setLinearLowerLimit((Vector3f)capsule.readSavable("linearLowerLimit", new Vector3f(Vector3f.NEGATIVE_INFINITY)));
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rotationalLimitMotor = this.getRotationalLimitMotor(i);
            rotationalLimitMotor.setBounce(capsule.readFloat("rotMotor" + i + "_Bounce", 0.0f));
            rotationalLimitMotor.setDamping(capsule.readFloat("rotMotor" + i + "_Damping", 1.0f));
            rotationalLimitMotor.setERP(capsule.readFloat("rotMotor" + i + "_ERP", 0.5f));
            rotationalLimitMotor.setHiLimit(capsule.readFloat("rotMotor" + i + "_HiLimit", Float.POSITIVE_INFINITY));
            rotationalLimitMotor.setLimitSoftness(capsule.readFloat("rotMotor" + i + "_LimitSoftness", 0.5f));
            rotationalLimitMotor.setLoLimit(capsule.readFloat("rotMotor" + i + "_LoLimit", Float.NEGATIVE_INFINITY));
            rotationalLimitMotor.setMaxLimitForce(capsule.readFloat("rotMotor" + i + "_MaxLimitForce", 300.0f));
            rotationalLimitMotor.setMaxMotorForce(capsule.readFloat("rotMotor" + i + "_MaxMotorForce", 0.1f));
            rotationalLimitMotor.setTargetVelocity(capsule.readFloat("rotMotor" + i + "_TargetVelocity", 0.0f));
            rotationalLimitMotor.setEnableMotor(capsule.readBoolean("rotMotor" + i + "_EnableMotor", false));
        }
        this.getTranslationalLimitMotor().setAccumulatedImpulse((Vector3f)capsule.readSavable("transMotor_AccumulatedImpulse", Vector3f.ZERO));
        this.getTranslationalLimitMotor().setDamping(capsule.readFloat("transMotor_Damping", 1.0f));
        this.getTranslationalLimitMotor().setLimitSoftness(capsule.readFloat("transMotor_LimitSoftness", 0.7f));
        this.getTranslationalLimitMotor().setLowerLimit((Vector3f)capsule.readSavable("transMotor_LowerLimit", Vector3f.ZERO));
        this.getTranslationalLimitMotor().setRestitution(capsule.readFloat("transMotor_Restitution", 0.5f));
        this.getTranslationalLimitMotor().setUpperLimit((Vector3f)capsule.readSavable("transMotor_UpperLimit", Vector3f.ZERO));
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.angularUpperLimit, "angularUpperLimit", new Vector3f(Vector3f.POSITIVE_INFINITY));
        capsule.write(this.angularLowerLimit, "angularLowerLimit", new Vector3f(Vector3f.NEGATIVE_INFINITY));
        capsule.write(this.linearUpperLimit, "linearUpperLimit", new Vector3f(Vector3f.POSITIVE_INFINITY));
        capsule.write(this.linearLowerLimit, "linearLowerLimit", new Vector3f(Vector3f.NEGATIVE_INFINITY));
        int i = 0;
        for (RotationalLimitMotor rotationalLimitMotor : this.rotationalMotors) {
            capsule.write(rotationalLimitMotor.getBounce(), "rotMotor" + i + "_Bounce", 0.0f);
            capsule.write(rotationalLimitMotor.getDamping(), "rotMotor" + i + "_Damping", 1.0f);
            capsule.write(rotationalLimitMotor.getERP(), "rotMotor" + i + "_ERP", 0.5f);
            capsule.write(rotationalLimitMotor.getHiLimit(), "rotMotor" + i + "_HiLimit", Float.POSITIVE_INFINITY);
            capsule.write(rotationalLimitMotor.getLimitSoftness(), "rotMotor" + i + "_LimitSoftness", 0.5f);
            capsule.write(rotationalLimitMotor.getLoLimit(), "rotMotor" + i + "_LoLimit", Float.NEGATIVE_INFINITY);
            capsule.write(rotationalLimitMotor.getMaxLimitForce(), "rotMotor" + i + "_MaxLimitForce", 300.0f);
            capsule.write(rotationalLimitMotor.getMaxMotorForce(), "rotMotor" + i + "_MaxMotorForce", 0.1f);
            capsule.write(rotationalLimitMotor.getTargetVelocity(), "rotMotor" + i + "_TargetVelocity", 0.0f);
            capsule.write(rotationalLimitMotor.isEnableMotor(), "rotMotor" + i + "_EnableMotor", false);
            ++i;
        }
        capsule.write(this.getTranslationalLimitMotor().getAccumulatedImpulse(), "transMotor_AccumulatedImpulse", Vector3f.ZERO);
        capsule.write(this.getTranslationalLimitMotor().getDamping(), "transMotor_Damping", 1.0f);
        capsule.write(this.getTranslationalLimitMotor().getLimitSoftness(), "transMotor_LimitSoftness", 0.7f);
        capsule.write(this.getTranslationalLimitMotor().getLowerLimit(), "transMotor_LowerLimit", Vector3f.ZERO);
        capsule.write(this.getTranslationalLimitMotor().getRestitution(), "transMotor_Restitution", 0.5f);
        capsule.write(this.getTranslationalLimitMotor().getUpperLimit(), "transMotor_UpperLimit", Vector3f.ZERO);
    }
}

