/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.PairCachingGhostObject;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Quat4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicsGhostObject
extends PhysicsCollisionObject {
    protected PairCachingGhostObject gObject;
    protected boolean locationDirty = false;
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    protected Transform tempTrans = new Transform(Converter.convert(new Matrix3f()));
    private com.jme3.math.Transform physicsLocation = new com.jme3.math.Transform();
    protected Quat4f tempRot = new Quat4f();
    private List<PhysicsCollisionObject> overlappingObjects = new LinkedList<PhysicsCollisionObject>();

    public PhysicsGhostObject() {
    }

    public PhysicsGhostObject(CollisionShape shape) {
        this.collisionShape = shape;
        this.buildObject();
    }

    public PhysicsGhostObject(Spatial child, CollisionShape shape) {
        this.collisionShape = shape;
        this.buildObject();
    }

    protected void buildObject() {
        if (this.gObject == null) {
            this.gObject = new PairCachingGhostObject();
            this.gObject.setCollisionFlags(this.gObject.getCollisionFlags() | 4);
        }
        this.gObject.setCollisionShape(this.collisionShape.getCShape());
        this.gObject.setUserPointer(this);
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (this.gObject == null) {
            this.buildObject();
        } else {
            this.gObject.setCollisionShape(collisionShape.getCShape());
        }
    }

    public void setPhysicsLocation(Vector3f location) {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(location, this.tempTrans.origin);
        this.gObject.setWorldTransform(this.tempTrans);
    }

    public void setPhysicsRotation(Matrix3f rotation) {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(rotation, this.tempTrans.basis);
        this.gObject.setWorldTransform(this.tempTrans);
    }

    public void setPhysicsRotation(Quaternion rotation) {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(rotation, this.tempTrans.basis);
        this.gObject.setWorldTransform(this.tempTrans);
    }

    public com.jme3.math.Transform getPhysicsTransform() {
        return this.physicsLocation;
    }

    public Vector3f getPhysicsLocation(Vector3f trans) {
        if (trans == null) {
            trans = new Vector3f();
        }
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.origin, this.physicsLocation.getTranslation());
        return trans.set(this.physicsLocation.getTranslation());
    }

    public Quaternion getPhysicsRotation(Quaternion rot) {
        if (rot == null) {
            rot = new Quaternion();
        }
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.getRotation(this.tempRot), this.physicsLocation.getRotation());
        return rot.set(this.physicsLocation.getRotation());
    }

    public Matrix3f getPhysicsRotationMatrix(Matrix3f rot) {
        if (rot == null) {
            rot = new Matrix3f();
        }
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.getRotation(this.tempRot), this.physicsLocation.getRotation());
        return rot.set(this.physicsLocation.getRotation());
    }

    public Vector3f getPhysicsLocation() {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.origin, this.physicsLocation.getTranslation());
        return this.physicsLocation.getTranslation();
    }

    public Quaternion getPhysicsRotation() {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.getRotation(this.tempRot), this.physicsLocation.getRotation());
        return this.physicsLocation.getRotation();
    }

    public Matrix3f getPhysicsRotationMatrix() {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.getRotation(this.tempRot), this.physicsLocation.getRotation());
        return this.physicsLocation.getRotation().toRotationMatrix();
    }

    public PairCachingGhostObject getObjectId() {
        return this.gObject;
    }

    public void destroy() {
    }

    public List<PhysicsCollisionObject> getOverlappingObjects() {
        this.overlappingObjects.clear();
        for (CollisionObject collObj : this.gObject.getOverlappingPairs()) {
            this.overlappingObjects.add((PhysicsCollisionObject)collObj.getUserPointer());
        }
        return this.overlappingObjects;
    }

    public int getOverlappingCount() {
        return this.gObject.getNumOverlappingObjects();
    }

    public PhysicsCollisionObject getOverlapping(int index) {
        return this.overlappingObjects.get(index);
    }

    public void setCcdSweptSphereRadius(float radius) {
        this.gObject.setCcdSweptSphereRadius(radius);
    }

    public void setCcdMotionThreshold(float threshold) {
        this.gObject.setCcdMotionThreshold(threshold);
    }

    public float getCcdSweptSphereRadius() {
        return this.gObject.getCcdSweptSphereRadius();
    }

    public float getCcdMotionThreshold() {
        return this.gObject.getCcdMotionThreshold();
    }

    public float getCcdSquareMotionThreshold() {
        return this.gObject.getCcdSquareMotionThreshold();
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.getPhysicsLocation(new Vector3f()), "physicsLocation", new Vector3f());
        capsule.write(this.getPhysicsRotationMatrix(new Matrix3f()), "physicsRotation", new Matrix3f());
        capsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.buildObject();
        this.setPhysicsLocation((Vector3f)capsule.readSavable("physicsLocation", new Vector3f()));
        this.setPhysicsRotation((Matrix3f)capsule.readSavable("physicsRotation", new Matrix3f()));
        this.setCcdMotionThreshold(capsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat("ccdSweptSphereRadius", 0.0f));
    }
}

