/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.ArrayList;

public class PhysicsVehicle
extends PhysicsRigidBody {
    protected RaycastVehicle vehicle;
    protected VehicleTuning tuning;
    protected VehicleRaycaster rayCaster;
    protected ArrayList<VehicleWheel> wheels = new ArrayList();
    protected PhysicsSpace physicsSpace;

    public PhysicsVehicle() {
    }

    public PhysicsVehicle(CollisionShape shape) {
        super(shape);
    }

    public PhysicsVehicle(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public void updateWheels() {
        if (this.vehicle != null) {
            for (int i = 0; i < this.wheels.size(); ++i) {
                this.vehicle.updateWheelTransform(i, true);
                this.wheels.get(i).updatePhysicsState();
            }
        }
    }

    public void applyWheelTransforms() {
        if (this.wheels != null) {
            for (int i = 0; i < this.wheels.size(); ++i) {
                this.wheels.get(i).applyWheelTransform();
            }
        }
    }

    protected void postRebuild() {
        super.postRebuild();
        if (this.tuning == null) {
            this.tuning = new VehicleTuning();
        }
        this.rBody.setActivationState(4);
        this.motionState.setVehicle(this);
        if (this.physicsSpace != null) {
            this.createVehicle(this.physicsSpace);
        }
    }

    public void createVehicle(PhysicsSpace space) {
        this.physicsSpace = space;
        if (space == null) {
            return;
        }
        this.rayCaster = new DefaultVehicleRaycaster(space.getDynamicsWorld());
        this.vehicle = new RaycastVehicle(this.tuning, this.rBody, this.rayCaster);
        this.vehicle.setCoordinateSystem(0, 1, 2);
        for (VehicleWheel wheel : this.wheels) {
            wheel.setWheelInfo(this.vehicle.addWheel(Converter.convert(wheel.getLocation()), Converter.convert(wheel.getDirection()), Converter.convert(wheel.getAxle()), wheel.getRestLength(), wheel.getRadius(), this.tuning, wheel.isFrontWheel()));
        }
    }

    public VehicleWheel addWheel(Vector3f connectionPoint, Vector3f direction, Vector3f axle, float suspensionRestLength, float wheelRadius, boolean isFrontWheel) {
        return this.addWheel(null, connectionPoint, direction, axle, suspensionRestLength, wheelRadius, isFrontWheel);
    }

    public VehicleWheel addWheel(Spatial spat, Vector3f connectionPoint, Vector3f direction, Vector3f axle, float suspensionRestLength, float wheelRadius, boolean isFrontWheel) {
        VehicleWheel wheel = null;
        wheel = spat == null ? new VehicleWheel(connectionPoint, direction, axle, suspensionRestLength, wheelRadius, isFrontWheel) : new VehicleWheel(spat, connectionPoint, direction, axle, suspensionRestLength, wheelRadius, isFrontWheel);
        if (this.vehicle != null) {
            WheelInfo info = this.vehicle.addWheel(Converter.convert(connectionPoint), Converter.convert(direction), Converter.convert(axle), suspensionRestLength, wheelRadius, this.tuning, isFrontWheel);
            wheel.setWheelInfo(info);
        }
        wheel.setFrictionSlip(this.tuning.frictionSlip);
        wheel.setMaxSuspensionTravelCm(this.tuning.maxSuspensionTravelCm);
        wheel.setSuspensionStiffness(this.tuning.suspensionStiffness);
        wheel.setWheelsDampingCompression(this.tuning.suspensionCompression);
        wheel.setWheelsDampingRelaxation(this.tuning.suspensionDamping);
        wheel.setMaxSuspensionForce(this.tuning.maxSuspensionForce);
        this.wheels.add(wheel);
        return wheel;
    }

    public void removeWheel(int wheel) {
        this.wheels.remove(wheel);
        this.rebuildRigidBody();
    }

    public VehicleWheel getWheel(int wheel) {
        return this.wheels.get(wheel);
    }

    public int getNumWheels() {
        return this.wheels.size();
    }

    public float getFrictionSlip() {
        return this.tuning.frictionSlip;
    }

    public void setFrictionSlip(float frictionSlip) {
        this.tuning.frictionSlip = frictionSlip;
    }

    public void setFrictionSlip(int wheel, float frictionSlip) {
        this.wheels.get(wheel).setFrictionSlip(frictionSlip);
    }

    public void setRollInfluence(int wheel, float rollInfluence) {
        this.wheels.get(wheel).setRollInfluence(rollInfluence);
    }

    public float getMaxSuspensionTravelCm() {
        return this.tuning.maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(float maxSuspensionTravelCm) {
        this.tuning.maxSuspensionTravelCm = maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(int wheel, float maxSuspensionTravelCm) {
        this.wheels.get(wheel).setMaxSuspensionTravelCm(maxSuspensionTravelCm);
    }

    public float getMaxSuspensionForce() {
        return this.tuning.maxSuspensionForce;
    }

    public void setMaxSuspensionForce(float maxSuspensionForce) {
        this.tuning.maxSuspensionForce = maxSuspensionForce;
    }

    public void setMaxSuspensionForce(int wheel, float maxSuspensionForce) {
        this.wheels.get(wheel).setMaxSuspensionForce(maxSuspensionForce);
    }

    public float getSuspensionCompression() {
        return this.tuning.suspensionCompression;
    }

    public void setSuspensionCompression(float suspensionCompression) {
        this.tuning.suspensionCompression = suspensionCompression;
    }

    public void setSuspensionCompression(int wheel, float suspensionCompression) {
        this.wheels.get(wheel).setWheelsDampingCompression(suspensionCompression);
    }

    public float getSuspensionDamping() {
        return this.tuning.suspensionDamping;
    }

    public void setSuspensionDamping(float suspensionDamping) {
        this.tuning.suspensionDamping = suspensionDamping;
    }

    public void setSuspensionDamping(int wheel, float suspensionDamping) {
        this.wheels.get(wheel).setWheelsDampingRelaxation(suspensionDamping);
    }

    public float getSuspensionStiffness() {
        return this.tuning.suspensionStiffness;
    }

    public void setSuspensionStiffness(float suspensionStiffness) {
        this.tuning.suspensionStiffness = suspensionStiffness;
    }

    public void setSuspensionStiffness(int wheel, float suspensionStiffness) {
        this.wheels.get(wheel).setSuspensionStiffness(suspensionStiffness);
    }

    public void resetSuspension() {
        this.vehicle.resetSuspension();
    }

    public void accelerate(float force) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            this.vehicle.applyEngineForce(force, i);
        }
    }

    public void accelerate(int wheel, float force) {
        this.vehicle.applyEngineForce(force, wheel);
    }

    public void steer(float value) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            if (!this.getWheel(i).isFrontWheel()) continue;
            this.vehicle.setSteeringValue(value, i);
        }
    }

    public void steer(int wheel, float value) {
        this.vehicle.setSteeringValue(value, wheel);
    }

    public void brake(float force) {
        for (int i = 0; i < this.wheels.size(); ++i) {
            this.vehicle.setBrake(force, i);
        }
    }

    public void brake(int wheel, float force) {
        this.vehicle.setBrake(force, wheel);
    }

    public float getCurrentVehicleSpeedKmHour() {
        return this.vehicle.getCurrentSpeedKmHour();
    }

    public Vector3f getForwardVector(Vector3f vector) {
        if (vector == null) {
            vector = new Vector3f();
        }
        this.vehicle.getForwardVector(this.tempVec);
        Converter.convert(this.tempVec, vector);
        return vector;
    }

    public RaycastVehicle getVehicleId() {
        return this.vehicle;
    }

    public void destroy() {
        super.destroy();
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule(this);
        this.tuning = new VehicleTuning();
        this.tuning.frictionSlip = capsule.readFloat("frictionSlip", 10.5f);
        this.tuning.maxSuspensionTravelCm = capsule.readFloat("maxSuspensionTravelCm", 500.0f);
        this.tuning.maxSuspensionForce = capsule.readFloat("maxSuspensionForce", 6000.0f);
        this.tuning.suspensionCompression = capsule.readFloat("suspensionCompression", 0.83f);
        this.tuning.suspensionDamping = capsule.readFloat("suspensionDamping", 0.88f);
        this.tuning.suspensionStiffness = capsule.readFloat("suspensionStiffness", 5.88f);
        this.wheels = capsule.readSavableArrayList("wheelsList", new ArrayList());
        this.motionState.setVehicle(this);
        super.read(im);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.tuning.frictionSlip, "frictionSlip", 10.5f);
        capsule.write(this.tuning.maxSuspensionTravelCm, "maxSuspensionTravelCm", 500.0f);
        capsule.write(this.tuning.maxSuspensionForce, "maxSuspensionForce", 6000.0f);
        capsule.write(this.tuning.suspensionCompression, "suspensionCompression", 0.83f);
        capsule.write(this.tuning.suspensionDamping, "suspensionDamping", 0.88f);
        capsule.write(this.tuning.suspensionStiffness, "suspensionStiffness", 5.88f);
        capsule.writeSavableArrayList(this.wheels, "wheelsList", new ArrayList());
        super.write(ex);
    }
}

