/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.CinematicEvent;
import com.jme3.cinematic.events.CinematicEventListener;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCinematicEvent
implements CinematicEvent {
    protected PlayState playState = PlayState.Stopped;
    protected LoopMode loopMode = LoopMode.DontLoop;
    protected float initialDuration = 10.0f;
    protected float speed = 1.0f;
    protected float time = 0.0f;
    protected boolean resuming = false;
    protected List<CinematicEventListener> listeners;

    public AbstractCinematicEvent() {
    }

    public AbstractCinematicEvent(float initialDuration) {
        this.initialDuration = initialDuration;
    }

    public AbstractCinematicEvent(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public AbstractCinematicEvent(float initialDuration, LoopMode loopMode) {
        this.initialDuration = initialDuration;
        this.loopMode = loopMode;
    }

    @Override
    public void forceStop() {
        this.stop();
    }

    @Override
    public void play() {
        this.onPlay();
        this.playState = PlayState.Playing;
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CinematicEventListener cel = this.listeners.get(i);
                cel.onPlay(this);
            }
        }
    }

    protected abstract void onPlay();

    @Override
    public void internalUpdate(float tpf) {
        if (this.playState == PlayState.Playing) {
            this.time += tpf * this.speed;
            this.onUpdate(tpf);
            if (this.time >= this.initialDuration && this.loopMode == LoopMode.DontLoop) {
                this.stop();
            } else if (this.time >= this.initialDuration && this.loopMode == LoopMode.Loop) {
                this.setTime(0.0f);
            }
        }
    }

    protected abstract void onUpdate(float var1);

    @Override
    public void stop() {
        this.onStop();
        this.time = 0.0f;
        this.playState = PlayState.Stopped;
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CinematicEventListener cel = this.listeners.get(i);
                cel.onStop(this);
            }
        }
    }

    protected abstract void onStop();

    @Override
    public void pause() {
        this.onPause();
        this.playState = PlayState.Paused;
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CinematicEventListener cel = this.listeners.get(i);
                cel.onPause(this);
            }
        }
    }

    public abstract void onPause();

    @Override
    public float getDuration() {
        return this.initialDuration / this.speed;
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public PlayState getPlayState() {
        return this.playState;
    }

    @Override
    public float getInitialDuration() {
        return this.initialDuration;
    }

    @Override
    public void setInitialDuration(float initialDuration) {
        this.initialDuration = initialDuration;
    }

    @Override
    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    @Override
    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.playState, "playState", PlayState.Stopped);
        oc.write(this.speed, "speed", 1.0f);
        oc.write(this.initialDuration, "initalDuration", 10.0f);
        oc.write(this.loopMode, "loopMode", LoopMode.DontLoop);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.playState = ic.readEnum("playState", PlayState.class, PlayState.Stopped);
        this.speed = ic.readFloat("speed", 1.0f);
        this.initialDuration = ic.readFloat("initalDuration", 10.0f);
        this.loopMode = ic.readEnum("loopMode", LoopMode.class, LoopMode.DontLoop);
    }

    @Override
    public void initEvent(Application app, Cinematic cinematic) {
    }

    private List<CinematicEventListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CinematicEventListener>();
        }
        return this.listeners;
    }

    public void addListener(CinematicEventListener listener) {
        this.getListeners().add(listener);
    }

    public void removeListener(CinematicEventListener listener) {
        this.getListeners().remove(listener);
    }

    @Override
    public void setTime(float time) {
        this.time = time;
    }

    @Override
    public float getTime() {
        return this.time;
    }

    @Override
    public void dispose() {
    }
}

