/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.binary;

import com.jme3.export.JmeExporter;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.export.binary.BinaryClassField;
import com.jme3.export.binary.BinaryClassObject;
import com.jme3.export.binary.BinaryIdContentPair;
import com.jme3.export.binary.BinaryOutputCapsule;
import com.jme3.export.binary.ByteUtils;
import com.jme3.math.FastMath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryExporter
implements JmeExporter {
    private static final Logger logger = Logger.getLogger(BinaryExporter.class.getName());
    protected int aliasCount = 1;
    protected int idCount = 1;
    protected IdentityHashMap<Savable, BinaryIdContentPair> contentTable = new IdentityHashMap();
    protected HashMap<Integer, Integer> locationTable = new HashMap();
    private HashMap<String, BinaryClassObject> classes = new HashMap();
    private ArrayList<Savable> contentKeys = new ArrayList();
    public static boolean debug = false;
    public static boolean useFastBufs = true;

    public static BinaryExporter getInstance() {
        return new BinaryExporter();
    }

    @Override
    public boolean save(Savable object, OutputStream os) throws IOException {
        this.aliasCount = 1;
        this.idCount = 1;
        this.classes.clear();
        this.contentTable.clear();
        this.locationTable.clear();
        this.contentKeys.clear();
        os.write(ByteUtils.convertToBytes(1246577971));
        os.write(ByteUtils.convertToBytes(2));
        int id = this.processBinarySavable(object);
        int classTableSize = 0;
        int classNum = this.classes.keySet().size();
        int aliasSize = (int)FastMath.log(classNum, 256.0f) + 1;
        os.write(ByteUtils.convertToBytes(classNum));
        for (String key : this.classes.keySet()) {
            BinaryClassObject bco = this.classes.get(key);
            byte[] aliasBytes = this.fixClassAlias(bco.alias, aliasSize);
            os.write(aliasBytes);
            classTableSize += aliasSize;
            os.write(bco.classHierarchyVersions.length);
            for (int version : bco.classHierarchyVersions) {
                os.write(ByteUtils.convertToBytes(version));
            }
            classTableSize += 1 + bco.classHierarchyVersions.length * 4;
            byte[] classBytes = key.getBytes();
            os.write(ByteUtils.convertToBytes(classBytes.length));
            os.write(classBytes);
            classTableSize += 4 + classBytes.length;
            os.write(ByteUtils.convertToBytes(bco.nameFields.size()));
            for (String fieldName : bco.nameFields.keySet()) {
                BinaryClassField bcf = bco.nameFields.get(fieldName);
                os.write(bcf.alias);
                os.write(bcf.type);
                byte[] fNameBytes = fieldName.getBytes();
                os.write(ByteUtils.convertToBytes(fNameBytes.length));
                os.write(fNameBytes);
                classTableSize += 6 + fNameBytes.length;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int location = 0;
        HashMap<String, ArrayList<BinaryIdContentPair>> alreadySaved = new HashMap<String, ArrayList<BinaryIdContentPair>>(this.contentTable.size());
        for (Savable savable : this.contentKeys) {
            ArrayList<BinaryIdContentPair> bucket;
            String savableName = savable.getClass().getName();
            BinaryIdContentPair pair = this.contentTable.get(savable);
            int prevLoc = this.findPrevMatch(pair, bucket = (ArrayList<BinaryIdContentPair>)alreadySaved.get(savableName + this.getChunk(pair)));
            if (prevLoc != -1) {
                this.locationTable.put(pair.getId(), prevLoc);
                continue;
            }
            this.locationTable.put(pair.getId(), location);
            if (bucket == null) {
                bucket = new ArrayList<BinaryIdContentPair>();
                alreadySaved.put(savableName + this.getChunk(pair), bucket);
            }
            bucket.add(pair);
            byte[] aliasBytes = this.fixClassAlias(this.classes.get((Object)savableName).alias, aliasSize);
            out.write(aliasBytes);
            location += aliasSize;
            BinaryOutputCapsule cap = this.contentTable.get(savable).getContent();
            out.write(ByteUtils.convertToBytes(cap.bytes.length));
            location += 4;
            out.write(cap.bytes);
            location += cap.bytes.length;
        }
        int numLocations = this.locationTable.keySet().size();
        os.write(ByteUtils.convertToBytes(numLocations));
        int locationTableSize = 0;
        for (Integer key : this.locationTable.keySet()) {
            os.write(ByteUtils.convertToBytes(key));
            os.write(ByteUtils.convertToBytes(this.locationTable.get(key)));
            locationTableSize += 8;
        }
        os.write(ByteUtils.convertToBytes(1));
        os.write(ByteUtils.convertToBytes(id));
        out.writeTo(os);
        out = null;
        os = null;
        if (debug) {
            logger.fine("Stats:");
            logger.log(Level.FINE, "classes: {0}", classNum);
            logger.log(Level.FINE, "class table: {0} bytes", classTableSize);
            logger.log(Level.FINE, "objects: {0}", numLocations);
            logger.log(Level.FINE, "location table: {0} bytes", locationTableSize);
            logger.log(Level.FINE, "data: {0} bytes", location);
        }
        return true;
    }

    protected String getChunk(BinaryIdContentPair pair) {
        return new String(pair.getContent().bytes, 0, Math.min(64, pair.getContent().bytes.length));
    }

    protected int findPrevMatch(BinaryIdContentPair oldPair, ArrayList<BinaryIdContentPair> bucket) {
        if (bucket == null) {
            return -1;
        }
        int x = bucket.size();
        while (--x >= 0) {
            BinaryIdContentPair pair = bucket.get(x);
            if (!pair.getContent().equals(oldPair.getContent())) continue;
            return this.locationTable.get(pair.getId());
        }
        return -1;
    }

    protected byte[] fixClassAlias(byte[] bytes, int width) {
        if (bytes.length != width) {
            byte[] newAlias = new byte[width];
            for (int x = width - bytes.length; x < width; ++x) {
                newAlias[x] = bytes[x - bytes.length];
            }
            return newAlias;
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(Savable object, File f) throws IOException {
        File parentDirectory = f.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(f);
        try {
            boolean bl = this.save(object, fos);
            return bl;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public BinaryOutputCapsule getCapsule(Savable object) {
        return this.contentTable.get(object).getContent();
    }

    private BinaryClassObject createClassObject(Class clazz) throws IOException {
        BinaryClassObject bco = new BinaryClassObject();
        bco.alias = this.generateTag();
        bco.nameFields = new HashMap();
        bco.classHierarchyVersions = SavableClassUtil.getSavableVersions(clazz);
        this.classes.put(clazz.getName(), bco);
        return bco;
    }

    public int processBinarySavable(Savable object) throws IOException {
        if (object == null) {
            return -1;
        }
        Class<?> clazz = object.getClass();
        BinaryClassObject bco = this.classes.get(object.getClass().getName());
        if (bco == null) {
            bco = this.createClassObject(object.getClass());
        }
        if (this.contentTable.get(object) != null) {
            return this.contentTable.get(object).getId();
        }
        BinaryIdContentPair newPair = this.generateIdContentPair(bco);
        BinaryIdContentPair old = this.contentTable.put(object, newPair);
        if (old == null) {
            this.contentKeys.add(object);
        }
        object.write(this);
        newPair.getContent().finish();
        return newPair.getId();
    }

    protected byte[] generateTag() {
        int width = (int)FastMath.log(this.aliasCount, 256.0f) + 1;
        int count = this.aliasCount++;
        byte[] bytes = new byte[width];
        for (int x = width - 1; x >= 0; --x) {
            int pow = (int)FastMath.pow(256.0f, x);
            int factor = count / pow;
            bytes[width - x - 1] = (byte)factor;
            count %= pow;
        }
        return bytes;
    }

    protected BinaryIdContentPair generateIdContentPair(BinaryClassObject bco) {
        BinaryIdContentPair pair = new BinaryIdContentPair(this.idCount++, new BinaryOutputCapsule(this, bco));
        return pair;
    }
}

