/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.InputManager;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.controls.JoyAxisTrigger;

public class DefaultJoystickAxis
implements JoystickAxis {
    private InputManager inputManager;
    private Joystick parent;
    private int axisIndex;
    private String name;
    private String logicalId;
    private boolean isAnalog;
    private boolean isRelative;
    private float deadZone;

    public DefaultJoystickAxis(InputManager inputManager, Joystick parent, int axisIndex, String name, String logicalId, boolean isAnalog, boolean isRelative, float deadZone) {
        this.inputManager = inputManager;
        this.parent = parent;
        this.axisIndex = axisIndex;
        this.name = name;
        this.logicalId = logicalId;
        this.isAnalog = isAnalog;
        this.isRelative = isRelative;
        this.deadZone = deadZone;
    }

    public void assignAxis(String positiveMapping, String negativeMapping) {
        this.inputManager.addMapping(positiveMapping, new JoyAxisTrigger(this.parent.getJoyId(), this.axisIndex, false));
        this.inputManager.addMapping(negativeMapping, new JoyAxisTrigger(this.parent.getJoyId(), this.axisIndex, true));
    }

    public Joystick getJoystick() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getLogicalId() {
        return this.logicalId;
    }

    public int getAxisId() {
        return this.axisIndex;
    }

    public boolean isAnalog() {
        return this.isAnalog;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public float getDeadZone() {
        return this.deadZone;
    }

    public String toString() {
        return "JoystickAxis[name=" + this.name + ", parent=" + this.parent.getName() + ", id=" + this.axisIndex + ", logicalId=" + this.logicalId + ", isAnalog=" + this.isAnalog + ", isRelative=" + this.isRelative + ", deadZone=" + this.deadZone + "]";
    }
}

