/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.input.AbstractJoystick;
import com.jme3.input.DefaultJoystickAxis;
import com.jme3.input.DefaultJoystickButton;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.JoystickButton;
import com.jme3.input.JoystickCompatibilityMappings;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public class JInputJoyInput
implements JoyInput {
    private static final Logger logger = Logger.getLogger(InputManager.class.getName());
    private boolean inited = false;
    private JInputJoystick[] joysticks;
    private RawInputListener listener;
    private Map<Controller, JInputJoystick> joystickIndex = new HashMap<Controller, JInputJoystick>();

    public void setJoyRumble(int joyId, float amount) {
        if (joyId >= this.joysticks.length) {
            throw new IllegalArgumentException();
        }
        Controller c = this.joysticks[joyId].controller;
        for (Rumbler r : c.getRumblers()) {
            r.rumble(amount);
        }
    }

    public Joystick[] loadJoysticks(InputManager inputManager) {
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        Controller[] cs = ce.getControllers();
        ArrayList<JInputJoystick> list = new ArrayList<JInputJoystick>();
        for (Controller c : ce.getControllers()) {
            if (c.getType() == Controller.Type.KEYBOARD || c.getType() == Controller.Type.MOUSE) continue;
            logger.log(Level.FINE, "Attempting to create joystick for: \"{0}\"", c);
            JInputJoystick stick = new JInputJoystick(inputManager, this, c, list.size(), c.getName());
            for (Component comp : c.getComponents()) {
                stick.addComponent(comp);
            }
            if (stick.getAxisCount() == 0) {
                logger.log(Level.FINE, "Not a joystick: {0}", c);
                continue;
            }
            this.joystickIndex.put(c, stick);
            list.add(stick);
        }
        this.joysticks = list.toArray(new JInputJoystick[list.size()]);
        return this.joysticks;
    }

    public void initialize() {
        this.inited = true;
    }

    public void update() {
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        Controller[] cs = ce.getControllers();
        Event e = new Event();
        for (int i = 0; i < cs.length; ++i) {
            Controller c = cs[i];
            JInputJoystick stick = this.joystickIndex.get(c);
            if (stick == null || !c.poll()) continue;
            int joyId = stick.getJoyId();
            EventQueue q = c.getEventQueue();
            while (q.getNextEvent(e)) {
                Component.Identifier id = e.getComponent().getIdentifier();
                if (id == Component.Identifier.Axis.POV) {
                    float x = 0.0f;
                    float y = 0.0f;
                    float v = e.getValue();
                    if (v == 0.0f) {
                        x = 0.0f;
                        y = 0.0f;
                    } else if (v == 0.75f) {
                        x = 0.0f;
                        y = -1.0f;
                    } else if (v == 0.875f) {
                        x = -1.0f;
                        y = -1.0f;
                    } else if (v == 0.625f) {
                        x = 1.0f;
                        y = -1.0f;
                    } else if (v == 1.0f) {
                        x = -1.0f;
                        y = 0.0f;
                    } else if (v == 0.5f) {
                        x = 1.0f;
                        y = 0.0f;
                    } else if (v == 0.25f) {
                        x = 0.0f;
                        y = 1.0f;
                    } else if (v == 0.125f) {
                        x = -1.0f;
                        y = 1.0f;
                    } else if (v == 0.375f) {
                        x = 1.0f;
                        y = 1.0f;
                    }
                    JoyAxisEvent evt1 = new JoyAxisEvent(stick.povX, x);
                    JoyAxisEvent evt2 = new JoyAxisEvent(stick.povY, y);
                    this.listener.onJoyAxisEvent(evt1);
                    this.listener.onJoyAxisEvent(evt2);
                    continue;
                }
                if (id instanceof Component.Identifier.Axis) {
                    float value = e.getValue();
                    JoystickAxis axis = (JoystickAxis)stick.axisIndex.get(e.getComponent());
                    JoyAxisEvent evt = new JoyAxisEvent(axis, value);
                    this.listener.onJoyAxisEvent(evt);
                    continue;
                }
                if (!(id instanceof Component.Identifier.Button)) continue;
                JoystickButton button = (JoystickButton)stick.buttonIndex.get(e.getComponent());
                JoyButtonEvent evt = new JoyButtonEvent(button, e.getValue() == 1.0f);
                this.listener.onJoyButtonEvent(evt);
            }
        }
    }

    public void destroy() {
        this.inited = false;
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return 0L;
    }

    protected class JInputJoystick
    extends AbstractJoystick {
        private JoystickAxis nullAxis;
        private Controller controller;
        private JoystickAxis xAxis;
        private JoystickAxis yAxis;
        private JoystickAxis povX;
        private JoystickAxis povY;
        private Map<Component, JoystickAxis> axisIndex;
        private Map<Component, JoystickButton> buttonIndex;

        public JInputJoystick(InputManager inputManager, JoyInput joyInput, Controller controller, int joyId, String name) {
            super(inputManager, joyInput, joyId, name);
            this.axisIndex = new HashMap<Component, JoystickAxis>();
            this.buttonIndex = new HashMap<Component, JoystickButton>();
            this.controller = controller;
            this.xAxis = this.nullAxis = new DefaultJoystickAxis(this.getInputManager(), this, -1, "Null", "null", false, false, 0.0f);
            this.yAxis = this.nullAxis;
            this.povX = this.nullAxis;
            this.povY = this.nullAxis;
        }

        protected void addComponent(Component comp) {
            Component.Identifier id = comp.getIdentifier();
            if (id instanceof Component.Identifier.Button) {
                this.addButton(comp);
            } else if (id instanceof Component.Identifier.Axis) {
                this.addAxis(comp);
            } else {
                logger.log(Level.FINE, "Ignoring: \"{0}\"", comp);
            }
        }

        protected void addButton(Component comp) {
            logger.log(Level.FINE, "Adding button: \"{0}\" id:" + comp.getIdentifier(), comp);
            Component.Identifier id = comp.getIdentifier();
            if (!(id instanceof Component.Identifier.Button)) {
                throw new IllegalArgumentException("Component is not an axis:" + comp);
            }
            String name = comp.getName();
            String original = id.getName();
            String logicalId = JoystickCompatibilityMappings.remapComponent(this.controller.getName(), original);
            if (name != original) {
                logger.log(Level.FINE, "Remapped:" + original + " to:" + logicalId);
            }
            DefaultJoystickButton button = new DefaultJoystickButton(this.getInputManager(), this, this.getButtonCount(), name, logicalId);
            this.addButton(button);
            this.buttonIndex.put(comp, button);
        }

        protected void addAxis(Component comp) {
            logger.log(Level.FINE, "Adding axis: \"{0}\" id:" + comp.getIdentifier(), comp);
            Component.Identifier id = comp.getIdentifier();
            if (!(id instanceof Component.Identifier.Axis)) {
                throw new IllegalArgumentException("Component is not an axis:" + comp);
            }
            String name = comp.getName();
            String original = id.getName();
            String logicalId = JoystickCompatibilityMappings.remapComponent(this.controller.getName(), original);
            if (name != original) {
                logger.log(Level.FINE, "Remapped:" + original + " to:" + logicalId);
            }
            DefaultJoystickAxis axis = new DefaultJoystickAxis(this.getInputManager(), this, this.getAxisCount(), name, logicalId, comp.isAnalog(), comp.isRelative(), comp.getDeadZone());
            this.addAxis(axis);
            this.axisIndex.put(comp, axis);
            if (id == Component.Identifier.Axis.X) {
                this.xAxis = axis;
            } else if (id == Component.Identifier.Axis.Y) {
                this.yAxis = axis;
            } else if (id == Component.Identifier.Axis.POV) {
                this.povX = new DefaultJoystickAxis(this.getInputManager(), this, this.getAxisCount(), "pov_x", id.getName() + "_x", comp.isAnalog(), comp.isRelative(), comp.getDeadZone());
                logger.log(Level.FINE, "Adding axis: \"{0}\" id:" + id.getName() + "_x", this.povX.getName());
                this.addAxis(this.povX);
                this.povY = new DefaultJoystickAxis(this.getInputManager(), this, this.getAxisCount(), "pov_y", id.getName() + "_y", comp.isAnalog(), comp.isRelative(), comp.getDeadZone());
                logger.log(Level.FINE, "Adding axis: \"{0}\" id:" + id.getName() + "_y", this.povY.getName());
                this.addAxis(this.povY);
            }
        }

        public JoystickAxis getXAxis() {
            return this.xAxis;
        }

        public JoystickAxis getYAxis() {
            return this.yAxis;
        }

        public JoystickAxis getPovXAxis() {
            return this.povX;
        }

        public JoystickAxis getPovYAxis() {
            return this.povY;
        }

        public int getXAxisIndex() {
            return this.xAxis.getAxisId();
        }

        public int getYAxisIndex() {
            return this.yAxis.getAxisId();
        }
    }
}

