/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerRegistry<S>
implements MessageListener<S> {
    static Logger log = Logger.getLogger(MessageListenerRegistry.class.getName());
    private List<MessageListener<? super S>> listeners = new CopyOnWriteArrayList<MessageListener<? super S>>();
    private Map<Class, List<MessageListener<? super S>>> typeListeners = new ConcurrentHashMap<Class, List<MessageListener<? super S>>>();

    @Override
    public void messageReceived(S source, Message m) {
        boolean delivered = false;
        for (MessageListener<S> messageListener : this.listeners) {
            messageListener.messageReceived(source, m);
            delivered = true;
        }
        for (MessageListener<Object> messageListener : this.getListeners(m.getClass(), false)) {
            messageListener.messageReceived(source, m);
            delivered = true;
        }
        if (!delivered) {
            log.log(Level.FINE, "Received message had no registered listeners: {0}", m);
        }
    }

    protected List<MessageListener<? super S>> getListeners(Class c, boolean create) {
        List<MessageListener<Object>> result = this.typeListeners.get(c);
        if (result == null && create) {
            result = new CopyOnWriteArrayList<MessageListener<? super S>>();
            this.typeListeners.put(c, result);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public void addMessageListener(MessageListener<? super S> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null.");
        }
        this.listeners.add(listener);
    }

    public void removeMessageListener(MessageListener<? super S> listener) {
        this.listeners.remove(listener);
    }

    public void addMessageListener(MessageListener<? super S> listener, Class ... classes) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null.");
        }
        for (Class c : classes) {
            this.getListeners(c, true).add(listener);
        }
    }

    public void removeMessageListener(MessageListener<? super S> listener, Class ... classes) {
        for (Class c : classes) {
            this.getListeners(c, false).remove(listener);
        }
    }
}

