/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel.tcp;

import com.jme3.network.Filter;
import com.jme3.network.kernel.AbstractKernel;
import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.EndpointEvent;
import com.jme3.network.kernel.Envelope;
import com.jme3.network.kernel.KernelException;
import com.jme3.network.kernel.tcp.NioEndpoint;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorKernel
extends AbstractKernel {
    static Logger log = Logger.getLogger(SelectorKernel.class.getName());
    private InetSocketAddress address;
    private SelectorThread thread;
    private Map<Long, NioEndpoint> endpoints = new ConcurrentHashMap<Long, NioEndpoint>();

    public SelectorKernel(InetAddress host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public SelectorKernel(int port) throws IOException {
        this(new InetSocketAddress(port));
    }

    public SelectorKernel(InetSocketAddress address) {
        this.address = address;
    }

    protected SelectorThread createSelectorThread() {
        return new SelectorThread();
    }

    @Override
    public void initialize() {
        if (this.thread != null) {
            throw new IllegalStateException("Kernel already initialized.");
        }
        this.thread = this.createSelectorThread();
        try {
            this.thread.connect();
            this.thread.start();
        }
        catch (IOException e) {
            throw new KernelException("Error hosting:" + this.address, e);
        }
    }

    @Override
    public void terminate() throws InterruptedException {
        if (this.thread == null) {
            throw new IllegalStateException("Kernel not initialized.");
        }
        try {
            this.thread.close();
            this.thread = null;
        }
        catch (IOException e) {
            throw new KernelException("Error closing host connection:" + this.address, e);
        }
    }

    @Override
    public void broadcast(Filter<? super Endpoint> filter, ByteBuffer data, boolean reliable, boolean copy) {
        if (!reliable) {
            throw new UnsupportedOperationException("Unreliable send not supported by this kernel.");
        }
        if (copy) {
            byte[] temp = new byte[data.remaining()];
            System.arraycopy(data.array(), data.position(), temp, 0, data.remaining());
            data = ByteBuffer.wrap(temp);
        }
        for (NioEndpoint p : this.endpoints.values()) {
            if (filter != null && !filter.apply(p)) continue;
            p.send(data.duplicate(), false, false);
        }
        this.wakeupSelector();
    }

    protected NioEndpoint addEndpoint(SocketChannel c) {
        NioEndpoint p = new NioEndpoint(this, this.nextEndpointId(), c);
        this.endpoints.put(p.getId(), p);
        this.addEvent(EndpointEvent.createAdd(this, p));
        return p;
    }

    protected void removeEndpoint(NioEndpoint p, SocketChannel c) {
        this.endpoints.remove(p.getId());
        log.log(Level.FINE, "Endpoints size:{0}", this.endpoints.size());
        this.addEvent(EndpointEvent.createRemove(this, p));
        if (!this.hasEnvelopes()) {
            this.addEnvelope(EVENTS_PENDING);
        }
    }

    protected void closeEndpoint(NioEndpoint p) throws IOException {
        this.thread.cancel(p);
    }

    protected void wakeupSelector() {
        this.thread.wakeupSelector();
    }

    protected void newData(NioEndpoint p, SocketChannel c, ByteBuffer shared, int size) {
        byte[] dataCopy = new byte[size];
        System.arraycopy(shared.array(), 0, dataCopy, 0, size);
        Envelope env = new Envelope(p, dataCopy, true);
        this.addEnvelope(env);
    }

    protected class SelectorThread
    extends Thread {
        private ServerSocketChannel serverChannel;
        private Selector selector;
        private AtomicBoolean go = new AtomicBoolean(true);
        private ByteBuffer working = ByteBuffer.allocate(8192);
        private Map<NioEndpoint, SelectionKey> endpointKeys = new ConcurrentHashMap<NioEndpoint, SelectionKey>();

        public SelectorThread() {
            this.setName("Selector@" + SelectorKernel.this.address);
            this.setDaemon(true);
        }

        public void connect() throws IOException {
            this.selector = SelectorProvider.provider().openSelector();
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(false);
            this.serverChannel.socket().bind(SelectorKernel.this.address);
            this.serverChannel.register(this.selector, 16);
            log.log(Level.FINE, "Hosting TCP connection:{0}.", SelectorKernel.this.address);
        }

        public void close() throws IOException, InterruptedException {
            this.go.set(false);
            this.serverChannel.close();
            this.wakeupSelector();
            this.join();
        }

        protected void wakeupSelector() {
            this.selector.wakeup();
        }

        protected void setupSelectorOptions() {
            for (Map.Entry<NioEndpoint, SelectionKey> e : this.endpointKeys.entrySet()) {
                if (!e.getKey().hasPending()) continue;
                e.getValue().interestOps(4);
            }
        }

        protected void accept(SelectionKey key) throws IOException {
            ServerSocketChannel serverChan = (ServerSocketChannel)key.channel();
            SocketChannel remoteChan = serverChan.accept();
            remoteChan.configureBlocking(false);
            Socket sock = remoteChan.socket();
            sock.setTcpNoDelay(true);
            SelectionKey endKey = remoteChan.register(this.selector, 1);
            NioEndpoint p = SelectorKernel.this.addEndpoint(remoteChan);
            endKey.attach(p);
            this.endpointKeys.put(p, endKey);
        }

        protected void cancel(NioEndpoint p) throws IOException {
            SelectionKey key = this.endpointKeys.remove(p);
            if (key == null) {
                return;
            }
            log.log(Level.FINE, "Endpoint keys size:{0}", this.endpointKeys.size());
            log.log(Level.FINE, "Closing endpoint:{0}.", p);
            SocketChannel c = (SocketChannel)key.channel();
            key.cancel();
            c.close();
            SelectorKernel.this.removeEndpoint(p, c);
        }

        protected void cancel(SelectionKey key, SocketChannel c) throws IOException {
            NioEndpoint p = (NioEndpoint)key.attachment();
            log.log(Level.FINE, "Closing channel endpoint:{0}.", p);
            SelectionKey o = this.endpointKeys.remove(p);
            log.log(Level.FINE, "Endpoint keys size:{0}", this.endpointKeys.size());
            key.cancel();
            c.close();
            SelectorKernel.this.removeEndpoint(p, c);
        }

        protected void read(SelectionKey key) throws IOException {
            int size;
            NioEndpoint p = (NioEndpoint)key.attachment();
            SocketChannel c = (SocketChannel)key.channel();
            this.working.clear();
            try {
                size = c.read(this.working);
            }
            catch (IOException e) {
                this.cancel(key, c);
                return;
            }
            if (size == -1) {
                this.cancel(key, c);
                return;
            }
            SelectorKernel.this.newData(p, c, this.working, size);
        }

        protected void write(SelectionKey key) throws IOException {
            NioEndpoint p = (NioEndpoint)key.attachment();
            SocketChannel c = (SocketChannel)key.channel();
            ByteBuffer current = p.peekPending();
            if (current == NioEndpoint.CLOSE_MARKER) {
                SelectorKernel.this.closeEndpoint(p);
                return;
            }
            c.write(current);
            if (current.remaining() == 0) {
                p.removePending();
            }
            if (!p.hasPending()) {
                key.interestOps(1);
            }
        }

        protected void select() throws IOException {
            this.selector.select();
            Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                i.remove();
                if (!key.isValid()) {
                    log.log(Level.FINE, "Key is not valid:{0}.", key);
                    continue;
                }
                try {
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isWritable()) {
                        this.write(key);
                        continue;
                    }
                    if (!key.isReadable()) continue;
                    this.read(key);
                }
                catch (IOException e) {
                    if (!this.go.get()) {
                        return;
                    }
                    SelectorKernel.this.reportError(e);
                    this.cancel(key, (SocketChannel)key.channel());
                }
            }
        }

        public void run() {
            log.log(Level.FINE, "Kernel started for connection:{0}.", SelectorKernel.this.address);
            while (this.go.get()) {
                this.setupSelectorOptions();
                try {
                    this.select();
                }
                catch (ClosedSelectorException e) {
                    if (!this.go.get()) {
                        return;
                    }
                    throw new KernelException("Premature selector closing", e);
                }
                catch (IOException e) {
                    if (!this.go.get()) {
                        return;
                    }
                    SelectorKernel.this.reportError(e);
                }
            }
        }
    }
}

