/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.queue;

import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.scene.Geometry;

public class OpaqueComparator
implements GeometryComparator {
    private Camera cam;
    private final Vector3f tempVec = new Vector3f();
    private final Vector3f tempVec2 = new Vector3f();

    public void setCamera(Camera cam) {
        this.cam = cam;
    }

    public float distanceToCam(Geometry spat) {
        if (spat == null) {
            return Float.NEGATIVE_INFINITY;
        }
        if (spat.queueDistance != Float.NEGATIVE_INFINITY) {
            return spat.queueDistance;
        }
        Vector3f camPosition = this.cam.getLocation();
        Vector3f viewVector = this.cam.getDirection(this.tempVec2);
        Vector3f spatPosition = null;
        spatPosition = spat.getWorldBound() != null ? spat.getWorldBound().getCenter() : spat.getWorldTranslation();
        spatPosition.subtract(camPosition, this.tempVec);
        spat.queueDistance = this.tempVec.dot(viewVector);
        return spat.queueDistance;
    }

    public int compare(Geometry o1, Geometry o2) {
        Material m1 = o1.getMaterial();
        Material m2 = o2.getMaterial();
        int compareResult = m2.getSortId() - m1.getSortId();
        if (compareResult == 0) {
            float d2;
            float d1 = this.distanceToCam(o1);
            if (d1 == (d2 = this.distanceToCam(o2))) {
                return 0;
            }
            if (d1 < d2) {
                return -1;
            }
            return 1;
        }
        return compareResult;
    }
}

