/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.light.Light;
import com.jme3.scene.Node;
import com.jme3.scene.control.LightControl;
import java.io.IOException;

public class LightNode
extends Node {
    private LightControl lightControl;

    public LightNode() {
    }

    public LightNode(String name, Light light) {
        this(name, new LightControl(light));
    }

    public LightNode(String name, LightControl control) {
        super(name);
        this.addControl(control);
        this.lightControl = control;
    }

    public void setEnabled(boolean enabled) {
        this.lightControl.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.lightControl.isEnabled();
    }

    public void setControlDir(LightControl.ControlDirection controlDir) {
        this.lightControl.setControlDir(controlDir);
    }

    public void setLight(Light light) {
        this.lightControl.setLight(light);
    }

    public LightControl.ControlDirection getControlDir() {
        return this.lightControl.getControlDir();
    }

    public Light getLight() {
        return this.lightControl.getLight();
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        this.lightControl = (LightControl)im.getCapsule(this).readSavable("lightControl", null);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        ex.getCapsule(this).write(this.lightControl, "lightControl", null);
    }
}

