/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.asset.AssetKey;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.material.Material;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.UserData;
import com.jme3.scene.control.Control;
import com.jme3.util.SafeArrayList;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Spatial
implements Savable,
Cloneable,
Collidable,
CloneableSmartAsset {
    private static final Logger logger = Logger.getLogger(Spatial.class.getName());
    protected static final int RF_TRANSFORM = 1;
    protected static final int RF_BOUND = 2;
    protected static final int RF_LIGHTLIST = 4;
    protected CullHint cullHint = CullHint.Inherit;
    protected BatchHint batchHint = BatchHint.Inherit;
    protected BoundingVolume worldBound;
    protected LightList localLights;
    protected transient LightList worldLights;
    protected String name;
    protected transient Camera.FrustumIntersect frustrumIntersects = Camera.FrustumIntersect.Intersects;
    protected RenderQueue.Bucket queueBucket = RenderQueue.Bucket.Inherit;
    protected RenderQueue.ShadowMode shadowMode = RenderQueue.ShadowMode.Inherit;
    public transient float queueDistance = Float.NEGATIVE_INFINITY;
    protected Transform localTransform;
    protected Transform worldTransform;
    protected SafeArrayList<Control> controls = new SafeArrayList<Control>(Control.class);
    protected HashMap<String, Savable> userData = null;
    protected AssetKey key;
    protected transient Node parent;
    protected transient int refreshFlags = 0;

    public Spatial() {
        this.localTransform = new Transform();
        this.worldTransform = new Transform();
        this.localLights = new LightList(this);
        this.worldLights = new LightList(this);
        this.refreshFlags |= 2;
    }

    public Spatial(String name) {
        this();
        this.name = name;
    }

    @Override
    public void setKey(AssetKey key) {
        this.key = key;
    }

    @Override
    public AssetKey getKey() {
        return this.key;
    }

    protected void setTransformRefresh() {
        this.refreshFlags |= 1;
        this.setBoundRefresh();
    }

    protected void setLightListRefresh() {
        this.refreshFlags |= 4;
    }

    protected void setBoundRefresh() {
        this.refreshFlags |= 2;
        Node p = this.parent;
        while (p != null) {
            if ((p.refreshFlags & 2) != 0) {
                return;
            }
            p.refreshFlags |= 2;
            p = p.parent;
        }
    }

    public void forceRefresh(boolean transforms, boolean bounds, boolean lights) {
        if (transforms) {
            this.setTransformRefresh();
        }
        if (bounds) {
            this.setBoundRefresh();
        }
        if (lights) {
            this.setLightListRefresh();
        }
    }

    public boolean checkCulling(Camera cam) {
        if (this.refreshFlags != 0) {
            throw new IllegalStateException("Scene graph is not properly updated for rendering.\nState was changed after rootNode.updateGeometricState() call. \nMake sure you do not modify the scene from another thread!\nProblem spatial name: " + this.getName());
        }
        CullHint cm = this.getCullHint();
        assert (cm != CullHint.Inherit);
        if (cm == CullHint.Always) {
            this.setLastFrustumIntersection(Camera.FrustumIntersect.Outside);
            return false;
        }
        if (cm == CullHint.Never) {
            this.setLastFrustumIntersection(Camera.FrustumIntersect.Intersects);
            return true;
        }
        Camera.FrustumIntersect frustumIntersect = this.frustrumIntersects = this.parent != null ? this.parent.frustrumIntersects : Camera.FrustumIntersect.Intersects;
        if (this.frustrumIntersects == Camera.FrustumIntersect.Intersects) {
            if (this.getQueueBucket() == RenderQueue.Bucket.Gui) {
                return cam.containsGui(this.getWorldBound());
            }
            this.frustrumIntersects = cam.contains(this.getWorldBound());
        }
        return this.frustrumIntersects != Camera.FrustumIntersect.Outside;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LightList getLocalLightList() {
        return this.localLights;
    }

    public LightList getWorldLightList() {
        return this.worldLights;
    }

    public Quaternion getWorldRotation() {
        this.checkDoTransformUpdate();
        return this.worldTransform.getRotation();
    }

    public Vector3f getWorldTranslation() {
        this.checkDoTransformUpdate();
        return this.worldTransform.getTranslation();
    }

    public Vector3f getWorldScale() {
        this.checkDoTransformUpdate();
        return this.worldTransform.getScale();
    }

    public Transform getWorldTransform() {
        this.checkDoTransformUpdate();
        return this.worldTransform;
    }

    public void rotateUpTo(Vector3f newUp) {
        TempVars vars = TempVars.get();
        Vector3f compVecA = vars.vect1;
        Quaternion q = vars.quat1;
        Vector3f upY = compVecA.set(Vector3f.UNIT_Y);
        Quaternion rot = this.localTransform.getRotation();
        rot.multLocal(upY);
        float angle = upY.angleBetween(newUp);
        Vector3f rotAxis = upY.crossLocal(newUp).normalizeLocal();
        q.fromAngleNormalAxis(angle, rotAxis);
        q.mult(rot, rot);
        vars.release();
        this.setTransformRefresh();
    }

    public void lookAt(Vector3f position, Vector3f upVector) {
        Vector3f worldTranslation = this.getWorldTranslation();
        TempVars vars = TempVars.get();
        Vector3f compVecA = vars.vect4;
        compVecA.set(position).subtractLocal(worldTranslation);
        this.getLocalRotation().lookAt(compVecA, upVector);
        if (this.getParent() != null) {
            Quaternion rot = vars.quat1;
            rot = rot.set(this.parent.getWorldRotation()).inverseLocal().multLocal(this.getLocalRotation());
            rot.normalizeLocal();
            this.setLocalRotation(rot);
        }
        vars.release();
        this.setTransformRefresh();
    }

    protected void updateWorldBound() {
        this.refreshFlags &= 0xFFFFFFFD;
    }

    protected void updateWorldLightList() {
        if (this.parent == null) {
            this.worldLights.update(this.localLights, null);
            this.refreshFlags &= 0xFFFFFFFB;
        } else if ((this.parent.refreshFlags & 4) == 0) {
            this.worldLights.update(this.localLights, this.parent.worldLights);
            this.refreshFlags &= 0xFFFFFFFB;
        } else assert (false);
    }

    protected void updateWorldTransforms() {
        if (this.parent == null) {
            this.worldTransform.set(this.localTransform);
            this.refreshFlags &= 0xFFFFFFFE;
        } else {
            assert ((this.parent.refreshFlags & 1) == 0);
            this.worldTransform.set(this.localTransform);
            this.worldTransform.combineWithParent(this.parent.worldTransform);
            this.refreshFlags &= 0xFFFFFFFE;
        }
    }

    void checkDoTransformUpdate() {
        if ((this.refreshFlags & 1) == 0) {
            return;
        }
        if (this.parent == null) {
            this.worldTransform.set(this.localTransform);
            this.refreshFlags &= 0xFFFFFFFE;
        } else {
            TempVars vars = TempVars.get();
            Spatial[] stack = vars.spatialStack;
            Spatial rootNode = this;
            int i = 0;
            while (true) {
                Node hisParent;
                if ((hisParent = rootNode.parent) == null) {
                    rootNode.worldTransform.set(rootNode.localTransform);
                    rootNode.refreshFlags &= 0xFFFFFFFE;
                    --i;
                    break;
                }
                stack[i] = rootNode;
                if ((hisParent.refreshFlags & 1) == 0) break;
                rootNode = hisParent;
                ++i;
            }
            vars.release();
            for (int j = i; j >= 0; --j) {
                rootNode = stack[j];
                rootNode.updateWorldTransforms();
            }
        }
    }

    void checkDoBoundUpdate() {
        if ((this.refreshFlags & 2) == 0) {
            return;
        }
        this.checkDoTransformUpdate();
        if (this instanceof Node) {
            Node node = (Node)this;
            int len = node.getQuantity();
            for (int i = 0; i < len; ++i) {
                Spatial child = node.getChild(i);
                child.checkDoBoundUpdate();
            }
        }
        this.updateWorldBound();
    }

    private void runControlUpdate(float tpf) {
        if (this.controls.isEmpty()) {
            return;
        }
        for (Control c : this.controls.getArray()) {
            c.update(tpf);
        }
    }

    public void runControlRender(RenderManager rm, ViewPort vp) {
        if (this.controls.isEmpty()) {
            return;
        }
        for (Control c : this.controls.getArray()) {
            c.render(rm, vp);
        }
    }

    public void addControl(Control control) {
        this.controls.add(control);
        control.setSpatial(this);
    }

    public void removeControl(Class<? extends Control> controlType) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!controlType.isAssignableFrom(this.controls.get(i).getClass())) continue;
            Control control = this.controls.remove(i);
            control.setSpatial(null);
        }
    }

    public boolean removeControl(Control control) {
        boolean result = this.controls.remove(control);
        if (result) {
            control.setSpatial(null);
        }
        return result;
    }

    public <T extends Control> T getControl(Class<T> controlType) {
        for (Control c : this.controls.getArray()) {
            if (!controlType.isAssignableFrom(c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    public Control getControl(int index) {
        return this.controls.get(index);
    }

    public int getNumControls() {
        return this.controls.size();
    }

    public void updateLogicalState(float tpf) {
        this.runControlUpdate(tpf);
    }

    public void updateGeometricState() {
        if ((this.refreshFlags & 4) != 0) {
            this.updateWorldLightList();
        }
        if ((this.refreshFlags & 1) != 0) {
            this.updateWorldTransforms();
        }
        if ((this.refreshFlags & 2) != 0) {
            this.updateWorldBound();
        }
        assert (this.refreshFlags == 0);
    }

    public Vector3f localToWorld(Vector3f in, Vector3f store) {
        this.checkDoTransformUpdate();
        return this.worldTransform.transformVector(in, store);
    }

    public Vector3f worldToLocal(Vector3f in, Vector3f store) {
        this.checkDoTransformUpdate();
        return this.worldTransform.transformInverseVector(in, store);
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public boolean removeFromParent() {
        if (this.parent != null) {
            this.parent.detachChild(this);
            return true;
        }
        return false;
    }

    public boolean hasAncestor(Node ancestor) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.equals(ancestor)) {
            return true;
        }
        return this.parent.hasAncestor(ancestor);
    }

    public Quaternion getLocalRotation() {
        return this.localTransform.getRotation();
    }

    public void setLocalRotation(Matrix3f rotation) {
        this.localTransform.getRotation().fromRotationMatrix(rotation);
        this.setTransformRefresh();
    }

    public void setLocalRotation(Quaternion quaternion) {
        this.localTransform.setRotation(quaternion);
        this.setTransformRefresh();
    }

    public Vector3f getLocalScale() {
        return this.localTransform.getScale();
    }

    public void setLocalScale(float localScale) {
        this.localTransform.setScale(localScale);
        this.setTransformRefresh();
    }

    public void setLocalScale(float x, float y, float z) {
        this.localTransform.setScale(x, y, z);
        this.setTransformRefresh();
    }

    public void setLocalScale(Vector3f localScale) {
        this.localTransform.setScale(localScale);
        this.setTransformRefresh();
    }

    public Vector3f getLocalTranslation() {
        return this.localTransform.getTranslation();
    }

    public void setLocalTranslation(Vector3f localTranslation) {
        this.localTransform.setTranslation(localTranslation);
        this.setTransformRefresh();
    }

    public void setLocalTranslation(float x, float y, float z) {
        this.localTransform.setTranslation(x, y, z);
        this.setTransformRefresh();
    }

    public void setLocalTransform(Transform t) {
        this.localTransform.set(t);
        this.setTransformRefresh();
    }

    public Transform getLocalTransform() {
        return this.localTransform;
    }

    public void setMaterial(Material material) {
    }

    public void addLight(Light light) {
        this.localLights.add(light);
        this.setLightListRefresh();
    }

    public void removeLight(Light light) {
        this.localLights.remove(light);
        this.setLightListRefresh();
    }

    public Spatial move(float x, float y, float z) {
        this.localTransform.getTranslation().addLocal(x, y, z);
        this.setTransformRefresh();
        return this;
    }

    public Spatial move(Vector3f offset) {
        this.localTransform.getTranslation().addLocal(offset);
        this.setTransformRefresh();
        return this;
    }

    public Spatial scale(float s) {
        return this.scale(s, s, s);
    }

    public Spatial scale(float x, float y, float z) {
        this.localTransform.getScale().multLocal(x, y, z);
        this.setTransformRefresh();
        return this;
    }

    public Spatial rotate(Quaternion rot) {
        this.localTransform.getRotation().multLocal(rot);
        this.setTransformRefresh();
        return this;
    }

    public Spatial rotate(float xAngle, float yAngle, float zAngle) {
        TempVars vars = TempVars.get();
        Quaternion q = vars.quat1;
        q.fromAngles(xAngle, yAngle, zAngle);
        this.rotate(q);
        vars.release();
        return this;
    }

    public Spatial center() {
        Vector3f worldTrans = this.getWorldTranslation();
        Vector3f worldCenter = this.getWorldBound().getCenter();
        Vector3f absTrans = worldTrans.subtract(worldCenter);
        this.setLocalTranslation(absTrans);
        return this;
    }

    public CullHint getCullHint() {
        if (this.cullHint != CullHint.Inherit) {
            return this.cullHint;
        }
        if (this.parent != null) {
            return this.parent.getCullHint();
        }
        return CullHint.Dynamic;
    }

    public BatchHint getBatchHint() {
        if (this.batchHint != BatchHint.Inherit) {
            return this.batchHint;
        }
        if (this.parent != null) {
            return this.parent.getBatchHint();
        }
        return BatchHint.Always;
    }

    public RenderQueue.Bucket getQueueBucket() {
        if (this.queueBucket != RenderQueue.Bucket.Inherit) {
            return this.queueBucket;
        }
        if (this.parent != null) {
            return this.parent.getQueueBucket();
        }
        return RenderQueue.Bucket.Opaque;
    }

    public RenderQueue.ShadowMode getShadowMode() {
        if (this.shadowMode != RenderQueue.ShadowMode.Inherit) {
            return this.shadowMode;
        }
        if (this.parent != null) {
            return this.parent.getShadowMode();
        }
        return RenderQueue.ShadowMode.Off;
    }

    public void setLodLevel(int lod) {
    }

    public abstract void updateModelBound();

    public abstract void setModelBound(BoundingVolume var1);

    public abstract int getVertexCount();

    public abstract int getTriangleCount();

    public Spatial clone(boolean cloneMaterial) {
        try {
            Spatial clone = (Spatial)super.clone();
            if (this.worldBound != null) {
                clone.worldBound = this.worldBound.clone();
            }
            clone.worldLights = this.worldLights.clone();
            clone.localLights = this.localLights.clone();
            clone.localLights.setOwner(clone);
            clone.worldLights.setOwner(clone);
            clone.worldTransform = this.worldTransform.clone();
            clone.localTransform = this.localTransform.clone();
            if (clone instanceof Node) {
                Node node = (Node)this;
                Node nodeClone = (Node)clone;
                nodeClone.children = new SafeArrayList<Spatial>(Spatial.class);
                for (Spatial child : node.children) {
                    Spatial childClone = child.clone(cloneMaterial);
                    childClone.parent = nodeClone;
                    nodeClone.children.add(childClone);
                }
            }
            clone.parent = null;
            clone.setBoundRefresh();
            clone.setTransformRefresh();
            clone.setLightListRefresh();
            clone.controls = new SafeArrayList<Control>(Control.class);
            for (int i = 0; i < this.controls.size(); ++i) {
                Control newControl = this.controls.get(i).cloneForSpatial(clone);
                newControl.setSpatial(clone);
                clone.controls.add(newControl);
            }
            if (this.userData != null) {
                clone.userData = (HashMap)this.userData.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public Spatial clone() {
        return this.clone(true);
    }

    public abstract Spatial deepClone();

    public void setUserData(String key, Object data) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        if (data == null) {
            this.userData.remove(key);
        } else if (data instanceof Savable) {
            this.userData.put(key, (Savable)data);
        } else {
            this.userData.put(key, new UserData(UserData.getObjectType(data), data));
        }
    }

    public <T> T getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        Savable s = this.userData.get(key);
        if (s instanceof UserData) {
            return (T)((UserData)s).getValue();
        }
        return (T)s;
    }

    public Collection<String> getUserDataKeys() {
        if (this.userData != null) {
            return this.userData.keySet();
        }
        return Collections.EMPTY_SET;
    }

    public boolean matches(Class<? extends Spatial> spatialSubclass, String nameRegex) {
        if (spatialSubclass != null && !spatialSubclass.isInstance(this)) {
            return false;
        }
        return nameRegex == null || this.name != null && this.name.matches(nameRegex);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.name, "name", null);
        capsule.write(this.worldBound, "world_bound", null);
        capsule.write(this.cullHint, "cull_mode", CullHint.Inherit);
        capsule.write(this.batchHint, "batch_hint", BatchHint.Inherit);
        capsule.write(this.queueBucket, "queue", RenderQueue.Bucket.Inherit);
        capsule.write(this.shadowMode, "shadow_mode", RenderQueue.ShadowMode.Inherit);
        capsule.write(this.localTransform, "transform", Transform.IDENTITY);
        capsule.write(this.localLights, "lights", null);
        capsule.writeSavableArrayList(new ArrayList<Control>(this.controls), "controlsList", null);
        capsule.writeStringSavableMap(this.userData, "user_data", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.worldBound = (BoundingVolume)ic.readSavable("world_bound", null);
        this.cullHint = ic.readEnum("cull_mode", CullHint.class, CullHint.Inherit);
        this.batchHint = ic.readEnum("batch_hint", BatchHint.class, BatchHint.Inherit);
        this.queueBucket = ic.readEnum("queue", RenderQueue.Bucket.class, RenderQueue.Bucket.Inherit);
        this.shadowMode = ic.readEnum("shadow_mode", RenderQueue.ShadowMode.class, RenderQueue.ShadowMode.Inherit);
        this.localTransform = (Transform)ic.readSavable("transform", Transform.IDENTITY);
        this.localLights = (LightList)ic.readSavable("lights", null);
        this.localLights.setOwner(this);
        this.controls.addAll(0, ic.readSavableArrayList("controlsList", null));
        this.userData = (HashMap)ic.readStringSavableMap("user_data", null);
    }

    public BoundingVolume getWorldBound() {
        this.checkDoBoundUpdate();
        return this.worldBound;
    }

    public void setCullHint(CullHint hint) {
        this.cullHint = hint;
    }

    public void setBatchHint(BatchHint hint) {
        this.batchHint = hint;
    }

    public CullHint getLocalCullHint() {
        return this.cullHint;
    }

    public BatchHint getLocalBatchHint() {
        return this.batchHint;
    }

    public void setQueueBucket(RenderQueue.Bucket queueBucket) {
        this.queueBucket = queueBucket;
    }

    public void setShadowMode(RenderQueue.ShadowMode shadowMode) {
        this.shadowMode = shadowMode;
    }

    public RenderQueue.Bucket getLocalQueueBucket() {
        return this.queueBucket;
    }

    public RenderQueue.ShadowMode getLocalShadowMode() {
        return this.shadowMode;
    }

    public Camera.FrustumIntersect getLastFrustumIntersection() {
        return this.frustrumIntersects;
    }

    public void setLastFrustumIntersection(Camera.FrustumIntersect intersects) {
        this.frustrumIntersects = intersects;
    }

    public String toString() {
        return this.name + " (" + this.getClass().getSimpleName() + ')';
    }

    public Matrix4f getLocalToWorldMatrix(Matrix4f store) {
        if (store == null) {
            store = new Matrix4f();
        } else {
            store.loadIdentity();
        }
        store.scale(this.getWorldScale());
        store.multLocal(this.getWorldRotation());
        store.setTranslation(this.getWorldTranslation());
        return store;
    }

    public abstract void depthFirstTraversal(SceneGraphVisitor var1);

    public void breadthFirstTraversal(SceneGraphVisitor visitor) {
        LinkedList<Spatial> queue = new LinkedList<Spatial>();
        queue.add(this);
        while (!queue.isEmpty()) {
            Spatial s = (Spatial)queue.poll();
            visitor.visit(s);
            s.breadthFirstTraversal(visitor, queue);
        }
    }

    protected abstract void breadthFirstTraversal(SceneGraphVisitor var1, Queue<Spatial> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchHint {
        Inherit,
        Always,
        Never;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CullHint {
        Inherit,
        Dynamic,
        Always,
        Never;

    }
}

