/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.textures.UserUVCollection;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeshBuilder {
    private static final Logger LOGGER = Logger.getLogger(MeshBuilder.class.getName());
    private Vector3f[][] verticesAndNormals;
    private List<byte[]> verticesColors;
    private boolean usesGeneratedTextures;
    private Map<Integer, Map<Integer, List<Integer>>> globalVertexReferenceMap;
    private Map<Integer, List<Vector3f>> normalMap = new HashMap<Integer, List<Vector3f>>();
    private Map<Integer, List<Vector3f>> vertexMap = new HashMap<Integer, List<Vector3f>>();
    private Map<Integer, List<byte[]>> vertexColorsMap = new HashMap<Integer, List<byte[]>>();
    private Map<Integer, List<Integer>> indexMap = new HashMap<Integer, List<Integer>>();
    private UserUVCollection userUVCollection = new UserUVCollection();

    public MeshBuilder(Vector3f[][] verticesAndNormals, List<byte[]> verticesColors, boolean usesGeneratedTextures) {
        this.verticesAndNormals = verticesAndNormals;
        this.verticesColors = verticesColors;
        this.usesGeneratedTextures = usesGeneratedTextures;
        this.globalVertexReferenceMap = new HashMap<Integer, Map<Integer, List<Integer>>>(verticesAndNormals.length);
    }

    public void appendPoint(Vector3f coordinates, Vector3f normal, int materialNumber) {
        LOGGER.warning("Appending single point not yet supported!");
    }

    public void appendEdge(int v1, int v2, boolean smooth) {
        LOGGER.warning("Appending single line not yet supported!");
    }

    public void appendFace(int v1, int v2, int v3, boolean smooth, int materialNumber, Map<String, Vector2f[]> uvsForFace, boolean quad, int faceIndex) {
        Map<Integer, List<Integer>> vertexReferenceMap;
        List<Vector3f> normalList;
        List<Vector3f> vertexList;
        List<Integer> indexList;
        if (uvsForFace != null && uvsForFace.size() > 0) {
            for (Map.Entry<String, Vector2f[]> entry : uvsForFace.entrySet()) {
                if (entry.getValue().length == 3) continue;
                throw new IllegalArgumentException("UV coordinates must be a 3-element array!" + (entry.getKey() != null ? " (UV set name: " + entry.getKey() + ')' : ""));
            }
        }
        if ((indexList = this.indexMap.get(materialNumber)) == null) {
            indexList = new ArrayList<Integer>();
            this.indexMap.put(materialNumber, indexList);
        }
        if ((vertexList = this.vertexMap.get(materialNumber)) == null) {
            vertexList = new ArrayList<Vector3f>();
            this.vertexMap.put(materialNumber, vertexList);
        }
        List<byte[]> vertexColorsList = this.vertexColorsMap != null ? this.vertexColorsMap.get(materialNumber) : null;
        int[] vertexColorIndex = new int[]{0, 1, 2};
        if (vertexColorsList == null && this.vertexColorsMap != null) {
            vertexColorsList = new ArrayList<byte[]>();
            this.vertexColorsMap.put(materialNumber, vertexColorsList);
        }
        if ((normalList = this.normalMap.get(materialNumber)) == null) {
            normalList = new ArrayList<Vector3f>();
            this.normalMap.put(materialNumber, normalList);
        }
        if ((vertexReferenceMap = this.globalVertexReferenceMap.get(materialNumber)) == null) {
            vertexReferenceMap = new HashMap<Integer, List<Integer>>();
            this.globalVertexReferenceMap.put(materialNumber, vertexReferenceMap);
        }
        faceIndex *= 4;
        if (quad) {
            vertexColorIndex[1] = 2;
            vertexColorIndex[2] = 3;
        }
        Integer[] index = new Integer[]{v1, v2, v3};
        if (smooth && !this.usesGeneratedTextures) {
            for (int i = 0; i < 3; ++i) {
                if (!vertexReferenceMap.containsKey(index[i])) {
                    this.appendVertexReference(index[i], vertexList.size(), vertexReferenceMap);
                    if (uvsForFace != null) {
                        for (Map.Entry<String, Vector2f[]> entry : uvsForFace.entrySet()) {
                            this.userUVCollection.addUV(materialNumber, entry.getKey(), entry.getValue()[i], vertexList.size());
                        }
                    }
                    vertexList.add(this.verticesAndNormals[index[i]][0]);
                    if (this.verticesColors != null) {
                        vertexColorsList.add(this.verticesColors.get(faceIndex + vertexColorIndex[i]));
                    }
                    normalList.add(this.verticesAndNormals[index[i]][1]);
                    index[i] = vertexList.size() - 1;
                } else if (uvsForFace != null) {
                    boolean vertexAlreadyUsed = false;
                    for (Integer n : vertexReferenceMap.get(index[i])) {
                        int vertexUseCounter = 0;
                        for (Map.Entry<String, Vector2f[]> entry : uvsForFace.entrySet()) {
                            if (!entry.getValue()[i].equals(this.userUVCollection.getUVForVertex(entry.getKey(), n))) continue;
                            ++vertexUseCounter;
                        }
                        if (vertexUseCounter != uvsForFace.size()) continue;
                        vertexAlreadyUsed = true;
                        index[i] = n;
                        break;
                    }
                    if (!vertexAlreadyUsed) {
                        this.appendVertexReference(index[i], vertexList.size(), vertexReferenceMap);
                        for (Map.Entry entry : uvsForFace.entrySet()) {
                            this.userUVCollection.addUV(materialNumber, (String)entry.getKey(), ((Vector2f[])entry.getValue())[i], vertexList.size());
                        }
                        vertexList.add(this.verticesAndNormals[index[i]][0]);
                        if (this.verticesColors != null) {
                            vertexColorsList.add(this.verticesColors.get(faceIndex + vertexColorIndex[i]));
                        }
                        normalList.add(this.verticesAndNormals[index[i]][1]);
                        index[i] = vertexList.size() - 1;
                    }
                } else {
                    index[i] = vertexList.indexOf(this.verticesAndNormals[index[i]][0]);
                }
                indexList.add(index[i]);
            }
        } else {
            Vector3f n = smooth ? null : FastMath.computeNormal(this.verticesAndNormals[v1][0], this.verticesAndNormals[v2][0], this.verticesAndNormals[v3][0]);
            for (int i = 0; i < 3; ++i) {
                indexList.add(vertexList.size());
                this.appendVertexReference(index[i], vertexList.size(), vertexReferenceMap);
                if (uvsForFace != null) {
                    for (Map.Entry<String, Vector2f[]> entry : uvsForFace.entrySet()) {
                        this.userUVCollection.addUV(materialNumber, entry.getKey(), entry.getValue()[i], vertexList.size());
                    }
                }
                vertexList.add(this.verticesAndNormals[index[i]][0]);
                if (this.verticesColors != null) {
                    vertexColorsList.add(this.verticesColors.get(faceIndex + vertexColorIndex[i]));
                }
                normalList.add(smooth ? this.verticesAndNormals[index[i]][1] : n);
            }
        }
    }

    public Map<Integer, Map<Integer, List<Integer>>> getVertexReferenceMap() {
        return this.globalVertexReferenceMap;
    }

    public Vector3f[] getVertices(int materialNumber) {
        return this.vertexMap.get(materialNumber).toArray(new Vector3f[this.vertexMap.get(materialNumber).size()]);
    }

    public int getVerticesAmount(int materialNumber) {
        return this.vertexMap.get(materialNumber).size();
    }

    public Vector3f[] getNormals(int materialNumber) {
        return this.normalMap.get(materialNumber).toArray(new Vector3f[this.normalMap.get(materialNumber).size()]);
    }

    public ByteBuffer getVertexColorsBuffer(int materialNumber) {
        ByteBuffer result = null;
        if (this.verticesColors != null && this.vertexColorsMap.get(materialNumber) != null) {
            List<byte[]> data = this.vertexColorsMap.get(materialNumber);
            result = BufferUtils.createByteBuffer(4 * data.size());
            for (byte[] v : data) {
                if (v != null) {
                    result.put(v[0]).put(v[1]).put(v[2]).put(v[3]);
                    continue;
                }
                result.put((byte)0).put((byte)0).put((byte)0).put((byte)0);
            }
            result.flip();
        }
        return result;
    }

    public Map<Integer, List<Integer>> getMeshesMap() {
        return this.indexMap;
    }

    public int getMeshesPartAmount() {
        return this.indexMap.size();
    }

    public LinkedHashMap<String, List<Vector2f>> getUVCoordinates(int materialNumber) {
        return this.userUVCollection.getUVCoordinates(materialNumber);
    }

    public boolean hasUVCoordinates() {
        return this.userUVCollection.hasUVCoordinates();
    }

    public boolean isEmpty() {
        return this.vertexMap.size() == 0;
    }

    private void appendVertexReference(int basicVertexIndex, int resultIndex, Map<Integer, List<Integer>> vertexReferenceMap) {
        List<Integer> referenceList = vertexReferenceMap.get(basicVertexIndex);
        if (referenceList == null) {
            referenceList = new ArrayList<Integer>();
            vertexReferenceMap.put(basicVertexIndex, referenceList);
        }
        referenceList.add(resultIndex);
    }
}

