/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.GeneratedTexture;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.TriangulatedTexture;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.scene.plugins.blender.textures.UVProjectionGenerator;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedTexture {
    private static final Logger LOGGER = Logger.getLogger(CombinedTexture.class.getName());
    private final int mappingType;
    private List<TextureData> textureDatas = new ArrayList<TextureData>();
    private Texture resultTexture;
    private List<Vector2f> resultUVS;

    public CombinedTexture(int mappingType) {
        this.mappingType = mappingType;
    }

    public void add(Texture texture, TextureBlender textureBlender, int uvCoordinatesType, int projectionType, Structure textureStructure, String uvCoordinatesName, BlenderContext blenderContext) {
        if (!(texture instanceof GeneratedTexture) && !(texture instanceof Texture2D)) {
            throw new IllegalArgumentException("Unsupported texture type: " + (texture == null ? "null" : texture.getClass()));
        }
        if (!(texture instanceof GeneratedTexture) || blenderContext.getBlenderKey().isLoadGeneratedTextures()) {
            if (UVCoordinatesGenerator.isTextureCoordinateTypeSupported(UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType))) {
                TextureData textureData = new TextureData();
                textureData.texture = texture;
                textureData.textureBlender = textureBlender;
                textureData.uvCoordinatesType = UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType);
                textureData.projectionType = UVProjectionGenerator.UVProjectionType.valueOf(projectionType);
                textureData.textureStructure = textureStructure;
                textureData.uvCoordinatesName = uvCoordinatesName;
                if (this.textureDatas.size() > 0 && this.isWithoutAlpha(textureData, blenderContext)) {
                    this.textureDatas.clear();
                }
                this.textureDatas.add(textureData);
            } else {
                LOGGER.warning("The texture coordinates type is not supported: " + (Object)((Object)UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType)) + ". The texture '" + textureStructure.getName() + "'.");
            }
        }
    }

    public void flatten(Geometry geometry, Long geometriesOMA, LinkedHashMap<String, List<Vector2f>> userDefinedUVCoordinates, BlenderContext blenderContext) {
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        Mesh mesh = geometry.getMesh();
        Texture previousTexture = null;
        UVCoordinatesGenerator.UVCoordinatesType masterUVCoordinatesType = null;
        String masterUserUVSetName = null;
        for (TextureData textureData : this.textureDatas) {
            if (this.textureDatas.size() > 1 && textureData.texture.getImage().getFormat().isCompressed()) {
                textureData.texture.setImage(textureHelper.decompress(textureData.texture.getImage()));
                textureData.textureBlender = TextureBlenderFactory.alterTextureType(textureData.texture.getImage().getFormat(), textureData.textureBlender);
            }
            if (previousTexture == null) {
                if (textureData.texture instanceof GeneratedTexture) {
                    this.resultTexture = ((GeneratedTexture)textureData.texture).triangulate(mesh, geometriesOMA, textureData.uvCoordinatesType, blenderContext);
                } else if (textureData.texture instanceof Texture2D) {
                    this.resultTexture = textureData.texture;
                    if (textureData.uvCoordinatesType == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV && userDefinedUVCoordinates != null && userDefinedUVCoordinates.size() > 0) {
                        this.resultUVS = textureData.uvCoordinatesName == null ? userDefinedUVCoordinates.values().iterator().next() : userDefinedUVCoordinates.get(textureData.uvCoordinatesName);
                        masterUserUVSetName = textureData.uvCoordinatesName;
                    } else {
                        List geometries = (List)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                        this.resultUVS = UVCoordinatesGenerator.generateUVCoordinatesFor2DTexture(mesh, textureData.uvCoordinatesType, textureData.projectionType, geometries);
                    }
                }
                this.blend(this.resultTexture, textureData.textureBlender, blenderContext);
                previousTexture = this.resultTexture;
                masterUVCoordinatesType = textureData.uvCoordinatesType;
                continue;
            }
            if (textureData.texture instanceof GeneratedTexture) {
                if (!(this.resultTexture instanceof TriangulatedTexture)) {
                    this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                    this.resultUVS = null;
                    previousTexture = this.resultTexture;
                }
                TriangulatedTexture triangulatedTexture = ((GeneratedTexture)textureData.texture).triangulate(mesh, geometriesOMA, textureData.uvCoordinatesType, blenderContext);
                triangulatedTexture.castToUVS((TriangulatedTexture)this.resultTexture, blenderContext);
                triangulatedTexture.blend(textureData.textureBlender, (TriangulatedTexture)this.resultTexture, blenderContext);
                this.resultTexture = previousTexture = triangulatedTexture;
                continue;
            }
            if (!(textureData.texture instanceof Texture2D)) continue;
            if (this.isUVTypesMatch(masterUVCoordinatesType, masterUserUVSetName, textureData.uvCoordinatesType, textureData.uvCoordinatesName) && this.resultTexture instanceof Texture2D) {
                this.scale((Texture2D)textureData.texture, this.resultTexture.getImage().getWidth(), this.resultTexture.getImage().getHeight());
                this.merge((Texture2D)this.resultTexture, (Texture2D)textureData.texture);
                previousTexture = this.resultTexture;
                continue;
            }
            if (!(this.resultTexture instanceof TriangulatedTexture)) {
                this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                this.resultUVS = null;
            }
            List<Vector2f> textureUVS = null;
            if (textureData.uvCoordinatesType == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV && userDefinedUVCoordinates != null && userDefinedUVCoordinates.size() > 0) {
                textureUVS = textureData.uvCoordinatesName == null ? userDefinedUVCoordinates.values().iterator().next() : userDefinedUVCoordinates.get(textureData.uvCoordinatesName);
            } else {
                List geometries = (List)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                textureUVS = UVCoordinatesGenerator.generateUVCoordinatesFor2DTexture(mesh, textureData.uvCoordinatesType, textureData.projectionType, geometries);
            }
            TriangulatedTexture triangulatedTexture = new TriangulatedTexture((Texture2D)textureData.texture, textureUVS, blenderContext);
            triangulatedTexture.castToUVS((TriangulatedTexture)this.resultTexture, blenderContext);
            ((TriangulatedTexture)this.resultTexture).merge(triangulatedTexture);
        }
        if (this.resultTexture instanceof TriangulatedTexture) {
            if (this.mappingType == 2) {
                for (int i = 0; i < ((TriangulatedTexture)this.resultTexture).getFaceTextureCount(); ++i) {
                    TriangulatedTexture.TriangleTextureElement triangleTextureElement = ((TriangulatedTexture)this.resultTexture).getFaceTextureElement(i);
                    triangleTextureElement.image = textureHelper.convertToNormalMapTexture(triangleTextureElement.image, 1.0f);
                }
            }
            this.resultUVS = ((TriangulatedTexture)this.resultTexture).getResultUVS();
            this.resultTexture = ((TriangulatedTexture)this.resultTexture).getResultTexture();
        }
        this.resultTexture.setWrap(Texture.WrapMode.Repeat);
        this.resultTexture.setMagFilter(Texture.MagFilter.Nearest);
        this.resultTexture.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
    }

    private boolean isUVTypesMatch(UVCoordinatesGenerator.UVCoordinatesType type1, String uvSetName1, UVCoordinatesGenerator.UVCoordinatesType type2, String uvSetName2) {
        if (type1 == type2) {
            if (type1 == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV) {
                if (uvSetName1 != null && uvSetName2 != null && uvSetName1.equals(uvSetName2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void blend(Texture texture, TextureBlender textureBlender, BlenderContext blenderContext) {
        if (texture instanceof TriangulatedTexture) {
            ((TriangulatedTexture)texture).blend(textureBlender, null, blenderContext);
        } else if (texture instanceof Texture2D) {
            Image blendedImage = textureBlender.blend(texture.getImage(), null, blenderContext);
            texture.setImage(blendedImage);
        } else {
            throw new IllegalArgumentException("Invalid type for texture to blend!");
        }
    }

    public Texture getResultTexture() {
        return this.resultTexture;
    }

    public List<Vector2f> getResultUVS() {
        return this.resultUVS;
    }

    public int getTexturesCount() {
        return this.textureDatas.size();
    }

    public boolean hasGeneratedTextures() {
        if (this.textureDatas != null) {
            for (TextureData textureData : this.textureDatas) {
                if (!(textureData.texture instanceof GeneratedTexture)) continue;
                return true;
            }
        }
        return false;
    }

    private void merge(Texture2D target, Texture2D source) {
        if (target.getImage().getDepth() != source.getImage().getDepth()) {
            throw new IllegalArgumentException("Cannot merge images with different depths!");
        }
        Image sourceImage = source.getImage();
        Image targetImage = target.getImage();
        PixelInputOutput sourceIO = PixelIOFactory.getPixelIO(sourceImage.getFormat());
        PixelInputOutput targetIO = PixelIOFactory.getPixelIO(targetImage.getFormat());
        TexturePixel sourcePixel = new TexturePixel();
        TexturePixel targetPixel = new TexturePixel();
        int depth = target.getImage().getDepth() == 0 ? 1 : target.getImage().getDepth();
        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
            for (int x = 0; x < sourceImage.getWidth(); ++x) {
                for (int y = 0; y < sourceImage.getHeight(); ++y) {
                    sourceIO.read(sourceImage, layerIndex, sourcePixel, x, y);
                    targetIO.read(targetImage, layerIndex, targetPixel, x, y);
                    targetPixel.merge(sourcePixel);
                    targetIO.write(targetImage, layerIndex, targetPixel, x, y);
                }
            }
        }
    }

    private boolean isWithoutAlpha(TextureData textureData, BlenderContext blenderContext) {
        ColorBand colorBand = new ColorBand(textureData.textureStructure, blenderContext);
        if (!colorBand.hasTransparencies()) {
            int type = ((Number)textureData.textureStructure.getFieldValue("type")).intValue();
            if (type == 4) {
                return true;
            }
            if (type == 12) {
                int voronoiColorType = ((Number)textureData.textureStructure.getFieldValue("vn_coltype")).intValue();
                return voronoiColorType != 0;
            }
            if (type == 1) {
                int sType = ((Number)textureData.textureStructure.getFieldValue("stype")).intValue();
                return sType == 1;
            }
            if (type == 8) {
                Image image = textureData.texture.getImage();
                switch (image.getFormat()) {
                    case BGR8: 
                    case DXT1: 
                    case Luminance16: 
                    case Luminance16F: 
                    case Luminance32F: 
                    case Luminance8: 
                    case RGB10: 
                    case RGB111110F: 
                    case RGB16: 
                    case RGB16F: 
                    case RGB32F: 
                    case RGB565: 
                    case RGB8: {
                        return true;
                    }
                    case ABGR8: 
                    case DXT3: 
                    case DXT5: 
                    case Luminance16Alpha16: 
                    case Luminance16FAlpha16F: 
                    case Luminance8Alpha8: 
                    case RGBA16: 
                    case RGBA16F: 
                    case RGBA32F: 
                    case RGBA8: {
                        PixelInputOutput pixelInputOutput = PixelIOFactory.getPixelIO(image.getFormat());
                        TexturePixel pixel = new TexturePixel();
                        int depth = image.getDepth() == 0 ? 1 : image.getDepth();
                        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                            for (int x = 0; x < image.getWidth(); ++x) {
                                for (int y = 0; y < image.getHeight(); ++y) {
                                    pixelInputOutput.read(image, layerIndex, pixel, x, y);
                                    if (!(pixel.alpha < 1.0f)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void scale(Texture2D texture, int width, int height) {
        boolean scaleRequired;
        boolean bl = scaleRequired = texture.getImage().getWidth() != width || texture.getImage().getHeight() != height;
        if (scaleRequired) {
            Image image = texture.getImage();
            BufferedImage sourceImage = ImageToAwt.convert(image, false, true, 0);
            int sourceWidth = sourceImage.getWidth();
            int sourceHeight = sourceImage.getHeight();
            BufferedImage targetImage = new BufferedImage(width, height, sourceImage.getType());
            Graphics2D g = targetImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(sourceImage, 0, 0, width, height, 0, 0, sourceWidth, sourceHeight, null);
            g.dispose();
            Image output = new ImageLoader().load(targetImage, false);
            image.setWidth(width);
            image.setHeight(height);
            image.setData(output.getData(0));
            image.setFormat(output.getFormat());
        }
    }

    private static class TextureData {
        public Texture texture;
        public TextureBlender textureBlender;
        public UVCoordinatesGenerator.UVCoordinatesType uvCoordinatesType;
        public UVProjectionGenerator.UVProjectionType projectionType;
        public Structure textureStructure;
        public String uvCoordinatesName;

        private TextureData() {
        }
    }
}

