/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;

class DDSTexelData {
    private TexturePixel[][] colors;
    private long[] indexes;
    private float[][] alphas;
    private long[] alphaIndexes;
    private int xCounter;
    private int yCounter;
    private int widthInPixels;
    private int heightInPixels;
    private int xTexelCount;

    public DDSTexelData(int compressedSize, float widthToHeightRatio, Image.Format format) {
        int texelsCount = compressedSize * 8 / format.getBitsPerPixel() / 16;
        this.colors = new TexturePixel[texelsCount][];
        this.indexes = new long[texelsCount];
        this.widthInPixels = (int)(0.5f * (float)Math.sqrt((float)this.getSizeInBytes() / widthToHeightRatio));
        this.heightInPixels = (int)((float)this.widthInPixels / widthToHeightRatio);
        this.xTexelCount = this.widthInPixels >> 2;
        this.yCounter = (this.heightInPixels >> 2) - 1;
        if (format == Image.Format.DXT3 || format == Image.Format.DXT5) {
            this.alphas = new float[texelsCount][];
            this.alphaIndexes = new long[texelsCount];
        }
    }

    public void add(TexturePixel[] colors, int indexes) {
        this.add(colors, indexes, null, 0L);
    }

    public void add(TexturePixel[] colors, int indexes, float[] alphas, long alphaIndexes) {
        int index = this.yCounter * this.xTexelCount + this.xCounter;
        this.colors[index] = colors;
        this.indexes[index] = indexes;
        if (alphas != null) {
            this.alphas[index] = alphas;
            this.alphaIndexes[index] = alphaIndexes;
        }
        ++this.xCounter;
        if (this.xCounter >= this.xTexelCount) {
            this.xCounter = 0;
            --this.yCounter;
        }
    }

    public boolean getRGBA8(int x, int y, byte[] result) {
        int yTexelIndex = y % this.heightInPixels / 4;
        int xTexetlIndex = x % this.widthInPixels / 4;
        int texelIndex = yTexelIndex * this.xTexelCount + xTexetlIndex;
        if (texelIndex < this.colors.length) {
            TexturePixel[] colors = this.colors[texelIndex];
            y = 3 - y - 4 * yTexelIndex;
            int pixelIndexInTexel = (y * 4 + (x -= 4 * xTexetlIndex)) * (int)FastMath.log(colors.length, 2.0f);
            int alphaIndexInTexel = this.alphas != null ? (y * 4 + x) * (int)FastMath.log(this.alphas.length, 2.0f) : 0;
            int indexMask = colors.length - 1;
            int colorIndex = (int)(this.indexes[texelIndex] >> pixelIndexInTexel & (long)indexMask);
            float alpha = this.alphas != null ? this.alphas[texelIndex][(int)(this.alphaIndexes[texelIndex] >> alphaIndexInTexel & 7L)] : colors[colorIndex].alpha;
            result[0] = (byte)(colors[colorIndex].red * 255.0f);
            result[1] = (byte)(colors[colorIndex].green * 255.0f);
            result[2] = (byte)(colors[colorIndex].blue * 255.0f);
            result[3] = (byte)(alpha * 255.0f);
            return true;
        }
        return false;
    }

    public int getSizeInBytes() {
        return this.indexes.length * 16 * 4;
    }

    public int getPixelWidth() {
        return this.widthInPixels;
    }

    public int getPixelHeight() {
        return this.heightInPixels;
    }
}

