/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.Vector2f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserUVCollection {
    private Map<Integer, LinkedHashMap<String, List<Vector2f>>> uvCoordinates = new HashMap<Integer, LinkedHashMap<String, List<Vector2f>>>();
    private Map<String, Map<Integer, Vector2f>> uvsMap = new HashMap<String, Map<Integer, Vector2f>>();

    public void addUV(int materialIndex, String uvSetName, Vector2f uv, int jmeVertexIndex) {
        List<Vector2f> uvsForName;
        LinkedHashMap<String, List<Vector2f>> uvsForMaterial = this.uvCoordinates.get(materialIndex);
        if (uvsForMaterial == null) {
            uvsForMaterial = new LinkedHashMap();
            this.uvCoordinates.put(materialIndex, uvsForMaterial);
        }
        if ((uvsForName = uvsForMaterial.get(uvSetName)) == null) {
            uvsForName = new ArrayList<Vector2f>();
            uvsForMaterial.put(uvSetName, uvsForName);
        }
        uvsForName.add(uv);
        Map<Integer, Vector2f> uvToVertexIndexMapping = this.uvsMap.get(uvSetName);
        if (uvToVertexIndexMapping == null) {
            uvToVertexIndexMapping = new HashMap<Integer, Vector2f>();
            this.uvsMap.put(uvSetName, uvToVertexIndexMapping);
        }
        uvToVertexIndexMapping.put(jmeVertexIndex, uv);
    }

    public Vector2f getUVForVertex(String uvSetName, int vertexIndex) {
        return this.uvsMap.get(uvSetName).get(vertexIndex);
    }

    public LinkedHashMap<String, List<Vector2f>> getUVCoordinates(int materialNumber) {
        return this.uvCoordinates.get(materialNumber);
    }

    public boolean hasUVCoordinates() {
        return this.uvCoordinates.size() > 0;
    }
}

