/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.renderer.Renderer;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.Uniform;
import com.jme3.util.IntMap;
import com.jme3.util.ListMap;
import com.jme3.util.NativeObject;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Shader
extends NativeObject {
    private ArrayList<ShaderSource> shaderSourceList;
    private ListMap<String, Uniform> uniforms;
    private IntMap<Attribute> attribs;

    public void initialize() {
        this.shaderSourceList = new ArrayList();
        this.uniforms = new ListMap();
        this.attribs = new IntMap();
    }

    public Shader() {
    }

    protected Shader(Shader s) {
        super(s.id);
        this.shaderSourceList = new ArrayList();
        for (ShaderSource source : s.shaderSourceList) {
            this.shaderSourceList.add((ShaderSource)source.createDestructableClone());
        }
    }

    public void addSource(ShaderType type, String name, String source, String defines, String language) {
        ShaderSource shaderSource = new ShaderSource(type);
        shaderSource.setSource(source);
        shaderSource.setName(name);
        shaderSource.setLanguage(language);
        if (defines != null) {
            shaderSource.setDefines(defines);
        }
        this.shaderSourceList.add(shaderSource);
        this.setUpdateNeeded();
    }

    public Uniform getUniform(String name) {
        Uniform uniform = this.uniforms.get(name);
        if (uniform == null) {
            uniform = new Uniform();
            uniform.name = name;
            this.uniforms.put(name, uniform);
        }
        return uniform;
    }

    public void removeUniform(String name) {
        this.uniforms.remove(name);
    }

    public Attribute getAttribute(VertexBuffer.Type attribType) {
        int ordinal = attribType.ordinal();
        Attribute attrib = this.attribs.get(ordinal);
        if (attrib == null) {
            attrib = new Attribute();
            attrib.name = attribType.name();
            this.attribs.put(ordinal, attrib);
        }
        return attrib;
    }

    public ListMap<String, Uniform> getUniformMap() {
        return this.uniforms;
    }

    public Collection<ShaderSource> getSources() {
        return this.shaderSourceList;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[numSources=" + this.shaderSourceList.size() + ", numUniforms=" + this.uniforms.size() + ", shaderSources=" + this.getSources() + "]";
    }

    public void resetLocations() {
        if (this.uniforms != null) {
            for (Uniform uniform : this.uniforms.values()) {
                uniform.reset();
            }
        }
        if (this.attribs != null) {
            for (IntMap.Entry entry : this.attribs) {
                ((Attribute)entry.getValue()).location = -2;
            }
        }
    }

    @Override
    public void setUpdateNeeded() {
        super.setUpdateNeeded();
        this.resetLocations();
    }

    @Override
    public void resetObject() {
        this.id = -1;
        for (ShaderSource source : this.shaderSourceList) {
            source.resetObject();
        }
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteShader(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new Shader(this);
    }

    @Override
    public long getUniqueId() {
        return 0x400000000L | (long)this.id;
    }

    public static class ShaderSource
    extends NativeObject {
        ShaderType sourceType;
        String language;
        String name;
        String source;
        String defines;

        public ShaderSource(ShaderType type) {
            this.sourceType = type;
            if (type == null) {
                throw new IllegalArgumentException("The shader type must be specified");
            }
        }

        protected ShaderSource(ShaderSource ss) {
            super(ss.id);
        }

        public ShaderSource() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ShaderType getType() {
            return this.sourceType;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            if (language == null) {
                throw new IllegalArgumentException("Shader language cannot be null");
            }
            this.language = language;
            this.setUpdateNeeded();
        }

        public void setSource(String source) {
            if (source == null) {
                throw new IllegalArgumentException("Shader source cannot be null");
            }
            this.source = source;
            this.setUpdateNeeded();
        }

        public void setDefines(String defines) {
            if (defines == null) {
                throw new IllegalArgumentException("Shader defines cannot be null");
            }
            this.defines = defines;
            this.setUpdateNeeded();
        }

        public String getSource() {
            return this.source;
        }

        public String getDefines() {
            return this.defines;
        }

        public long getUniqueId() {
            return 0x500000000L | (long)this.id;
        }

        public String toString() {
            String nameTxt = "";
            if (this.name != null) {
                nameTxt = "name=" + this.name + ", ";
            }
            if (this.defines != null) {
                nameTxt = nameTxt + "defines, ";
            }
            return this.getClass().getSimpleName() + "[" + nameTxt + "type=" + this.sourceType.name() + ", language=" + this.language + "]";
        }

        public void resetObject() {
            this.id = -1;
            this.setUpdateNeeded();
        }

        public void deleteObject(Object rendererObject) {
            ((Renderer)rendererObject).deleteShaderSource(this);
        }

        public NativeObject createDestructableClone() {
            return new ShaderSource(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShaderType {
        Fragment,
        Vertex,
        Geometry;

    }
}

