/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderKey
extends AssetKey<Shader> {
    protected String fragName;
    protected DefineList defines;
    protected String vertLanguage;
    protected String fragLanguage;
    protected int cachedHashedCode = 0;
    protected boolean usesShaderNodes = false;

    public ShaderKey() {
    }

    public ShaderKey(String vertName, String fragName, DefineList defines, String vertLanguage, String fragLanguage) {
        super(vertName);
        this.fragName = fragName;
        this.defines = defines;
        this.vertLanguage = vertLanguage;
        this.fragLanguage = fragLanguage;
    }

    @Override
    public ShaderKey clone() {
        ShaderKey clone = (ShaderKey)super.clone();
        clone.cachedHashedCode = 0;
        clone.defines = this.defines.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "V=" + this.name + " F=" + this.fragName + (this.defines != null ? this.defines : "");
    }

    @Override
    public boolean equals(Object obj) {
        ShaderKey other = (ShaderKey)obj;
        if (this.name.equals(other.name) && this.fragName.equals(other.fragName)) {
            if (this.defines != null && other.defines != null) {
                return this.defines.equals(other.defines);
            }
            return this.defines == null && other.defines == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashedCode == 0) {
            int hash = 7;
            hash = 41 * hash + this.name.hashCode();
            hash = 41 * hash + this.fragName.hashCode();
            this.cachedHashedCode = hash = 41 * hash + (this.defines != null ? this.defines.hashCode() : 0);
        }
        return this.cachedHashedCode;
    }

    public DefineList getDefines() {
        return this.defines;
    }

    public String getVertName() {
        return this.name;
    }

    public String getFragName() {
        return this.fragName;
    }

    @Deprecated
    public String getLanguage() {
        return this.vertLanguage;
    }

    public String getVertexShaderLanguage() {
        return this.vertLanguage;
    }

    public String getFragmentShaderLanguage() {
        return this.fragLanguage;
    }

    public boolean isUsesShaderNodes() {
        return this.usesShaderNodes;
    }

    public void setUsesShaderNodes(boolean usesShaderNodes) {
        this.usesShaderNodes = usesShaderNodes;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.fragName, "fragment_name", null);
        oc.write(this.vertLanguage, "language", null);
        oc.write(this.fragLanguage, "frag_language", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.fragName = ic.readString("fragment_name", null);
        this.vertLanguage = ic.readString("language", null);
        this.fragLanguage = ic.readString("frag_language", null);
    }
}

