/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.ShaderVariable;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Uniform
extends ShaderVariable {
    private static final Integer ZERO_INT = 0;
    private static final Float ZERO_FLT = Float.valueOf(0.0f);
    private static final FloatBuffer ZERO_BUF = BufferUtils.createFloatBuffer(16);
    protected Object value = null;
    protected FloatBuffer multiData = null;
    protected VarType varType;
    protected UniformBinding binding;
    protected boolean setByCurrentMaterial = false;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Uniform[name=");
        sb.append(this.name);
        if (this.varType != null) {
            sb.append(", type=");
            sb.append((Object)this.varType);
            sb.append(", value=");
            sb.append(this.value);
        } else {
            sb.append(", value=<not set>");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setBinding(UniformBinding binding) {
        this.binding = binding;
    }

    public UniformBinding getBinding() {
        return this.binding;
    }

    public VarType getVarType() {
        return this.varType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSetByCurrentMaterial() {
        return this.setByCurrentMaterial;
    }

    public void clearSetByCurrentMaterial() {
        this.setByCurrentMaterial = false;
    }

    private static void setVector4(Vector4f vec, Object value) {
        if (value instanceof ColorRGBA) {
            ColorRGBA color = (ColorRGBA)value;
            vec.set(color.r, color.g, color.b, color.a);
        } else if (value instanceof Quaternion) {
            Quaternion quat = (Quaternion)value;
            vec.set(quat.getX(), quat.getY(), quat.getZ(), quat.getW());
        } else if (value instanceof Vector4f) {
            Vector4f vec4 = (Vector4f)value;
            vec.set(vec4);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void clearValue() {
        this.updateNeeded = true;
        if (this.multiData != null) {
            this.multiData.clear();
            while (this.multiData.remaining() > 0) {
                ZERO_BUF.clear();
                ZERO_BUF.limit(Math.min(this.multiData.remaining(), 16));
                this.multiData.put(ZERO_BUF);
            }
            this.multiData.clear();
            return;
        }
        if (this.varType == null) {
            return;
        }
        switch (this.varType) {
            case Int: {
                this.value = ZERO_INT;
                break;
            }
            case Boolean: {
                this.value = Boolean.FALSE;
                break;
            }
            case Float: {
                this.value = ZERO_FLT;
                break;
            }
            case Vector2: {
                this.value = Vector2f.ZERO;
                break;
            }
            case Vector3: {
                this.value = Vector3f.ZERO;
                break;
            }
            case Vector4: {
                this.value = Vector4f.ZERO;
                break;
            }
        }
    }

    public void setValue(VarType type, Object value) {
        if (this.location == -1) {
            return;
        }
        if (this.varType != null && this.varType != type) {
            throw new IllegalArgumentException("Expected a " + this.varType.name() + " value!");
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.setByCurrentMaterial = true;
        switch (type) {
            case Matrix3: {
                Matrix3f m3 = (Matrix3f)value;
                if (this.multiData == null) {
                    this.multiData = BufferUtils.createFloatBuffer(9);
                }
                m3.fillFloatBuffer(this.multiData, true);
                this.multiData.clear();
                break;
            }
            case Matrix4: {
                Matrix4f m4 = (Matrix4f)value;
                if (this.multiData == null) {
                    this.multiData = BufferUtils.createFloatBuffer(16);
                }
                m4.fillFloatBuffer(this.multiData, true);
                this.multiData.clear();
                break;
            }
            case IntArray: {
                int[] ia = (int[])value;
                this.value = this.value == null ? BufferUtils.createIntBuffer(ia) : BufferUtils.ensureLargeEnough((IntBuffer)this.value, ia.length);
                ((IntBuffer)this.value).clear();
                break;
            }
            case FloatArray: {
                float[] fa = (float[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(fa) : BufferUtils.ensureLargeEnough(this.multiData, fa.length);
                this.multiData.put(fa);
                this.multiData.clear();
                break;
            }
            case Vector2Array: {
                Vector2f[] v2a = (Vector2f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v2a) : BufferUtils.ensureLargeEnough(this.multiData, v2a.length * 2);
                for (int i = 0; i < v2a.length; ++i) {
                    BufferUtils.setInBuffer(v2a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Vector3Array: {
                Vector3f[] v3a = (Vector3f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v3a) : BufferUtils.ensureLargeEnough(this.multiData, v3a.length * 3);
                for (int i = 0; i < v3a.length; ++i) {
                    BufferUtils.setInBuffer(v3a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Vector4Array: {
                Vector4f[] v4a = (Vector4f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v4a) : BufferUtils.ensureLargeEnough(this.multiData, v4a.length * 4);
                for (int i = 0; i < v4a.length; ++i) {
                    BufferUtils.setInBuffer(v4a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Matrix3Array: {
                Matrix3f[] m3a = (Matrix3f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(m3a.length * 9) : BufferUtils.ensureLargeEnough(this.multiData, m3a.length * 9);
                for (int i = 0; i < m3a.length; ++i) {
                    m3a[i].fillFloatBuffer(this.multiData, true);
                }
                this.multiData.clear();
                break;
            }
            case Matrix4Array: {
                Matrix4f[] m4a = (Matrix4f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(m4a.length * 16) : BufferUtils.ensureLargeEnough(this.multiData, m4a.length * 16);
                for (int i = 0; i < m4a.length; ++i) {
                    m4a[i].fillFloatBuffer(this.multiData, true);
                }
                this.multiData.clear();
                break;
            }
            case Int: 
            case Boolean: 
            case Float: {
                if (this.value != null && this.value.equals(value)) {
                    return;
                }
                this.value = value;
                break;
            }
            default: {
                this.value = value;
            }
        }
        if (this.multiData != null) {
            this.value = this.multiData;
        }
        this.varType = type;
        this.updateNeeded = true;
    }

    public void setVector4Length(int length) {
        if (this.location == -1) {
            return;
        }
        FloatBuffer fb = (FloatBuffer)this.value;
        if (fb == null || fb.capacity() < length * 4) {
            this.value = BufferUtils.createFloatBuffer(length * 4);
        }
        this.varType = VarType.Vector4Array;
        this.updateNeeded = true;
        this.setByCurrentMaterial = true;
    }

    public void setVector4InArray(float x, float y, float z, float w, int index) {
        if (this.location == -1) {
            return;
        }
        if (this.varType != null && this.varType != VarType.Vector4Array) {
            throw new IllegalArgumentException("Expected a " + this.varType.name() + " value!");
        }
        FloatBuffer fb = (FloatBuffer)this.value;
        fb.position(index * 4);
        fb.put(x).put(y).put(z).put(w);
        fb.rewind();
        this.updateNeeded = true;
        this.setByCurrentMaterial = true;
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public void clearUpdateNeeded() {
        this.updateNeeded = false;
    }

    public void reset() {
        this.setByCurrentMaterial = false;
        this.location = -2;
        this.updateNeeded = true;
    }
}

