/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.ShaderNodeVariable;
import java.io.IOException;

public class VariableMapping
implements Savable {
    private ShaderNodeVariable leftVariable;
    private ShaderNodeVariable rightVariable;
    private String condition;
    private String leftSwizzling = "";
    private String rightSwizzling = "";

    public VariableMapping() {
    }

    public VariableMapping(ShaderNodeVariable leftVariable, String leftSwizzling, ShaderNodeVariable rightVariable, String rightSwizzling, String condition) {
        this.leftVariable = leftVariable;
        this.rightVariable = rightVariable;
        this.condition = condition;
        this.leftSwizzling = leftSwizzling;
        this.rightSwizzling = rightSwizzling;
    }

    public ShaderNodeVariable getLeftVariable() {
        return this.leftVariable;
    }

    public void setLeftVariable(ShaderNodeVariable leftVariable) {
        this.leftVariable = leftVariable;
    }

    public ShaderNodeVariable getRightVariable() {
        return this.rightVariable;
    }

    public void setRightVariable(ShaderNodeVariable rightVariable) {
        this.rightVariable = rightVariable;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getLeftSwizzling() {
        return this.leftSwizzling;
    }

    public void setLeftSwizzling(String leftSwizzling) {
        this.leftSwizzling = leftSwizzling;
    }

    public String getRightSwizzling() {
        return this.rightSwizzling;
    }

    public void setRightSwizzling(String rightSwizzling) {
        this.rightSwizzling = rightSwizzling;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.leftVariable, "leftVariable", null);
        oc.write(this.rightVariable, "rightVariable", null);
        oc.write(this.condition, "condition", "");
        oc.write(this.leftSwizzling, "leftSwizzling", "");
        oc.write(this.rightSwizzling, "rightSwizzling", "");
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.leftVariable = (ShaderNodeVariable)ic.readSavable("leftVariable", null);
        this.rightVariable = (ShaderNodeVariable)ic.readSavable("rightVariable", null);
        this.condition = ic.readString("condition", "");
        this.leftSwizzling = ic.readString("leftSwizzling", "");
        this.rightSwizzling = ic.readString("rightSwizzling", "");
    }

    public String toString() {
        return "\n{" + this.leftVariable.toString() + (this.leftSwizzling.length() > 0 ? "." + this.leftSwizzling : "") + " = " + this.rightVariable.getType() + " " + this.rightVariable.getNameSpace() + "." + this.rightVariable.getName() + (this.rightSwizzling.length() > 0 ? "." + this.rightSwizzling : "") + " : " + this.condition + "}";
    }
}

