/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector4f;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.shadow.AbstractShadowRenderer;
import com.jme3.shadow.CompareMode;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.texture.FrameBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShadowFilter<T extends AbstractShadowRenderer>
extends Filter {
    protected T shadowRenderer;
    protected ViewPort viewPort;
    Vector4f tmpv = new Vector4f();

    protected AbstractShadowFilter(AssetManager manager, int shadowMapSize, T shadowRenderer) {
        super("Post Shadow");
        this.material = new Material(manager, "Common/MatDefs/Shadow/PostShadowFilter.j3md");
        this.shadowRenderer = shadowRenderer;
        ((AbstractShadowRenderer)this.shadowRenderer).setPostShadowMaterial(this.material);
    }

    @Override
    protected Material getMaterial() {
        return this.material;
    }

    @Override
    protected boolean isRequiresDepthTexture() {
        return true;
    }

    public Material getShadowMaterial() {
        return this.material;
    }

    @Override
    protected void preFrame(float tpf) {
        ((AbstractShadowRenderer)this.shadowRenderer).preFrame(tpf);
        this.material.setMatrix4("ViewProjectionMatrixInverse", this.viewPort.getCamera().getViewProjectionMatrix().invert());
        Matrix4f m = this.viewPort.getCamera().getViewProjectionMatrix();
        this.material.setVector4("ViewProjectionMatrixRow2", this.tmpv.set(m.m20, m.m21, m.m22, m.m23));
    }

    @Override
    protected void postQueue(RenderQueue queue) {
        ((AbstractShadowRenderer)this.shadowRenderer).postQueue(queue);
        if (((AbstractShadowRenderer)this.shadowRenderer).skipPostPass) {
            this.material.setTexture("ShadowMap0", null);
        }
    }

    @Override
    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
        if (!((AbstractShadowRenderer)this.shadowRenderer).skipPostPass) {
            ((AbstractShadowRenderer)this.shadowRenderer).setPostShadowParams();
        }
    }

    @Override
    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        ((AbstractShadowRenderer)this.shadowRenderer).needsfallBackMaterial = true;
        ((AbstractShadowRenderer)this.shadowRenderer).initialize(renderManager, vp);
        this.viewPort = vp;
    }

    public float getShadowIntensity() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getShadowIntensity();
    }

    public final void setShadowIntensity(float shadowIntensity) {
        ((AbstractShadowRenderer)this.shadowRenderer).setShadowIntensity(shadowIntensity);
    }

    public int getEdgesThickness() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getEdgesThickness();
    }

    public void setEdgesThickness(int edgesThickness) {
        ((AbstractShadowRenderer)this.shadowRenderer).setEdgesThickness(edgesThickness);
    }

    public boolean isFlushQueues() {
        return ((AbstractShadowRenderer)this.shadowRenderer).isFlushQueues();
    }

    public void setFlushQueues(boolean flushQueues) {
        ((AbstractShadowRenderer)this.shadowRenderer).setFlushQueues(flushQueues);
    }

    public final void setShadowCompareMode(CompareMode compareMode) {
        ((AbstractShadowRenderer)this.shadowRenderer).setShadowCompareMode(compareMode);
    }

    public CompareMode getShadowCompareMode() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getShadowCompareMode();
    }

    public final void setEdgeFilteringMode(EdgeFilteringMode filterMode) {
        ((AbstractShadowRenderer)this.shadowRenderer).setEdgeFilteringMode(filterMode);
    }

    public EdgeFilteringMode getEdgeFilteringMode() {
        return ((AbstractShadowRenderer)this.shadowRenderer).getEdgeFilteringMode();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
    }
}

