/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.SpotLight;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.scene.Node;
import com.jme3.shadow.AbstractShadowRenderer;
import com.jme3.shadow.ShadowUtil;
import java.io.IOException;

public class SpotLightShadowRenderer
extends AbstractShadowRenderer {
    protected float zFarOverride = 0.0f;
    protected Camera shadowCam;
    protected SpotLight light;
    protected Vector3f[] points = new Vector3f[8];
    protected Vector2f fadeInfo;
    protected float fadeLength;

    public SpotLightShadowRenderer() {
    }

    public SpotLightShadowRenderer(AssetManager assetManager, int shadowMapSize) {
        super(assetManager, shadowMapSize, 1);
        this.init(shadowMapSize);
    }

    private void init(int shadowMapSize) {
        this.shadowCam = new Camera(shadowMapSize, shadowMapSize);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    public SpotLight getLight() {
        return this.light;
    }

    public void setLight(SpotLight light) {
        this.light = light;
    }

    protected void updateShadowCams(Camera viewCam) {
        float zFar = this.zFarOverride;
        if (zFar == 0.0f) {
            zFar = viewCam.getFrustumFar();
        }
        float frustumNear = Math.max(viewCam.getFrustumNear(), 0.001f);
        ShadowUtil.updateFrustumPoints(viewCam, frustumNear, zFar, 1.0f, this.points);
        this.shadowCam.setFrustumPerspective(this.light.getSpotOuterAngle() * 57.295776f * 2.0f, 1.0f, 1.0f, this.light.getSpotRange());
        this.shadowCam.getRotation().lookAt(this.light.getDirection(), this.shadowCam.getUp());
        this.shadowCam.setLocation(this.light.getPosition());
        this.shadowCam.update();
        this.shadowCam.updateViewProjection();
    }

    protected GeometryList getOccludersToRender(int shadowMapIndex, GeometryList sceneOccluders, GeometryList sceneReceivers, GeometryList shadowMapOccluders) {
        ShadowUtil.getGeometriesInCamFrustum(sceneOccluders, this.shadowCam, shadowMapOccluders);
        return shadowMapOccluders;
    }

    GeometryList getReceivers(GeometryList sceneReceivers, GeometryList lightReceivers) {
        lightReceivers.clear();
        ShadowUtil.getGeometriesInCamFrustum(sceneReceivers, this.shadowCam, lightReceivers);
        return lightReceivers;
    }

    protected Camera getShadowCam(int shadowMapIndex) {
        return this.shadowCam;
    }

    protected void doDisplayFrustumDebug(int shadowMapIndex) {
        Vector3f[] points2 = (Vector3f[])this.points.clone();
        ((Node)this.viewPort.getScenes().get(0)).attachChild(this.createFrustum(this.points, shadowMapIndex));
        ShadowUtil.updateFrustumPoints2(this.shadowCam, points2);
        ((Node)this.viewPort.getScenes().get(0)).attachChild(this.createFrustum(points2, shadowMapIndex));
    }

    protected void setMaterialParameters(Material material) {
    }

    public float getShadowZExtend() {
        return this.zFarOverride;
    }

    public void setShadowZExtend(float zFar) {
        if (this.fadeInfo != null) {
            this.fadeInfo.set(zFar - this.fadeLength, 1.0f / this.fadeLength);
        }
        this.zFarOverride = zFar;
    }

    public void setShadowZFadeLength(float length) {
        if (length == 0.0f) {
            this.fadeInfo = null;
            this.fadeLength = 0.0f;
            this.postshadowMat.clearParam("FadeInfo");
        } else {
            this.fadeInfo = this.zFarOverride == 0.0f ? new Vector2f(0.0f, 0.0f) : new Vector2f(this.zFarOverride - length, 1.0f / length);
            this.fadeLength = length;
            this.postshadowMat.setVector2("FadeInfo", this.fadeInfo);
        }
    }

    public float getShadowZFadeLength() {
        if (this.fadeInfo != null) {
            return this.zFarOverride - this.fadeInfo.x;
        }
        return 0.0f;
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.zFarOverride = ic.readInt("zFarOverride", 0);
        this.light = (SpotLight)ic.readSavable("light", null);
        this.fadeInfo = (Vector2f)ic.readSavable("fadeInfo", null);
        this.fadeLength = ic.readFloat("fadeLength", 0.0f);
        this.init((int)this.shadowMapSize);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.zFarOverride, "zFarOverride", 0.0f);
        oc.write(this.light, "light", null);
        oc.write(this.fadeInfo, "fadeInfo", null);
        oc.write(this.fadeLength, "fadeLength", 0.0f);
    }
}

