/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GeoMap
implements Savable {
    protected float[] hdata;
    protected int width;
    protected int height;
    protected int maxval;

    public GeoMap() {
    }

    @Deprecated
    public GeoMap(FloatBuffer heightData, int width, int height, int maxval) {
        this.hdata = new float[heightData.limit()];
        heightData.get(this.hdata);
        this.width = width;
        this.height = height;
        this.maxval = maxval;
    }

    public GeoMap(float[] heightData, int width, int height, int maxval) {
        this.hdata = heightData;
        this.width = width;
        this.height = height;
        this.maxval = maxval;
    }

    @Deprecated
    public FloatBuffer getHeightData() {
        if (!this.isLoaded()) {
            return null;
        }
        return BufferUtils.createFloatBuffer(this.hdata);
    }

    public float[] getHeightArray() {
        if (!this.isLoaded()) {
            return null;
        }
        return this.hdata;
    }

    public int getMaximumValue() {
        return this.maxval;
    }

    public float getValue(int x, int y) {
        return this.hdata[y * this.width + x];
    }

    public float getValue(int i) {
        return this.hdata[i];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isLoaded() {
        return true;
    }

    public FloatBuffer writeNormalArray(FloatBuffer store, Vector3f scale) {
        if (store != null) {
            if (store.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        store.rewind();
        Vector3f oppositePoint = new Vector3f();
        Vector3f adjacentPoint = new Vector3f();
        Vector3f rootPoint = new Vector3f();
        Vector3f tempNorm = new Vector3f();
        int normalIndex = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                rootPoint.set(x, this.getValue(x, y), y);
                if (y == this.getHeight() - 1) {
                    if (x == this.getWidth() - 1) {
                        adjacentPoint.set(x, this.getValue(x, y - 1), y - 1);
                        oppositePoint.set(x - 1, this.getValue(x - 1, y), y);
                    } else {
                        adjacentPoint.set(x + 1, this.getValue(x + 1, y), y);
                        oppositePoint.set(x, this.getValue(x, y - 1), y - 1);
                    }
                } else if (x == this.getWidth() - 1) {
                    adjacentPoint.set(x - 1, this.getValue(x - 1, y), y);
                    oppositePoint.set(x, this.getValue(x, y + 1), y + 1);
                } else {
                    adjacentPoint.set(x, this.getValue(x, y + 1), y + 1);
                    oppositePoint.set(x + 1, this.getValue(x + 1, y), y);
                }
                tempNorm.set(adjacentPoint).subtractLocal(rootPoint).crossLocal(oppositePoint.subtractLocal(rootPoint));
                tempNorm.multLocal(scale).normalizeLocal();
                BufferUtils.setInBuffer(tempNorm, store, normalIndex);
                ++normalIndex;
            }
        }
        return store;
    }

    public FloatBuffer writeVertexArray(FloatBuffer store, Vector3f scale, boolean center) {
        if (store != null) {
            if (store.remaining() < this.width * this.height * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.width * this.height * 3);
        }
        assert (this.hdata.length == this.height * this.width);
        Vector3f offset = new Vector3f((float)(-this.getWidth()) * scale.x * 0.5f, 0.0f, (float)(-this.getWidth()) * scale.z * 0.5f);
        if (!center) {
            offset.zero();
        }
        int i = 0;
        for (int z = 0; z < this.height; ++z) {
            for (int x = 0; x < this.width; ++x) {
                store.put((float)x * scale.x + offset.x);
                store.put(this.hdata[i++] * scale.y);
                store.put((float)z * scale.z + offset.z);
            }
        }
        return store;
    }

    public Vector2f getUV(int x, int y, Vector2f store) {
        store.set((float)x / (float)this.getWidth(), (float)y / (float)this.getHeight());
        return store;
    }

    public Vector2f getUV(int i, Vector2f store) {
        return store;
    }

    public FloatBuffer writeTexCoordArray(FloatBuffer store, Vector2f offset, Vector2f scale) {
        if (store != null) {
            if (store.remaining() < this.getWidth() * this.getHeight() * 2) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 2);
        }
        if (offset == null) {
            offset = new Vector2f();
        }
        Vector2f tcStore = new Vector2f();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.getUV(x, y, tcStore);
                store.put(offset.x + tcStore.x * scale.x);
                store.put(offset.y + tcStore.y * scale.y);
            }
        }
        return store;
    }

    public IntBuffer writeIndexArray(IntBuffer store) {
        int faceN = (this.getWidth() - 1) * (this.getHeight() - 1) * 2;
        if (store != null) {
            if (store.remaining() < faceN * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createIntBuffer(faceN * 3);
        }
        int i = 0;
        for (int z = 0; z < this.getHeight() - 1; ++z) {
            for (int x = 0; x < this.getWidth() - 1; ++x) {
                store.put(i).put(i + this.getWidth()).put(i + this.getWidth() + 1);
                store.put(i + this.getWidth() + 1).put(i + 1).put(i);
                ++i;
                if (x != this.getWidth() - 2) continue;
                ++i;
            }
        }
        store.flip();
        return store;
    }

    public Mesh createMesh(Vector3f scale, Vector2f tcScale, boolean center) {
        FloatBuffer pb = this.writeVertexArray(null, scale, center);
        FloatBuffer tb = this.writeTexCoordArray(null, Vector2f.ZERO, tcScale);
        FloatBuffer nb = this.writeNormalArray(null, scale);
        IntBuffer ib = this.writeIndexArray(null);
        Mesh m = new Mesh();
        m.setBuffer(VertexBuffer.Type.Position, 3, pb);
        m.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        m.setBuffer(VertexBuffer.Type.TexCoord, 2, tb);
        m.setBuffer(VertexBuffer.Type.Index, 3, ib);
        m.setStatic();
        m.updateBound();
        return m;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.hdata, "hdataarray", (float[])null);
        oc.write(this.width, "width", 0);
        oc.write(this.height, "height", 0);
        oc.write(this.maxval, "maxval", 0);
    }

    public void read(JmeImporter im) throws IOException {
        FloatBuffer buf;
        InputCapsule ic = im.getCapsule(this);
        this.hdata = ic.readFloatArray("hdataarray", null);
        if (this.hdata == null && (buf = ic.readFloatBuffer("hdata", null)) != null) {
            this.hdata = new float[buf.limit()];
            buf.get(this.hdata);
        }
        this.width = ic.readInt("width", 0);
        this.height = ic.readInt("height", 0);
        this.maxval = ic.readInt("maxval", 0);
    }
}

