/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.FastMath;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.terrain.GeoMap;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class LODGeomap
extends GeoMap {
    public LODGeomap() {
    }

    @Deprecated
    public LODGeomap(int size, FloatBuffer heightMap) {
        super(heightMap, size, size, 1);
    }

    public LODGeomap(int size, float[] heightMap) {
        super(heightMap, size, size, 1);
    }

    public Mesh createMesh(Vector3f scale, Vector2f tcScale, Vector2f tcOffset, float offsetAmount, int totalSize, boolean center) {
        return this.createMesh(scale, tcScale, tcOffset, offsetAmount, totalSize, center, 1, false, false, false, false);
    }

    public Mesh createMesh(Vector3f scale, Vector2f tcScale, Vector2f tcOffset, float offsetAmount, int totalSize, boolean center, int lod, boolean rightLod, boolean topLod, boolean leftLod, boolean bottomLod) {
        FloatBuffer pb = this.writeVertexArray(null, scale, center);
        FloatBuffer texb = this.writeTexCoordArray(null, tcOffset, tcScale, offsetAmount, totalSize);
        FloatBuffer nb = this.writeNormalArray(null, scale);
        IndexBuffer idxB = this.writeIndexArrayLodDiff(lod, rightLod, topLod, leftLod, bottomLod, totalSize);
        Buffer ib = idxB.getBuffer() instanceof IntBuffer ? (IntBuffer)idxB.getBuffer() : (ShortBuffer)idxB.getBuffer();
        FloatBuffer bb = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        FloatBuffer tanb = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        this.writeTangentArray(nb, tanb, bb, texb, scale);
        Mesh m = new Mesh();
        m.setMode(Mesh.Mode.TriangleStrip);
        m.setBuffer(VertexBuffer.Type.Position, 3, pb);
        m.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        m.setBuffer(VertexBuffer.Type.Tangent, 3, tanb);
        m.setBuffer(VertexBuffer.Type.Binormal, 3, bb);
        m.setBuffer(VertexBuffer.Type.TexCoord, 2, texb);
        if (ib instanceof IntBuffer) {
            m.setBuffer(VertexBuffer.Type.Index, 3, (IntBuffer)ib);
        } else if (ib instanceof ShortBuffer) {
            m.setBuffer(VertexBuffer.Type.Index, 3, (ShortBuffer)ib);
        }
        m.setStatic();
        m.updateBound();
        return m;
    }

    public FloatBuffer writeTexCoordArray(FloatBuffer store, Vector2f offset, Vector2f scale, float offsetAmount, int totalSize) {
        if (store != null) {
            if (store.remaining() < this.getWidth() * this.getHeight() * 2) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 2);
        }
        if (offset == null) {
            offset = new Vector2f();
        }
        Vector2f tcStore = new Vector2f();
        for (int y = this.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.getUV(x, y, tcStore, offset, offsetAmount, totalSize);
                float tx = tcStore.x * scale.x;
                float ty = tcStore.y * scale.y;
                store.put(tx);
                store.put(ty);
            }
        }
        return store;
    }

    public Vector2f getUV(int x, int y, Vector2f store, Vector2f offset, float offsetAmount, int totalSize) {
        float offsetX = offset.x + offsetAmount * 1.0f;
        float offsetY = -offset.y + offsetAmount * 1.0f;
        store.set(((float)x + offsetX) / (float)(totalSize - 1), ((float)y + offsetY) / (float)(totalSize - 1));
        return store;
    }

    public IndexBuffer writeIndexArrayLodDiff(int lod, boolean rightLod, boolean topLod, boolean leftLod, boolean bottomLod, int totalSize) {
        int col;
        int row;
        int idx;
        int numIndexes = this.calculateNumIndexesLodDiff(lod);
        IndexBuffer ib = IndexBuffer.createIndexBuffer(numIndexes, numIndexes);
        VerboseBuffer buffer = new VerboseBuffer(ib);
        for (int r = lod; r < this.getWidth() - 2 * lod; r += lod) {
            int rowIdx = r * this.getWidth();
            int nextRowIdx = (r + 1 * lod) * this.getWidth();
            for (int c = lod; c < this.getWidth() - 1 * lod; c += lod) {
                int idx2 = rowIdx + c;
                buffer.put(idx2);
                idx2 = nextRowIdx + c;
                buffer.put(idx2);
            }
            if (r >= this.getWidth() - 3 * lod) continue;
            idx = nextRowIdx + this.getWidth() - 1 * lod - 1;
            buffer.put(idx);
            idx = nextRowIdx + 1 * lod;
            buffer.put(idx);
        }
        int br = this.getWidth() * (this.getWidth() - lod) - 1 - lod;
        buffer.put(br);
        int corner = this.getWidth() * this.getWidth() - 1;
        buffer.put(corner);
        if (rightLod) {
            for (row = this.getWidth() - lod; row >= 1 + lod; row -= 2 * lod) {
                idx = row * this.getWidth() - 1 - lod;
                buffer.put(idx);
                idx = (row - lod) * this.getWidth() - 1;
                buffer.put(idx);
                if (row <= lod + 1) continue;
                idx = (row - lod) * this.getWidth() - 1 - lod;
                buffer.put(idx);
                idx = (row - lod) * this.getWidth() - 1;
                buffer.put(idx);
            }
        } else {
            buffer.put(corner);
            for (row = this.getWidth() - lod; row > lod; row -= lod) {
                idx = row * this.getWidth() - 1;
                buffer.put(idx);
                buffer.put(idx - lod);
            }
        }
        buffer.put(this.getWidth() - 1);
        if (topLod) {
            if (rightLod) {
                buffer.put(this.getWidth() - 1);
            }
            for (col = this.getWidth() - 1; col >= lod; col -= 2 * lod) {
                idx = lod * this.getWidth() + col - lod;
                buffer.put(idx);
                idx = col - 2 * lod;
                buffer.put(idx);
                if (col <= lod * 2) continue;
                idx = lod * this.getWidth() + col - 2 * lod;
                buffer.put(idx);
                idx = col - 2 * lod;
                buffer.put(idx);
            }
        } else {
            if (rightLod) {
                buffer.put(this.getWidth() - 1);
            }
            for (col = this.getWidth() - 1 - lod; col > 0; col -= lod) {
                idx = col + lod * this.getWidth();
                buffer.put(idx);
                idx = col;
                buffer.put(idx);
            }
            buffer.put(0);
        }
        buffer.put(0);
        if (leftLod) {
            if (topLod) {
                buffer.put(0);
            }
            for (row = 0; row < this.getWidth() - lod; row += 2 * lod) {
                idx = (row + lod) * this.getWidth() + lod;
                buffer.put(idx);
                idx = (row + 2 * lod) * this.getWidth();
                buffer.put(idx);
                if (row >= this.getWidth() - 1 - 2 * lod) continue;
                idx = (row + 2 * lod) * this.getWidth() + lod;
                buffer.put(idx);
                idx = (row + 2 * lod) * this.getWidth();
                buffer.put(idx);
            }
        } else {
            if (!topLod) {
                buffer.put(0);
            }
            for (row = lod; row < this.getWidth() - lod; row += lod) {
                idx = row * this.getWidth();
                buffer.put(idx);
                idx = row * this.getWidth() + lod;
                buffer.put(idx);
            }
        }
        buffer.put(this.getWidth() * (this.getWidth() - 1));
        if (bottomLod) {
            if (leftLod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            for (col = 0; col < this.getWidth() - lod; col += 2 * lod) {
                idx = this.getWidth() * (this.getWidth() - 1 - lod) + col + lod;
                buffer.put(idx);
                idx = this.getWidth() * (this.getWidth() - 1) + col + 2 * lod;
                buffer.put(idx);
                if (col >= this.getWidth() - 1 - 2 * lod) continue;
                idx = this.getWidth() * (this.getWidth() - 1 - lod) + col + 2 * lod;
                buffer.put(idx);
                idx = this.getWidth() * (this.getWidth() - 1) + col + 2 * lod;
                buffer.put(idx);
            }
        } else {
            if (leftLod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            for (col = lod; col < this.getWidth() - lod; col += lod) {
                idx = this.getWidth() * (this.getWidth() - 1 - lod) + col;
                buffer.put(idx);
                idx = this.getWidth() * (this.getWidth() - 1) + col;
                buffer.put(idx);
            }
        }
        buffer.put(this.getWidth() * this.getWidth() - 1);
        for (int i = buffer.getCount(); i < numIndexes; ++i) {
            buffer.put(this.getWidth() * this.getWidth() - 1);
        }
        return buffer.delegate;
    }

    public IndexBuffer writeIndexArrayLodVariable(int lod, int rightLod, int topLod, int leftLod, int bottomLod, int totalSize) {
        int col;
        int row;
        int idxB;
        int j;
        int i;
        int lodDiff;
        int it;
        int idx;
        int idx2;
        int numIndexes = this.calculateNumIndexesLodDiff(lod);
        IndexBuffer ib = IndexBuffer.createIndexBuffer(numIndexes, numIndexes);
        VerboseBuffer buffer = new VerboseBuffer(ib);
        for (int r = lod; r < this.getWidth() - 2 * lod; r += lod) {
            int rowIdx = r * this.getWidth();
            int nextRowIdx = (r + 1 * lod) * this.getWidth();
            for (int c = lod; c < this.getWidth() - 1 * lod; c += lod) {
                int idx3 = rowIdx + c;
                buffer.put(idx3);
                idx3 = nextRowIdx + c;
                buffer.put(idx3);
            }
            if (r >= this.getWidth() - 3 * lod) continue;
            idx2 = nextRowIdx + this.getWidth() - 1 * lod - 1;
            buffer.put(idx2);
            idx2 = nextRowIdx + 1 * lod;
            buffer.put(idx2);
        }
        int br = this.getWidth() * (this.getWidth() - lod) - 1 - lod;
        buffer.put(br);
        int corner = this.getWidth() * this.getWidth() - 1;
        buffer.put(corner);
        if (rightLod > lod) {
            idx = corner;
            it = (this.getWidth() - 1) / rightLod;
            lodDiff = rightLod / lod;
            for (i = it; i > 0; --i) {
                idx = this.getWidth() * (i * rightLod + 1) - 1;
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = idx - this.getWidth() * (j * lod) - lod;
                    if (j == lodDiff && i == 1) {
                        buffer.put(this.getWidth() - 1);
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idxB + lod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
            buffer.put(this.getWidth() * (lod + 1) - lod - 1);
            buffer.put(this.getWidth() - 1);
        } else {
            buffer.put(corner);
            for (row = this.getWidth() - lod; row > lod; row -= lod) {
                idx2 = row * this.getWidth() - 1;
                buffer.put(idx2);
                buffer.put(idx2 - lod);
            }
            buffer.put(this.getWidth() - 1);
        }
        if (topLod > lod) {
            if (rightLod > lod) {
                buffer.put(this.getWidth() - 1);
                buffer.put(this.getWidth() * lod - 1);
                buffer.put(this.getWidth() - 1);
            }
            idx = this.getWidth() - 1;
            it = (this.getWidth() - 1) / topLod;
            lodDiff = topLod / lod;
            for (i = it; i > 0; --i) {
                idx = i * topLod;
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = lod * this.getWidth() + i * topLod - j * lod;
                    if (j == lodDiff && i == 1) {
                        buffer.put(0);
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idx - topLod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
        } else {
            if (rightLod > lod) {
                buffer.put(this.getWidth() - 1);
            }
            for (col = this.getWidth() - 1 - lod; col > 0; col -= lod) {
                idx2 = col + lod * this.getWidth();
                buffer.put(idx2);
                idx2 = col;
                buffer.put(idx2);
            }
            buffer.put(0);
        }
        buffer.put(0);
        if (leftLod > lod) {
            idx = 0;
            it = (this.getWidth() - 1) / leftLod;
            lodDiff = leftLod / lod;
            for (i = 0; i < it; ++i) {
                idx = this.getWidth() * (i * leftLod);
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = idx + this.getWidth() * (j * lod) + lod;
                    if (j == lodDiff && i == it - 1) {
                        buffer.put(this.getWidth() * this.getWidth() - this.getWidth());
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idxB - lod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
        } else {
            buffer.put(0);
            buffer.put(this.getWidth() * lod + lod);
            buffer.put(0);
            for (row = lod; row < this.getWidth() - lod; row += lod) {
                idx2 = row * this.getWidth();
                buffer.put(idx2);
                idx2 = row * this.getWidth() + lod;
                buffer.put(idx2);
            }
            buffer.put(this.getWidth() * (this.getWidth() - 1));
        }
        if (bottomLod > lod) {
            if (leftLod > lod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
                buffer.put(this.getWidth() * (this.getWidth() - lod));
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            idx = this.getWidth() * this.getWidth() - this.getWidth();
            it = (this.getWidth() - 1) / bottomLod;
            lodDiff = bottomLod / lod;
            for (i = 0; i < it; ++i) {
                idx = this.getWidth() * this.getWidth() - this.getWidth() + i * bottomLod;
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = idx - this.getWidth() * lod + j * lod;
                    if (j == lodDiff && i == it - 1) {
                        buffer.put(this.getWidth() * this.getWidth() - 1);
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idx + bottomLod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
        } else {
            if (leftLod > lod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
                buffer.put(this.getWidth() * this.getWidth() - this.getWidth() * lod + lod);
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            for (col = lod; col < this.getWidth() - lod; col += lod) {
                idx2 = this.getWidth() * (this.getWidth() - 1 - lod) + col;
                buffer.put(idx2);
                idx2 = this.getWidth() * (this.getWidth() - 1) + col;
                buffer.put(idx2);
            }
        }
        buffer.put(this.getWidth() * this.getWidth() - 1);
        for (int i2 = buffer.getCount(); i2 < numIndexes; ++i2) {
            buffer.put(this.getWidth() * this.getWidth() - 1);
        }
        return buffer.delegate;
    }

    private int calculateNumIndexesLodDiff(int lod) {
        if (lod == 0) {
            lod = 1;
        }
        int length = this.getWidth() - 1;
        int side = length / lod + 1 - 2;
        int num = side * side * 2;
        num -= 2 * side;
        int degenerates = 2 * (side - 2);
        num += degenerates;
        num += this.getWidth() / lod * 2 * 4;
        ++num;
        return num += 10;
    }

    public FloatBuffer[] writeTangentArray(FloatBuffer normalBuffer, FloatBuffer tangentStore, FloatBuffer binormalStore, FloatBuffer textureBuffer, Vector3f scale) {
        if (!this.isLoaded()) {
            throw new NullPointerException();
        }
        if (tangentStore != null) {
            if (tangentStore.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            tangentStore = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        tangentStore.rewind();
        if (binormalStore != null) {
            if (binormalStore.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            binormalStore = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        binormalStore.rewind();
        Vector3f normal = new Vector3f();
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        for (int r = 0; r < this.getHeight(); ++r) {
            for (int c = 0; c < this.getWidth(); ++c) {
                int idx = (r * this.getWidth() + c) * 3;
                normal.set(normalBuffer.get(idx), normalBuffer.get(idx + 1), normalBuffer.get(idx + 2));
                tangent.set(normal.cross(new Vector3f(0.0f, 0.0f, 1.0f)));
                binormal.set(new Vector3f(1.0f, 0.0f, 0.0f).cross(normal));
                BufferUtils.setInBuffer(tangent.normalizeLocal(), tangentStore, r * this.getWidth() + c);
                BufferUtils.setInBuffer(binormal.normalizeLocal(), binormalStore, r * this.getWidth() + c);
            }
        }
        return new FloatBuffer[]{tangentStore, binormalStore};
    }

    public static Vector3f calculateTangent(Vector3f[] v, Vector2f[] t, Vector3f tangent, Vector3f binormal) {
        Vector3f edge1 = new Vector3f();
        Vector3f edge2 = new Vector3f();
        Vector2f edge1uv = new Vector2f();
        Vector2f edge2uv = new Vector2f();
        t[2].subtract(t[0], edge2uv);
        t[1].subtract(t[0], edge1uv);
        float det = edge1uv.x * edge2uv.y;
        boolean normalize = true;
        if (Math.abs(det) < 1.0E-7f) {
            det = 1.0f;
            normalize = true;
        }
        v[1].subtract(v[0], edge1);
        v[2].subtract(v[0], edge2);
        tangent.set(edge1);
        tangent.normalizeLocal();
        binormal.set(edge2);
        binormal.normalizeLocal();
        float factor = 1.0f / det;
        tangent.x = edge2uv.y * edge1.x * factor;
        tangent.y = 0.0f;
        tangent.z = edge2uv.y * edge1.z * factor;
        if (normalize) {
            tangent.normalizeLocal();
        }
        binormal.x = 0.0f;
        binormal.y = edge1uv.x * edge2.y * factor;
        binormal.z = edge1uv.x * edge2.z * factor;
        if (normalize) {
            binormal.normalizeLocal();
        }
        return tangent;
    }

    public FloatBuffer writeNormalArray(FloatBuffer store, Vector3f scale) {
        if (!this.isLoaded()) {
            throw new NullPointerException();
        }
        if (store != null) {
            if (store.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        store.rewind();
        TempVars vars = TempVars.get();
        Vector3f rootPoint = vars.vect1;
        Vector3f rightPoint = vars.vect2;
        Vector3f leftPoint = vars.vect3;
        Vector3f topPoint = vars.vect4;
        Vector3f bottomPoint = vars.vect5;
        Vector3f tmp1 = vars.vect6;
        for (int r = 0; r < this.getHeight(); ++r) {
            for (int c = 0; c < this.getWidth(); ++c) {
                rootPoint.set(0.0f, this.getValue(c, r), 0.0f);
                Vector3f normal = vars.vect8;
                if (r == 0) {
                    if (c == 0) {
                        rightPoint.set(1.0f, this.getValue(c + 1, r), 0.0f);
                        bottomPoint.set(0.0f, this.getValue(c, r + 1), 1.0f);
                        this.getNormal(bottomPoint, rootPoint, rightPoint, scale, normal);
                    } else if (c == this.getWidth() - 1) {
                        leftPoint.set(-1.0f, this.getValue(c - 1, r), 0.0f);
                        bottomPoint.set(0.0f, this.getValue(c, r + 1), 1.0f);
                        this.getNormal(leftPoint, rootPoint, bottomPoint, scale, normal);
                    } else {
                        leftPoint.set(-1.0f, this.getValue(c - 1, r), 0.0f);
                        rightPoint.set(1.0f, this.getValue(c + 1, r), 0.0f);
                        bottomPoint.set(0.0f, this.getValue(c, r + 1), 1.0f);
                        normal.set(this.getNormal(leftPoint, rootPoint, bottomPoint, scale, tmp1));
                        normal.addLocal(this.getNormal(bottomPoint, rootPoint, rightPoint, scale, tmp1));
                    }
                } else if (r == this.getHeight() - 1) {
                    if (c == 0) {
                        topPoint.set(0.0f, this.getValue(c, r - 1), -1.0f);
                        rightPoint.set(1.0f, this.getValue(c + 1, r), 0.0f);
                        this.getNormal(rightPoint, rootPoint, topPoint, scale, normal);
                    } else if (c == this.getWidth() - 1) {
                        topPoint.set(0.0f, this.getValue(c, r - 1), -1.0f);
                        leftPoint.set(-1.0f, this.getValue(c - 1, r), 0.0f);
                        this.getNormal(topPoint, rootPoint, leftPoint, scale, normal);
                    } else {
                        topPoint.set(0.0f, this.getValue(c, r - 1), -1.0f);
                        leftPoint.set(-1.0f, this.getValue(c - 1, r), 0.0f);
                        rightPoint.set(1.0f, this.getValue(c + 1, r), 0.0f);
                        normal.set(this.getNormal(topPoint, rootPoint, leftPoint, scale, tmp1));
                        normal.addLocal(this.getNormal(rightPoint, rootPoint, topPoint, scale, tmp1));
                    }
                } else if (c == 0) {
                    topPoint.set(0.0f, this.getValue(c, r - 1), -1.0f);
                    rightPoint.set(1.0f, this.getValue(c + 1, r), 0.0f);
                    bottomPoint.set(0.0f, this.getValue(c, r + 1), 1.0f);
                    normal.set(this.getNormal(rightPoint, rootPoint, topPoint, scale, tmp1));
                    normal.addLocal(this.getNormal(bottomPoint, rootPoint, rightPoint, scale, tmp1));
                } else if (c == this.getWidth() - 1) {
                    topPoint.set(0.0f, this.getValue(c, r - 1), -1.0f);
                    leftPoint.set(-1.0f, this.getValue(c - 1, r), 0.0f);
                    bottomPoint.set(0.0f, this.getValue(c, r + 1), 1.0f);
                    normal.set(this.getNormal(topPoint, rootPoint, leftPoint, scale, tmp1));
                    normal.addLocal(this.getNormal(leftPoint, rootPoint, bottomPoint, scale, tmp1));
                } else {
                    topPoint.set(0.0f, this.getValue(c, r - 1), -1.0f);
                    leftPoint.set(-1.0f, this.getValue(c - 1, r), 0.0f);
                    rightPoint.set(1.0f, this.getValue(c + 1, r), 0.0f);
                    bottomPoint.set(0.0f, this.getValue(c, r + 1), 1.0f);
                    normal.set(this.getNormal(topPoint, rootPoint, leftPoint, scale, tmp1));
                    normal.addLocal(this.getNormal(leftPoint, rootPoint, bottomPoint, scale, tmp1));
                    normal.addLocal(this.getNormal(bottomPoint, rootPoint, rightPoint, scale, tmp1));
                    normal.addLocal(this.getNormal(rightPoint, rootPoint, topPoint, scale, tmp1));
                }
                normal.normalizeLocal();
                BufferUtils.setInBuffer(normal, store, r * this.getWidth() + c);
            }
        }
        vars.release();
        return store;
    }

    private Vector3f getNormal(Vector3f firstPoint, Vector3f rootPoint, Vector3f secondPoint, Vector3f scale, Vector3f store) {
        float x1 = firstPoint.x - rootPoint.x;
        float y1 = firstPoint.y - rootPoint.y;
        float z1 = firstPoint.z - rootPoint.z;
        float x2 = secondPoint.x - rootPoint.x;
        float y2 = secondPoint.y - rootPoint.y;
        float z2 = secondPoint.z - rootPoint.z;
        float x3 = (y1 *= scale.y) * (z2 *= scale.z) - (z1 *= scale.z) * (y2 *= scale.y);
        float y3 = z1 * (x2 *= scale.x) - (x1 *= scale.x) * z2;
        float z3 = x1 * y2 - y1 * x2;
        float inv = 1.0f / FastMath.sqrt(x3 * x3 + y3 * y3 + z3 * z3);
        store.x = x3 * inv;
        store.y = y3 * inv;
        store.z = z3 * inv;
        return store;
    }

    protected float getHeight(int x, int z, float xm, float zm) {
        int index = this.findClosestHeightIndex(x, z);
        if (index < 0) {
            return Float.NaN;
        }
        float h1 = this.hdata[index];
        float h2 = this.hdata[index + 1];
        float h3 = this.hdata[index + this.width];
        float h4 = this.hdata[index + this.width + 1];
        if (x == 0 && z == 0 || x == this.width - 2 && z == this.width - 2) {
            if (xm < zm) {
                return h1 + xm * (h4 - h3) + zm * (h3 - h1);
            }
            return h1 + xm * (h2 - h1) + zm * (h4 - h2);
        }
        if (xm < 1.0f - zm) {
            return h3 + xm * (h2 - h1) + (1.0f - zm) * (h1 - h3);
        }
        return h3 + xm * (h4 - h3) + (1.0f - zm) * (h2 - h4);
    }

    protected Triangle getTriangleAtPoint(float x, float z, Vector3f scale, Vector3f translation) {
        Triangle tri = this.getTriangleAtPoint(x, z);
        if (tri != null) {
            tri.get1().multLocal(scale).addLocal(translation);
            tri.get2().multLocal(scale).addLocal(translation);
            tri.get3().multLocal(scale).addLocal(translation);
        }
        return tri;
    }

    protected Triangle[] getGridTrianglesAtPoint(float x, float z, Vector3f scale, Vector3f translation) {
        Triangle[] tris = this.getGridTrianglesAtPoint(x, z);
        if (tris != null) {
            tris[0].get1().multLocal(scale).addLocal(translation);
            tris[0].get2().multLocal(scale).addLocal(translation);
            tris[0].get3().multLocal(scale).addLocal(translation);
            tris[1].get1().multLocal(scale).addLocal(translation);
            tris[1].get2().multLocal(scale).addLocal(translation);
            tris[1].get3().multLocal(scale).addLocal(translation);
        }
        return tris;
    }

    protected Triangle[] getGridTrianglesAtPoint(float x, float z) {
        int gridX = (int)x;
        int gridY = (int)z;
        int index = this.findClosestHeightIndex(gridX, gridY);
        if (index < 0) {
            return null;
        }
        Triangle t = new Triangle(new Vector3f(), new Vector3f(), new Vector3f());
        Triangle t2 = new Triangle(new Vector3f(), new Vector3f(), new Vector3f());
        float h1 = this.hdata[index];
        float h2 = this.hdata[index + 1];
        float h3 = this.hdata[index + this.width];
        float h4 = this.hdata[index + this.width + 1];
        if (gridX == 0 && gridY == 0 || gridX == this.width - 2 && gridY == this.width - 2) {
            t.get((int)0).x = gridX;
            t.get((int)0).y = h1;
            t.get((int)0).z = gridY;
            t.get((int)1).x = gridX;
            t.get((int)1).y = h3;
            t.get((int)1).z = gridY + 1;
            t.get((int)2).x = gridX + 1;
            t.get((int)2).y = h4;
            t.get((int)2).z = gridY + 1;
            t2.get((int)0).x = gridX;
            t2.get((int)0).y = h1;
            t2.get((int)0).z = gridY;
            t2.get((int)1).x = gridX + 1;
            t2.get((int)1).y = h4;
            t2.get((int)1).z = gridY + 1;
            t2.get((int)2).x = gridX + 1;
            t2.get((int)2).y = h2;
            t2.get((int)2).z = gridY;
        } else {
            t.get((int)0).x = gridX;
            t.get((int)0).y = h1;
            t.get((int)0).z = gridY;
            t.get((int)1).x = gridX;
            t.get((int)1).y = h3;
            t.get((int)1).z = gridY + 1;
            t.get((int)2).x = gridX + 1;
            t.get((int)2).y = h2;
            t.get((int)2).z = gridY;
            t2.get((int)0).x = gridX + 1;
            t2.get((int)0).y = h2;
            t2.get((int)0).z = gridY;
            t2.get((int)1).x = gridX;
            t2.get((int)1).y = h3;
            t2.get((int)1).z = gridY + 1;
            t2.get((int)2).x = gridX + 1;
            t2.get((int)2).y = h4;
            t2.get((int)2).z = gridY + 1;
        }
        return new Triangle[]{t, t2};
    }

    protected Triangle getTriangleAtPoint(float x, float z) {
        Triangle[] triangles = this.getGridTrianglesAtPoint(x, z);
        if (triangles == null) {
            return null;
        }
        Vector2f t1 = new Vector2f(triangles[0].get1().x, triangles[0].get1().z);
        Vector2f t2 = new Vector2f(triangles[0].get2().x, triangles[0].get2().z);
        Vector2f t3 = new Vector2f(triangles[0].get3().x, triangles[0].get3().z);
        Vector2f point = new Vector2f(x, z);
        if (0 != FastMath.pointInsideTriangle(t1, t2, t3, point)) {
            return triangles[0];
        }
        t1.set(triangles[1].get1().x, triangles[1].get1().z);
        t1.set(triangles[1].get2().x, triangles[1].get2().z);
        t1.set(triangles[1].get3().x, triangles[1].get3().z);
        if (0 != FastMath.pointInsideTriangle(t1, t2, t3, point)) {
            return triangles[1];
        }
        return null;
    }

    protected int findClosestHeightIndex(int x, int z) {
        if (x < 0 || x >= this.width - 1) {
            return -1;
        }
        if (z < 0 || z >= this.width - 1) {
            return -1;
        }
        return z * this.width + x;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
    }

    public class VerboseBuffer {
        private IndexBuffer delegate;
        int count = 0;

        public VerboseBuffer(IndexBuffer d) {
            this.delegate = d;
        }

        public void put(int value) {
            this.delegate.put(this.count, value);
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

