/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.util.logging.Logger;

public class ParticleDepositionHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(ParticleDepositionHeightMap.class.getName());
    private int jumps;
    private int peakWalk;
    private int minParticles;
    private int maxParticles;
    private float caldera;

    public ParticleDepositionHeightMap(int size, int jumps, int peakWalk, int minParticles, int maxParticles, float caldera) throws Exception {
        if (size <= 0 || jumps < 0 || peakWalk < 0 || minParticles > maxParticles || minParticles < 0 || maxParticles < 0) {
            throw new Exception("values must be greater than zero, and minParticles must be greater than maxParticles");
        }
        if (caldera < 0.0f || caldera > 1.0f) {
            throw new Exception("Caldera level must be between 0 and 1");
        }
        this.size = size;
        this.jumps = jumps;
        this.peakWalk = peakWalk;
        this.minParticles = minParticles;
        this.maxParticles = maxParticles;
        this.caldera = caldera;
        this.load();
    }

    public boolean load() {
        int i;
        int[] dx = new int[]{0, 1, 0, this.size - 1, 1, 1, this.size - 1, this.size - 1};
        int[] dy = new int[]{1, 0, this.size - 1, 0, this.size - 1, 1, this.size - 1, 1};
        float[][] tempBuffer = new float[this.size][this.size];
        int[][] calderaMap = new int[this.size][this.size];
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        for (i = 0; i < this.jumps; ++i) {
            int ty;
            int tx;
            boolean done;
            int sy;
            int sx;
            int x = (int)Math.rint(Math.random() * (double)(this.size - 1));
            int y = (int)Math.rint(Math.random() * (double)(this.size - 1));
            int calderaX = x;
            int calderaY = y;
            int numberParticles = (int)Math.rint(Math.random() * (double)(this.maxParticles - this.minParticles) + (double)this.minParticles);
            for (int j = 0; j < numberParticles; ++j) {
                int m;
                if (this.peakWalk != 0 && j % this.peakWalk == 0) {
                    m = (int)Math.rint(Math.random() * 7.0);
                    x = (x + dx[m] + this.size) % this.size;
                    y = (y + dy[m] + this.size) % this.size;
                }
                float[] fArray = tempBuffer[x];
                int n = y;
                fArray[n] = fArray[n] + 1.0f;
                sx = x;
                sy = y;
                done = false;
                block2: while (!done) {
                    done = true;
                    m = (int)Math.rint(Math.random() * 8.0);
                    for (int jj = 0; jj < 8; ++jj) {
                        tx = (sx + dx[(jj + m) % 8]) % this.size;
                        ty = (sy + dy[(jj + m) % 8]) % this.size;
                        if (!(tempBuffer[tx][ty] + 1.0f < tempBuffer[sx][sy])) continue;
                        float[] fArray2 = tempBuffer[tx];
                        int n2 = ty;
                        fArray2[n2] = fArray2[n2] + 1.0f;
                        float[] fArray3 = tempBuffer[sx];
                        int n3 = sy;
                        fArray3[n3] = fArray3[n3] - 1.0f;
                        sx = tx;
                        sy = ty;
                        done = false;
                        continue block2;
                    }
                }
                if (!(tempBuffer[sx][sy] > tempBuffer[calderaX][calderaY])) continue;
                calderaX = sx;
                calderaY = sy;
            }
            float calderaStartPoint = tempBuffer[calderaX][calderaY];
            float cutoff = calderaStartPoint * (1.0f - this.caldera);
            int minx = calderaX;
            int maxx = calderaX;
            int miny = calderaY;
            int maxy = calderaY;
            calderaMap[calderaX][calderaY] = 1;
            done = false;
            while (!done) {
                done = true;
                sx = minx;
                sy = miny;
                tx = maxx;
                ty = maxy;
                for (x = sx; x <= tx; ++x) {
                    for (y = sy; y <= ty; ++y) {
                        calderaX = (x + this.size) % this.size;
                        calderaY = (y + this.size) % this.size;
                        if (calderaMap[calderaX][calderaY] != 1) continue;
                        calderaMap[calderaX][calderaY] = 2;
                        if (!(tempBuffer[calderaX][calderaY] > cutoff) || !(tempBuffer[calderaX][calderaY] <= calderaStartPoint)) continue;
                        done = false;
                        tempBuffer[calderaX][calderaY] = 2.0f * cutoff - tempBuffer[calderaX][calderaY];
                        if (calderaMap[calderaX = (calderaX + 1) % this.size][calderaY] == 0) {
                            if (x + 1 > maxx) {
                                maxx = x + 1;
                            }
                            calderaMap[calderaX][calderaY] = 1;
                        }
                        if (calderaMap[calderaX = (calderaX + this.size - 2) % this.size][calderaY] == 0) {
                            if (x - 1 < minx) {
                                minx = x - 1;
                            }
                            calderaMap[calderaX][calderaY] = 1;
                        }
                        if (calderaMap[calderaX = (x + this.size) % this.size][calderaY = (calderaY + 1) % this.size] == 0) {
                            if (y + 1 > maxy) {
                                maxy = y + 1;
                            }
                            calderaMap[calderaX][calderaY] = 1;
                        }
                        if (calderaMap[calderaX][calderaY = (calderaY + this.size - 2) % this.size] != 0) continue;
                        if (y - 1 < miny) {
                            miny = y - 1;
                        }
                        calderaMap[calderaX][calderaY] = 1;
                    }
                }
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.setHeightAtPoint(tempBuffer[i][j], j, i);
            }
        }
        this.erodeTerrain();
        this.normalizeTerrain(NORMALIZE_RANGE);
        logger.fine("Created heightmap using Particle Deposition");
        return false;
    }

    public void setJumps(int jumps) throws Exception {
        if (jumps < 0) {
            throw new Exception("jumps must be positive");
        }
        this.jumps = jumps;
    }

    public void setPeakWalk(int peakWalk) throws Exception {
        if (peakWalk <= 0) {
            throw new Exception("peakWalk must be greater than zero");
        }
        this.peakWalk = peakWalk;
    }

    public void setCaldera(float caldera) throws Exception {
        if (caldera < 0.0f || caldera > 1.0f) {
            throw new Exception("Caldera level must be between 0 and 1");
        }
        this.caldera = caldera;
    }

    public void setMaxParticles(int maxParticles) {
        this.maxParticles = maxParticles;
    }

    public void setMinParticles(int minParticles) throws Exception {
        if (minParticles > this.maxParticles) {
            throw new Exception("minParticles must be less than the current maxParticles");
        }
        this.minParticles = minParticles;
    }
}

