/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ShaderUtils {
    public static final float[] i2c(int color) {
        return new float[]{(float)(color & 0xFF0000) / 256.0f, (float)(color & 0xFF00) / 256.0f, (float)(color & 0xFF) / 256.0f, (float)(color & 0xFF000000) / 256.0f};
    }

    public static final int c2i(float[] color) {
        return (color.length == 4 ? (int)(color[3] * 256.0f) : -16777216) | (int)(color[0] * 256.0f) << 16 | (int)(color[1] * 256.0f) << 8 | (int)(color[2] * 256.0f);
    }

    public static final float mix(float a, float b, float f) {
        return (1.0f - f) * a + f * b;
    }

    public static final Color mix(Color a, Color b, float f) {
        return new Color((int)ShaderUtils.clamp(ShaderUtils.mix(a.getRed(), b.getRed(), f), 0.0f, 255.0f), (int)ShaderUtils.clamp(ShaderUtils.mix(a.getGreen(), b.getGreen(), f), 0.0f, 255.0f), (int)ShaderUtils.clamp(ShaderUtils.mix(a.getBlue(), b.getBlue(), f), 0.0f, 255.0f));
    }

    public static final int mix(int a, int b, float f) {
        return (int)((1.0f - f) * (float)a + f * (float)b);
    }

    public static final float[] mix(float[] c1, float[] c2, float f) {
        return new float[]{ShaderUtils.mix(c1[0], c2[0], f), ShaderUtils.mix(c1[1], c2[1], f), ShaderUtils.mix(c1[2], c2[2], f)};
    }

    public static final float step(float a, float x) {
        return x < a ? 0.0f : 1.0f;
    }

    public static final float boxstep(float a, float b, float x) {
        return ShaderUtils.clamp((x - a) / (b - a), 0.0f, 1.0f);
    }

    public static final float pulse(float a, float b, float x) {
        return ShaderUtils.step(a, x) - ShaderUtils.step(b, x);
    }

    public static final float clamp(float x, float a, float b) {
        return x < a ? a : (x > b ? b : x);
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final float abs(float x) {
        return x < 0.0f ? -x : x;
    }

    public static final float smoothstep(float a, float b, float x) {
        if (x < a) {
            return 0.0f;
        }
        if (x > b) {
            return 1.0f;
        }
        float xx = (x - a) / (b - a);
        return xx * xx * (3.0f - 2.0f * xx);
    }

    public static final float mod(float a, float b) {
        int n = (int)(a / b);
        float aa = a - (float)n * b;
        if (aa < 0.0f) {
            aa += b;
        }
        return aa;
    }

    public static final int floor(float x) {
        return x > 0.0f ? (int)x : (int)x - 1;
    }

    public static final float ceil(float x) {
        return (int)x + (x > 0.0f && x != (float)((int)x) ? 1 : 0);
    }

    public static final float spline(float x, float[] knot) {
        float CR00 = -0.5f;
        float CR01 = 1.5f;
        float CR02 = -1.5f;
        float CR03 = 0.5f;
        float CR10 = 1.0f;
        float CR11 = -2.5f;
        float CR12 = 2.0f;
        float CR13 = -0.5f;
        float CR20 = -0.5f;
        float CR21 = 0.0f;
        float CR22 = 0.5f;
        float CR23 = 0.0f;
        float CR30 = 0.0f;
        float CR31 = 1.0f;
        float CR32 = 0.0f;
        float CR33 = 0.0f;
        int nspans = knot.length - 3;
        if (nspans < 1) {
            throw new RuntimeException("Spline has too few knots.");
        }
        int span = (int)(x = ShaderUtils.clamp(x, 0.0f, 1.0f) * (float)nspans);
        if (span >= knot.length - 3) {
            span = knot.length - 3;
        }
        float c3 = CR00 * knot[span + 0] + CR01 * knot[span + 1] + CR02 * knot[span + 2] + CR03 * knot[span + 3];
        float c2 = CR10 * knot[span + 0] + CR11 * knot[span + 1] + CR12 * knot[span + 2] + CR13 * knot[span + 3];
        float c1 = CR20 * knot[span + 0] + CR21 * knot[span + 1] + CR22 * knot[span + 2] + CR23 * knot[span + 3];
        float c0 = CR30 * knot[span + 0] + CR31 * knot[span + 1] + CR32 * knot[span + 2] + CR33 * knot[span + 3];
        return ((c3 * (x -= (float)span) + c2) * x + c1) * x + c0;
    }

    public static final float[] spline(float x, float[][] knots) {
        float[] retval = new float[knots.length];
        for (int i = 0; i < knots.length; ++i) {
            retval[i] = ShaderUtils.spline(x, knots[i]);
        }
        return retval;
    }

    public static final float gammaCorrection(float gamma, float x) {
        return (float)Math.pow(x, 1.0f / gamma);
    }

    public static final float bias(float b, float x) {
        return (float)Math.pow(x, Math.log(b) / Math.log(0.5));
    }

    public static final float gain(float g, float x) {
        return (double)x < 0.5 ? ShaderUtils.bias(1.0f - g, 2.0f * x) / 2.0f : 1.0f - ShaderUtils.bias(1.0f - g, 2.0f - 2.0f * x) / 2.0f;
    }

    public static final float sinValue(float s, float minFreq, float maxFreq, float swidth) {
        float value = 0.0f;
        float cutoff = ShaderUtils.clamp(0.5f / swidth, 0.0f, maxFreq);
        float f = minFreq;
        while ((double)f < 0.5 * (double)cutoff) {
            value = (float)((double)value + Math.sin(Math.PI * 2 * (double)f * (double)s) / (double)f);
            f *= 2.0f;
        }
        float fade = ShaderUtils.clamp(2.0f * (cutoff - f) / cutoff, 0.0f, 1.0f);
        value = (float)((double)value + (double)fade * Math.sin(Math.PI * 2 * (double)f * (double)s) / (double)f);
        return value;
    }

    public static final float length(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static final float[] rotate(float[] v, float[][] m) {
        float x = v[0] * m[0][0] + v[1] * m[0][1] + v[2] * m[0][2];
        float y = v[0] * m[1][0] + v[1] * m[1][1] + v[2] * m[1][2];
        float z = v[0] * m[2][0] + v[1] * m[2][1] + v[2] * m[2][2];
        return new float[]{x, y, z};
    }

    public static final float[][] calcRotationMatrix(float ax, float ay, float az) {
        float[][] retval = new float[3][3];
        float cax = (float)Math.cos(ax);
        float sax = (float)Math.sin(ax);
        float cay = (float)Math.cos(ay);
        float say = (float)Math.sin(ay);
        float caz = (float)Math.cos(az);
        float saz = (float)Math.sin(az);
        retval[0][0] = cay * caz;
        retval[0][1] = -cay * saz;
        retval[0][2] = say;
        retval[1][0] = sax * say * caz + cax * saz;
        retval[1][1] = -sax * say * saz + cax * caz;
        retval[1][2] = -sax * cay;
        retval[2][0] = -cax * say * caz + sax * saz;
        retval[2][1] = cax * say * saz + sax * caz;
        retval[2][2] = cax * cay;
        return retval;
    }

    public static final float[] normalize(float[] v) {
        float l = ShaderUtils.length(v);
        float[] r = new float[v.length];
        int i = 0;
        for (float vv : v) {
            r[i++] = vv / l;
        }
        return r;
    }

    public static final float length(float[] v) {
        float s = 0.0f;
        for (float vv : v) {
            s += vv * vv;
        }
        return (float)Math.sqrt(s);
    }

    public static final ByteBuffer getImageDataFromImage(BufferedImage bufferedImage) {
        BufferedImage bi = new BufferedImage(128, 64, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(bufferedImage, null, null);
        bufferedImage = bi;
        WritableRaster wr = bi.getRaster();
        DataBuffer db = wr.getDataBuffer();
        DataBufferInt dbi = (DataBufferInt)db;
        int[] data = dbi.getData();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put(data);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static float frac(float f) {
        return f - (float)ShaderUtils.floor(f);
    }

    public static float[] floor(float[] fs) {
        float[] retval = new float[fs.length];
        for (int i = 0; i < fs.length; ++i) {
            retval[i] = ShaderUtils.floor(fs[i]);
        }
        return retval;
    }
}

