/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.basis;

import com.jme3.terrain.noise.Basis;
import com.jme3.terrain.noise.modulator.Modulator;
import com.jme3.terrain.noise.modulator.NoiseModulator;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class Noise
implements Basis {
    protected List<Modulator> modulators = new ArrayList<Modulator>();
    protected float scale = 1.0f;

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public FloatBuffer getBuffer(float sx, float sy, float base, int size) {
        FloatBuffer retval = FloatBuffer.allocate(size * size);
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                retval.put(this.modulate((sx + (float)x) / (float)size, (sy + (float)y) / (float)size, base));
            }
        }
        return retval;
    }

    public float modulate(float x, float y, float z) {
        float retval = this.value(x, y, z);
        for (Modulator m : this.modulators) {
            if (!(m instanceof NoiseModulator)) continue;
            retval = m.value(retval);
        }
        return retval;
    }

    public Basis addModulator(Modulator modulator) {
        this.modulators.add(modulator);
        return this;
    }

    public Basis setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public float getScale() {
        return this.scale;
    }
}

