/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters.model;

import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.IntMap;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Comparator;
import jme3tools.converters.model.FloatToFixed;
import jme3tools.converters.model.strip.PrimitiveGroup;
import jme3tools.converters.model.strip.TriStrip;

public class ModelConverter {
    private static final PrimComparator primComp = new PrimComparator();

    public static void generateStrips(Mesh mesh, boolean stitch, boolean listOnly, int cacheSize, int minStripSize) {
        TriStrip ts = new TriStrip();
        ts.setStitchStrips(stitch);
        ts.setCacheSize(cacheSize);
        ts.setListsOnly(listOnly);
        ts.setMinStripSize(minStripSize);
        IndexBuffer ib = mesh.getIndicesAsList();
        int[] indices = new int[ib.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = ib.get(i);
        }
        PrimitiveGroup[] groups = ts.generateStrips(indices);
        Arrays.sort(groups, primComp);
        int numElements = 0;
        for (PrimitiveGroup group : groups) {
            numElements += group.numIndices;
        }
        VertexBuffer original = mesh.getBuffer(VertexBuffer.Type.Index);
        Buffer buf = VertexBuffer.createBuffer(original.getFormat(), original.getNumComponents(), numElements);
        original.updateData(buf);
        ib = mesh.getIndexBuffer();
        int curIndex = 0;
        int[] modeStart = new int[]{-1, -1, -1};
        int[] elementLengths = new int[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            PrimitiveGroup group = groups[i];
            elementLengths[i] = group.numIndices;
            if (modeStart[group.type] == -1) {
                modeStart[group.type] = i;
            }
            int[] trimmedIndices = group.getTrimmedIndices();
            for (int j = 0; j < trimmedIndices.length; ++j) {
                ib.put(curIndex + j, trimmedIndices[j]);
            }
            curIndex += group.numIndices;
        }
        if (modeStart[0] == -1 && modeStart[1] == 0 && modeStart[2] == -1 && elementLengths.length == 1) {
            original.compact(elementLengths[0]);
            mesh.setMode(Mesh.Mode.TriangleStrip);
        } else {
            mesh.setElementLengths(elementLengths);
            mesh.setModeStart(modeStart);
            mesh.setMode(Mesh.Mode.Hybrid);
        }
        mesh.updateCounts();
    }

    public static void optimize(Mesh mesh, boolean toFixed) {
        mesh.updateBound();
        mesh.updateCounts();
        mesh.setStatic();
        if (mesh.getBuffer(VertexBuffer.Type.Index) != null) {
            FloatToFixed.compressIndexBuffer(mesh);
            ModelConverter.generateStrips(mesh, false, false, 16, 0);
        }
        IntMap<VertexBuffer> bufs = mesh.getBuffers();
        for (IntMap.Entry<VertexBuffer> entry : bufs) {
            VertexBuffer vb = entry.getValue();
            if (vb == null || vb.getBufferType() == VertexBuffer.Type.Index || vb.getFormat() != VertexBuffer.Format.Float) continue;
            if (vb.getBufferType() == VertexBuffer.Type.Color) {
                vb = FloatToFixed.convertToUByte(vb);
                vb.setNormalized(true);
            } else if (toFixed) {
                vb = FloatToFixed.convertToFixed(vb);
            }
            mesh.clearBuffer(vb.getBufferType());
            mesh.setBuffer(vb);
        }
    }

    private static void optimizeScene(Spatial source, boolean toFixed) {
        if (source instanceof Geometry) {
            Geometry geom = (Geometry)source;
            Mesh mesh = geom.getMesh();
            ModelConverter.optimize(mesh, toFixed);
        } else if (source instanceof Node) {
            Node node = (Node)source;
            for (int i = node.getQuantity() - 1; i >= 0; --i) {
                Spatial child = node.getChild(i);
                ModelConverter.optimizeScene(child, toFixed);
            }
        }
    }

    public static void optimize(Spatial source, boolean toFixed) {
        ModelConverter.optimizeScene(source, toFixed);
        source.updateLogicalState(0.0f);
        source.updateGeometricState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrimComparator
    implements Comparator<PrimitiveGroup> {
        private PrimComparator() {
        }

        @Override
        public int compare(PrimitiveGroup g1, PrimitiveGroup g2) {
            if (g1.type < g2.type) {
                return -1;
            }
            if (g1.type > g2.type) {
                return 1;
            }
            return 0;
        }
    }
}

