/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Ray;
import com.jme3.math.Triangle;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jme3tools.optimize.FastOctnode;
import jme3tools.optimize.OCTTriangle;
import jme3tools.optimize.Octnode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Octree {
    private final ArrayList<OCTTriangle> allTris = new ArrayList();
    private final Geometry[] geoms;
    private final BoundingBox bbox;
    private Octnode root;
    private CollisionResults boundResults = new CollisionResults();

    private static List<Geometry> getGeometries(Spatial scene) {
        if (scene instanceof Geometry) {
            ArrayList<Geometry> geomList = new ArrayList<Geometry>(1);
            geomList.add((Geometry)scene);
            return geomList;
        }
        if (scene instanceof Node) {
            Node n = (Node)scene;
            ArrayList<Geometry> geoms = new ArrayList<Geometry>();
            for (Spatial child : n.getChildren()) {
                geoms.addAll(Octree.getGeometries(child));
            }
            return geoms;
        }
        throw new UnsupportedOperationException("Unsupported scene element class");
    }

    public Octree(Spatial scene) {
        scene.updateGeometricState();
        List<Geometry> geomsList = Octree.getGeometries(scene);
        this.geoms = new Geometry[geomsList.size()];
        geomsList.toArray(this.geoms);
        this.bbox = new BoundingBox();
        for (Geometry geom : this.geoms) {
            BoundingVolume bv = geom.getWorldBound();
            this.bbox.mergeLocal(bv);
        }
        float extent = Math.max(this.bbox.getXExtent(), Math.max(this.bbox.getYExtent(), this.bbox.getZExtent()));
        this.bbox.setXExtent(extent);
        this.bbox.setYExtent(extent);
        this.bbox.setZExtent(extent);
        Triangle t = new Triangle();
        for (int g = 0; g < this.geoms.length; ++g) {
            Mesh m = this.geoms[g].getMesh();
            for (int i = 0; i < m.getTriangleCount(); ++i) {
                m.getTriangle(i, t);
                OCTTriangle ot = new OCTTriangle(t.get1(), t.get2(), t.get3(), i, g);
                this.allTris.add(ot);
            }
        }
    }

    public void construct(int maxDepth, float maxVolume, int minTrisPerNode) {
        this.root = new Octnode(this.bbox, this.allTris);
        this.root.subdivide(maxDepth, maxVolume, minTrisPerNode);
        this.root.collectTriangles(this.geoms);
    }

    public void createFastOctnodes(List<Geometry> globalGeomList) {
        this.root.createFastOctnode(globalGeomList);
    }

    public BoundingBox getBound() {
        return this.bbox;
    }

    public FastOctnode getFastRoot() {
        return this.root.fastNode;
    }

    public void generateFastOctnodeLinks() {
        this.root.generateFastOctnodeLinks(null, null, 0);
    }

    public void generateRenderSet(Set<Geometry> renderSet, Camera cam) {
        this.root.generateRenderSet(renderSet, cam);
    }

    public void renderBounds(RenderQueue rq, Matrix4f transform, WireBox box, Material mat) {
        this.root.renderBounds(rq, transform, box, mat);
    }

    public void intersect(Ray r, float farPlane, Geometry[] geoms, CollisionResults results) {
        this.boundResults.clear();
        this.bbox.collideWith(r, this.boundResults);
        if (this.boundResults.size() > 0) {
            float tMin = this.boundResults.getClosestCollision().getDistance();
            float tMax = this.boundResults.getFarthestCollision().getDistance();
            tMin = Math.max(tMin, 0.0f);
            tMax = Math.min(tMax, farPlane);
            this.root.intersectWhere(r, geoms, tMin, tMax, results);
        }
    }
}

