/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.Bone;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix4f;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;

public final class Skeleton
implements Savable {
    private Bone[] rootBones;
    private Bone[] boneList;
    private transient Matrix4f[] skinningMatrixes;

    public Skeleton(Bone[] boneList) {
        int i;
        this.boneList = boneList;
        ArrayList<Bone> rootBoneList = new ArrayList<Bone>();
        for (i = boneList.length - 1; i >= 0; --i) {
            Bone b = boneList[i];
            if (b.getParent() != null) continue;
            rootBoneList.add(b);
        }
        this.rootBones = rootBoneList.toArray(new Bone[rootBoneList.size()]);
        this.createSkinningMatrices();
        for (i = this.rootBones.length - 1; i >= 0; --i) {
            Bone rootBone = this.rootBones[i];
            rootBone.update();
            rootBone.setBindingPose();
        }
    }

    public Skeleton(Skeleton source) {
        int i;
        Bone[] sourceList = source.boneList;
        this.boneList = new Bone[sourceList.length];
        for (i = 0; i < sourceList.length; ++i) {
            this.boneList[i] = new Bone(sourceList[i]);
        }
        this.rootBones = new Bone[source.rootBones.length];
        for (i = 0; i < this.rootBones.length; ++i) {
            this.rootBones[i] = this.recreateBoneStructure(source.rootBones[i]);
        }
        this.createSkinningMatrices();
        for (i = this.rootBones.length - 1; i >= 0; --i) {
            this.rootBones[i].update();
        }
    }

    public Skeleton() {
    }

    private void createSkinningMatrices() {
        this.skinningMatrixes = new Matrix4f[this.boneList.length];
        for (int i = 0; i < this.skinningMatrixes.length; ++i) {
            this.skinningMatrixes[i] = new Matrix4f();
        }
    }

    private Bone recreateBoneStructure(Bone sourceRoot) {
        Bone targetRoot = this.getBone(sourceRoot.getName());
        ArrayList<Bone> children = sourceRoot.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Bone sourceChild = (Bone)children.get(i);
            Bone targetChild = this.getBone(sourceChild.getName());
            targetRoot.addChild(targetChild);
            this.recreateBoneStructure(sourceChild);
        }
        return targetRoot;
    }

    public void updateWorldVectors() {
        for (int i = this.rootBones.length - 1; i >= 0; --i) {
            this.rootBones[i].update();
        }
    }

    public void setBindingPose() {
        for (int i = this.rootBones.length - 1; i >= 0; --i) {
            this.rootBones[i].setBindingPose();
        }
    }

    public final void reset() {
        for (int i = this.rootBones.length - 1; i >= 0; --i) {
            this.rootBones[i].reset();
        }
    }

    public final void resetAndUpdate() {
        for (int i = this.rootBones.length - 1; i >= 0; --i) {
            Bone rootBone = this.rootBones[i];
            rootBone.reset();
            rootBone.update();
        }
    }

    public Bone[] getRoots() {
        return this.rootBones;
    }

    public Bone getBone(int index) {
        return this.boneList[index];
    }

    public Bone getBone(String name) {
        for (int i = 0; i < this.boneList.length; ++i) {
            if (!this.boneList[i].getName().equals(name)) continue;
            return this.boneList[i];
        }
        return null;
    }

    public int getBoneIndex(Bone bone) {
        for (int i = 0; i < this.boneList.length; ++i) {
            if (this.boneList[i] != bone) continue;
            return i;
        }
        return -1;
    }

    public int getBoneIndex(String name) {
        for (int i = 0; i < this.boneList.length; ++i) {
            if (!this.boneList[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Matrix4f[] computeSkinningMatrices() {
        TempVars vars = TempVars.get();
        for (int i = 0; i < this.boneList.length; ++i) {
            this.boneList[i].getOffsetTransform(this.skinningMatrixes[i], vars.quat1, vars.vect1, vars.vect2, vars.tempMat3);
        }
        vars.release();
        return this.skinningMatrixes;
    }

    public int getBoneCount() {
        return this.boneList.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Skeleton - ").append(this.boneList.length).append(" bones, ").append(this.rootBones.length).append(" roots\n");
        for (Bone rootBone : this.rootBones) {
            sb.append(rootBone.toString());
        }
        return sb.toString();
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule input = im.getCapsule(this);
        Savable[] boneRootsAsSav = input.readSavableArray("rootBones", null);
        this.rootBones = new Bone[boneRootsAsSav.length];
        System.arraycopy(boneRootsAsSav, 0, this.rootBones, 0, boneRootsAsSav.length);
        Savable[] boneListAsSavable = input.readSavableArray("boneList", null);
        this.boneList = new Bone[boneListAsSavable.length];
        System.arraycopy(boneListAsSavable, 0, this.boneList, 0, boneListAsSavable.length);
        this.createSkinningMatrices();
        for (Bone rootBone : this.rootBones) {
            rootBone.update();
            rootBone.setBindingPose();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule output = ex.getCapsule(this);
        output.write(this.rootBones, "rootBones", null);
        output.write(this.boneList, "boneList", null);
    }
}

