/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssetConfig {
    private AssetManager manager;

    public AssetConfig(AssetManager manager) {
        this.manager = manager;
    }

    public void loadText(InputStream in) throws IOException {
        Scanner scan = new Scanner(in);
        while (scan.hasNext()) {
            String cmd = scan.next();
            if (cmd.equals("LOADER")) {
                String loaderClass = scan.next();
                String colon = scan.next();
                if (!colon.equals(":")) {
                    throw new IOException("Expected ':', got '" + colon + "'");
                }
                String extensionsList = scan.nextLine();
                String[] extensions = extensionsList.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
                Class clazz = this.acquireClass(loaderClass);
                if (clazz != null) {
                    this.manager.registerLoader(clazz, extensions);
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot find loader {0}", loaderClass);
                continue;
            }
            if (cmd.equals("LOCATOR")) {
                String rootPath = scan.next();
                String locatorClass = scan.nextLine().trim();
                Class clazz = this.acquireClass(locatorClass);
                if (clazz != null) {
                    this.manager.registerLocator(rootPath, clazz);
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot find locator {0}", locatorClass);
                continue;
            }
            throw new IOException("Expected command, got '" + cmd + "'");
        }
    }

    private Class acquireClass(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

