/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.plugins;

import com.jme3.util.IntMap;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedOggStream
implements PhysicalOggStream {
    private boolean closed = false;
    private boolean eos = false;
    private boolean bos = false;
    private InputStream sourceStream;
    private HashMap<Integer, LogicalOggStream> logicalStreams = new HashMap();
    private IntMap<OggPage> oggPages = new IntMap();
    private OggPage lastPage;
    private int pageNumber;

    public CachedOggStream(InputStream in) throws IOException {
        this.sourceStream = in;
        long time = System.nanoTime();
        while (!this.eos) {
            this.readOggNextPage();
        }
        long dt = System.nanoTime() - time;
        Logger.getLogger(CachedOggStream.class.getName()).log(Level.FINE, "Took {0} ms to load OGG", dt / 1000000L);
    }

    public OggPage getLastOggPage() {
        return this.lastPage;
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return this.logicalStreams.get(serialNumber);
    }

    @Override
    public Collection<LogicalOggStream> getLogicalStreams() {
        return this.logicalStreams.values();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    @Override
    public OggPage getOggPage(int index) throws IOException {
        return this.oggPages.get(index);
    }

    @Override
    public void setTime(long granulePosition) throws IOException {
        for (LogicalOggStream los : this.getLogicalStreams()) {
            los.setTime(granulePosition);
        }
    }

    private int readOggNextPage() throws IOException {
        LogicalOggStreamImpl los;
        if (this.eos) {
            return -1;
        }
        OggPage op = OggPage.create(this.sourceStream);
        if (!op.isBos()) {
            this.bos = true;
        }
        if (op.isEos()) {
            this.eos = true;
            this.lastPage = op;
        }
        if ((los = (LogicalOggStreamImpl)this.logicalStreams.get(op.getStreamSerialNumber())) == null) {
            los = new LogicalOggStreamImpl(this, op.getStreamSerialNumber());
            this.logicalStreams.put(op.getStreamSerialNumber(), los);
            los.checkFormat(op);
        }
        los.addPageNumberMapping(this.pageNumber);
        los.addGranulePosition(op.getAbsoluteGranulePosition());
        this.oggPages.put(this.pageNumber, op);
        ++this.pageNumber;
        return this.pageNumber - 1;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }
}

