/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundCollisionShape
extends CollisionShape {
    protected ArrayList<ChildCollisionShape> children = new ArrayList();

    public CompoundCollisionShape() {
        this.cShape = new CompoundShape();
    }

    public void addChildShape(CollisionShape shape, Vector3f location) {
        Transform transA = new Transform(Converter.convert(new Matrix3f()));
        Converter.convert(location, transA.origin);
        this.children.add(new ChildCollisionShape(location.clone(), new Matrix3f(), shape));
        ((CompoundShape)this.cShape).addChildShape(transA, shape.getCShape());
    }

    public void addChildShape(CollisionShape shape, Vector3f location, Matrix3f rotation) {
        if (shape instanceof CompoundCollisionShape) {
            throw new IllegalStateException("CompoundCollisionShapes cannot have CompoundCollisionShapes as children!");
        }
        Transform transA = new Transform(Converter.convert(rotation));
        Converter.convert(location, transA.origin);
        Converter.convert(rotation, transA.basis);
        this.children.add(new ChildCollisionShape(location.clone(), rotation.clone(), shape));
        ((CompoundShape)this.cShape).addChildShape(transA, shape.getCShape());
    }

    private void addChildShapeDirect(CollisionShape shape, Vector3f location, Matrix3f rotation) {
        if (shape instanceof CompoundCollisionShape) {
            throw new IllegalStateException("CompoundCollisionShapes cannot have CompoundCollisionShapes as children!");
        }
        Transform transA = new Transform(Converter.convert(rotation));
        Converter.convert(location, transA.origin);
        Converter.convert(rotation, transA.basis);
        ((CompoundShape)this.cShape).addChildShape(transA, shape.getCShape());
    }

    public void removeChildShape(CollisionShape shape) {
        ((CompoundShape)this.cShape).removeChildShape(shape.getCShape());
        Iterator<ChildCollisionShape> it = this.children.iterator();
        while (it.hasNext()) {
            ChildCollisionShape childCollisionShape = it.next();
            if (childCollisionShape.shape != shape) continue;
            it.remove();
        }
    }

    public List<ChildCollisionShape> getChildren() {
        return this.children;
    }

    @Override
    public void setScale(Vector3f scale) {
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "CompoundCollisionShape cannot be scaled");
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.writeSavableArrayList(this.children, "children", new ArrayList());
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule(this);
        this.children = capsule.readSavableArrayList("children", new ArrayList());
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
        this.loadChildren();
    }

    private void loadChildren() {
        for (ChildCollisionShape child : this.children) {
            this.addChildShapeDirect(child.shape, child.location, child.rotation);
        }
    }
}

