/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.CylinderShape;
import com.bulletphysics.collision.shapes.CylinderShapeX;
import com.bulletphysics.collision.shapes.CylinderShapeZ;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CylinderCollisionShape
extends CollisionShape {
    protected Vector3f halfExtents;
    protected int axis;

    public CylinderCollisionShape() {
    }

    public CylinderCollisionShape(Vector3f halfExtents) {
        this.halfExtents = halfExtents;
        this.axis = 2;
        this.createShape();
    }

    public CylinderCollisionShape(Vector3f halfExtents, int axis) {
        this.halfExtents = halfExtents;
        this.axis = axis;
        this.createShape();
    }

    public final Vector3f getHalfExtents() {
        return this.halfExtents;
    }

    public int getAxis() {
        return this.axis;
    }

    public void setScale(Vector3f scale) {
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "CylinderCollisionShape cannot be scaled");
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.halfExtents, "halfExtents", new Vector3f(0.5f, 0.5f, 0.5f));
        capsule.write(this.axis, "axis", 1);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule(this);
        this.halfExtents = (Vector3f)capsule.readSavable("halfExtents", new Vector3f(0.5f, 0.5f, 0.5f));
        this.axis = capsule.readInt("axis", 1);
        this.createShape();
    }

    protected void createShape() {
        switch (this.axis) {
            case 0: {
                this.cShape = new CylinderShapeX(Converter.convert(this.halfExtents));
                break;
            }
            case 1: {
                this.cShape = new CylinderShape(Converter.convert(this.halfExtents));
                break;
            }
            case 2: {
                this.cShape = new CylinderShapeZ(Converter.convert(this.halfExtents));
            }
        }
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

