/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.IndexedMesh;
import com.bulletphysics.collision.shapes.TriangleIndexVertexArray;
import com.bulletphysics.extras.gimpact.GImpactMeshShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GImpactCollisionShape
extends CollisionShape {
    protected Vector3f worldScale;
    protected int numVertices;
    protected int numTriangles;
    protected int vertexStride;
    protected int triangleIndexStride;
    protected ByteBuffer triangleIndexBase;
    protected ByteBuffer vertexBase;
    protected IndexedMesh bulletMesh;

    public GImpactCollisionShape() {
    }

    public GImpactCollisionShape(Mesh mesh) {
        this.createCollisionMesh(mesh, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    private void createCollisionMesh(Mesh mesh, Vector3f worldScale) {
        this.worldScale = worldScale;
        this.bulletMesh = Converter.convert(mesh);
        this.numVertices = this.bulletMesh.numVertices;
        this.numTriangles = this.bulletMesh.numTriangles;
        this.vertexStride = this.bulletMesh.vertexStride;
        this.triangleIndexStride = this.bulletMesh.triangleIndexStride;
        this.triangleIndexBase = this.bulletMesh.triangleIndexBase;
        this.vertexBase = this.bulletMesh.vertexBase;
        this.createShape();
    }

    public Mesh createJmeMesh() {
        return Converter.convert(this.bulletMesh);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.worldScale, "worldScale", new Vector3f(1.0f, 1.0f, 1.0f));
        capsule.write(this.numVertices, "numVertices", 0);
        capsule.write(this.numTriangles, "numTriangles", 0);
        capsule.write(this.vertexStride, "vertexStride", 0);
        capsule.write(this.triangleIndexStride, "triangleIndexStride", 0);
        capsule.write(this.triangleIndexBase.array(), "triangleIndexBase", new byte[0]);
        capsule.write(this.vertexBase.array(), "vertexBase", new byte[0]);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule(this);
        this.worldScale = (Vector3f)capsule.readSavable("worldScale", new Vector3f(1.0f, 1.0f, 1.0f));
        this.numVertices = capsule.readInt("numVertices", 0);
        this.numTriangles = capsule.readInt("numTriangles", 0);
        this.vertexStride = capsule.readInt("vertexStride", 0);
        this.triangleIndexStride = capsule.readInt("triangleIndexStride", 0);
        this.triangleIndexBase = ByteBuffer.wrap(capsule.readByteArray("triangleIndexBase", new byte[0]));
        this.vertexBase = ByteBuffer.wrap(capsule.readByteArray("vertexBase", new byte[0]));
        this.createShape();
    }

    protected void createShape() {
        this.bulletMesh = new IndexedMesh();
        this.bulletMesh.numVertices = this.numVertices;
        this.bulletMesh.numTriangles = this.numTriangles;
        this.bulletMesh.vertexStride = this.vertexStride;
        this.bulletMesh.triangleIndexStride = this.triangleIndexStride;
        this.bulletMesh.triangleIndexBase = this.triangleIndexBase;
        this.bulletMesh.vertexBase = this.vertexBase;
        this.bulletMesh.triangleIndexBase = this.triangleIndexBase;
        TriangleIndexVertexArray tiv = new TriangleIndexVertexArray(this.numTriangles, this.triangleIndexBase, this.triangleIndexStride, this.numVertices, this.vertexBase, this.vertexStride);
        this.cShape = new GImpactMeshShape(tiv);
        this.cShape.setLocalScaling(Converter.convert(this.worldScale));
        ((GImpactMeshShape)this.cShape).updateBound();
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

