/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.BU_Simplex1to4;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class SimplexCollisionShape
extends CollisionShape {
    private Vector3f vector1;
    private Vector3f vector2;
    private Vector3f vector3;
    private Vector3f vector4;

    public SimplexCollisionShape() {
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2, Vector3f point3, Vector3f point4) {
        this.vector1 = point1;
        this.vector2 = point2;
        this.vector3 = point3;
        this.vector4 = point4;
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2, Vector3f point3) {
        this.vector1 = point1;
        this.vector2 = point2;
        this.vector3 = point3;
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1, Vector3f point2) {
        this.vector1 = point1;
        this.vector2 = point2;
        this.createShape();
    }

    public SimplexCollisionShape(Vector3f point1) {
        this.vector1 = point1;
        this.createShape();
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.vector1, "simplexPoint1", null);
        capsule.write(this.vector2, "simplexPoint2", null);
        capsule.write(this.vector3, "simplexPoint3", null);
        capsule.write(this.vector4, "simplexPoint4", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule(this);
        this.vector1 = (Vector3f)capsule.readSavable("simplexPoint1", null);
        this.vector2 = (Vector3f)capsule.readSavable("simplexPoint2", null);
        this.vector3 = (Vector3f)capsule.readSavable("simplexPoint3", null);
        this.vector4 = (Vector3f)capsule.readSavable("simplexPoint4", null);
        this.createShape();
    }

    protected void createShape() {
        this.cShape = this.vector4 != null ? new BU_Simplex1to4(Converter.convert(this.vector1), Converter.convert(this.vector2), Converter.convert(this.vector3), Converter.convert(this.vector4)) : (this.vector3 != null ? new BU_Simplex1to4(Converter.convert(this.vector1), Converter.convert(this.vector2), Converter.convert(this.vector3)) : (this.vector2 != null ? new BU_Simplex1to4(Converter.convert(this.vector1), Converter.convert(this.vector2)) : new BU_Simplex1to4(Converter.convert(this.vector1))));
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

