/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;

public class BulletCharacterDebugControl
extends AbstractPhysicsDebugControl {
    protected final PhysicsCharacter body;
    protected final Vector3f location = new Vector3f();
    protected final Quaternion rotation = new Quaternion();
    protected CollisionShape myShape;
    protected Spatial geom;

    public BulletCharacterDebugControl(BulletDebugAppState debugAppState, PhysicsCharacter body) {
        super(debugAppState);
        this.body = body;
        this.myShape = body.getCollisionShape();
        this.geom = DebugShapeFactory.getDebugShape(body.getCollisionShape());
        this.geom.setMaterial(debugAppState.DEBUG_PINK);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial != null && spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild(this.geom);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild(this.geom);
        }
        super.setSpatial(spatial);
    }

    protected void controlUpdate(float tpf) {
        if (this.myShape != this.body.getCollisionShape()) {
            Node node = (Node)this.spatial;
            node.detachChild(this.geom);
            this.geom = DebugShapeFactory.getDebugShape(this.body.getCollisionShape());
            this.geom.setMaterial(this.debugAppState.DEBUG_PINK);
            node.attachChild(this.geom);
        }
        this.applyPhysicsTransform(this.body.getPhysicsLocation(this.location), Quaternion.IDENTITY);
        this.geom.setLocalScale(this.body.getCollisionShape().getScale());
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

