/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;

public class BulletJointDebugControl
extends AbstractPhysicsDebugControl {
    protected final PhysicsJoint body;
    protected final Geometry geomA;
    protected final Arrow arrowA;
    protected final Geometry geomB;
    protected final Arrow arrowB;
    protected final Transform a = new Transform(new Vector3f(), new Quaternion());
    protected final Transform b = new Transform(new Vector3f(), new Quaternion());
    protected final Vector3f offA = new Vector3f();
    protected final Vector3f offB = new Vector3f();

    public BulletJointDebugControl(BulletDebugAppState debugAppState, PhysicsJoint body) {
        super(debugAppState);
        this.body = body;
        this.geomA = new Geometry(body.toString());
        this.arrowA = new Arrow(Vector3f.ZERO);
        this.geomA.setMesh(this.arrowA);
        this.geomA.setMaterial(debugAppState.DEBUG_GREEN);
        this.geomB = new Geometry(body.toString());
        this.arrowB = new Arrow(Vector3f.ZERO);
        this.geomB.setMesh(this.arrowB);
        this.geomB.setMaterial(debugAppState.DEBUG_GREEN);
    }

    public void setSpatial(Spatial spatial) {
        if (spatial != null && spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild(this.geomA);
            node.attachChild(this.geomB);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild(this.geomA);
            node.detachChild(this.geomB);
        }
        super.setSpatial(spatial);
    }

    protected void controlUpdate(float tpf) {
        this.body.getBodyA().getPhysicsLocation(this.a.getTranslation());
        this.body.getBodyA().getPhysicsRotation(this.a.getRotation());
        this.body.getBodyB().getPhysicsLocation(this.b.getTranslation());
        this.body.getBodyB().getPhysicsRotation(this.b.getRotation());
        this.geomA.setLocalTransform(this.a);
        this.geomB.setLocalTransform(this.b);
        this.arrowA.setArrowExtent(this.body.getPivotA());
        this.arrowB.setArrowExtent(this.body.getPivotB());
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

